//	$Id: FFThumbView.h 558 2006-08-20 14:12:46Z ravemax $

typedef struct {
	NSImage*	img;
	NSString*	name;
	NSString*	desc;
	NSPoint 	origin;
} FFThumb;

#define THUMB_NOT_LOADED(TBPTR) (TBPTR->img == NULL)

@interface FFThumbView : NSView {
	IBOutlet id			m_dataSrc;
	IBOutlet id			m_delegate;
	
	float		m_thumbWidth, m_thumbHeight;
	float		m_adjustY;
	NSColor*	m_bgCol;
	NSImage*	m_markImg;
	NSRect		m_markRect;
	unsigned	m_markedThumbIndex;
	unsigned	m_numRows, m_numCols;
	float		m_spaceBtwThumbs;
	unsigned	m_mouseDownIndex;
	BOOL		m_mouseDrag;
	NSImage*	m_selectionImg;
	int			m_prevSelectedImg;
}

- (void)setDataSource:(id)dataSrc;
- (void)setSelectionImage:(NSImage*)img;
- (void)reload;
- (void)updateSelection;
- (NSColor*)backgroundColor;
- (void)thumbLoaded:(FFThumb*)thumb;

@end

#pragma mark -

@interface NSObject (FFThumbViewDataSource)

- (unsigned)numberOfThumbsInThumbView:(FFThumbView*)tv;
- (FFThumb*)thumbView:(FFThumbView*)tv thumbAtIndex:(unsigned)index;
- (int)selectedImageIndex;

@end

#pragma mark -

@interface NSObject (FFThumbViewDelegate)

- (void)thumbViewDidClickThumbWithIndex:(unsigned)index;
- (void)thumbViewDidMarkThumbWithIndex:(unsigned)index withCenter:(NSPoint)center;
- (void)thumbViewDidUnmarkThumb;
- (BOOL)thumbViewWillBeginDrag:(unsigned)index;
- (NSArray*)thumbViewNamesOfFilesDroppedAtDestination:(NSURL*)url;

@end
