RCS_ID("$Id: FFTextureTextField.m 430 2005-06-09 15:45:29Z ravemax $")

#import "FFTextureTextField.h"

@implementation FFTextureTextField

- (id)initWithCoder:(NSCoder*)decoder {
	self = [super initWithCoder:decoder];
	if (self != nil) {
		m_shadowAttribs = [[NSDictionary alloc] initWithObjectsAndKeys:
			[self font], NSFontAttributeName,
			[NSColor whiteColor], NSForegroundColorAttributeName,
			nil];
	}
	return self;
}

- (void)dealloc {
	[m_shadowAttribs release];
	[super dealloc];
}

- (void)drawRect:(NSRect)aRect {
	NSPoint sp = [self bounds].origin;
	sp.x += 1.0f;
	sp.y += 1.0f;
	if ([self alignment] != NSLeftTextAlignment) {
		float fwd = [self bounds].size.width;
		float swd = [[self stringValue] sizeWithAttributes:m_shadowAttribs].width;
		
		if ([self alignment] == NSCenterTextAlignment)
			sp.x += (fwd - swd) / 2;
		else // Right
			sp.x += fwd - swd;
	}
	[[self stringValue] drawAtPoint:sp withAttributes:m_shadowAttribs];
	
	[super drawRect:aRect];	
}

@end
