RCS_ID("$Id")

#import "FFSegmentedControl.h"

NSSegmentedControl* createSegmentedControl(int num, const NSString* images[], NSSegmentSwitchTracking tracking,
										   id target, SEL action) {
	NSSegmentedControl*	ctrl;
	NSSegmentedCell*	sc;
	int					i;
	
	ctrl = [[NSSegmentedControl alloc] initWithFrame:NSMakeRect(0, 0, num*32, 32)];
	
	sc = [ctrl cell];
	[sc setTrackingMode:tracking];
	[sc setControlSize:NSRegularControlSize];
	
	[ctrl setTarget:target];
	[ctrl setAction:action];
	
	[ctrl setSegmentCount:num];		
	
	for (i = 0; i < num; i++) {
		[ctrl setImage:[NSImage imageNamed:(NSString*)images[i]] forSegment:i];
		[ctrl setWidth:28 forSegment:i];
		[sc setTag:i forSegment:i];
	}
	
	return ctrl;
}
