RCS_ID("$Id")

#import "FFScriptMenu.h"
#import "FFOptions.h"
#import "FFInfoPanel.h"

@implementation FFScriptMenu

static NSString* ScriptSubDir			= @"Scripts";
static NSString* ScriptFileExtension	= @".scpt";

- (id)initWithAppDirectory:(NSString*)dir andOptions:(FFOptions*)opts {
	NSString*		fname;
	NSArray*		dcnt;
	NSEnumerator*	en;
	NSAppleScript*	script;
	NSDictionary*	err;
	
	self = [super init];
	if (self != nil) {
		m_opts		= opts; // Weak
		m_scripts	= [[NSMutableDictionary alloc] init];
		m_scriptDir	= [[[dir stringByExpandingTildeInPath] stringByAppendingPathComponent:ScriptSubDir] retain];
		dcnt		= [[NSFileManager defaultManager] directoryContentsAtPath:m_scriptDir];

		// Directory exists
		if (dcnt != nil) {
			en = [dcnt objectEnumerator];
			while (fname = [en nextObject]) {

				// Is a script...
				if ([fname hasSuffix:ScriptFileExtension]) {
					script = [[NSAppleScript alloc] initWithContentsOfURL:
						[NSURL fileURLWithPath:[m_scriptDir stringByAppendingPathComponent:fname]] error:&err];

					// Something went wrong
					if (script == nil)
						NSRunAlertPanel(FFTR(@"Script problem"),
										FFTRC(@"Failed to load the script '%@': %@", @"1=Filename, 2=Message"),
										@"Continue", nil, nil,
										fname, [err objectForKey:NSAppleScriptErrorBriefMessage]);
						
					// Add script
					else
						[m_scripts setObject:script forKey:[fname stringByDeletingPathExtension]];
				}
			}
		}
	}
	return self;
}

- (void)dealloc {
	[super dealloc];
	[m_scripts release];
}

- (NSEnumerator*)nameEnumerator {
	return [[[m_scripts allKeys] sortedArrayUsingSelector:@selector(compare:)] objectEnumerator];
}

- (BOOL)isKnownScript:(NSString*)name {
	return ([m_scripts objectForKey:name] != nil);
}

- (void)openScriptFolder {
	[[NSWorkspace sharedWorkspace] openFile:m_scriptDir];
}

- (void)executeScriptWithName:(NSString*)name {
	NSAppleScript*	script	= [m_scripts objectForKey:name];
	NSDictionary*	err;
	
	if ([script executeAndReturnError:&err] == nil) 
		[FFInfoPanel runInFullscreen:[m_opts fullscreen]
						   withTitle:FFTR(@"Failed to execute script")
							 message:[err objectForKey:NSAppleScriptErrorMessage]
						 andOkButton:FFTR(@"OK")];
}

- (void)executeScriptAttachedToMenuItem:(NSMenuItem*)item {
	[self executeScriptWithName:[item title]];
}

@end
