RCS_ID("$Id: FFEXIFController.m 458 2005-07-16 19:27:58Z ravemax $")
// Text formatting code by Ali Ozer - w/ minor modifications

#import "FFEXIFController.h"
#import <FFEXIF/FFEXIF.h>
#import "FFImageList.h"

@implementation FFEXIFController

static const NSString* TypeDesc[9]; // Filled in initialize

// Singleton
static FFEXIFController* exifCtrlInstance = nil;

+ (void)initialize {
	TypeDesc[0] = @"";
	TypeDesc[1] = FFTR(@"Unsupported Properties");
	TypeDesc[2] = FFTR(@"Camera-Specific Properties");
	TypeDesc[3] = @"";
	TypeDesc[4] = FFTR(@"Image-Specific Properties");
	TypeDesc[5] = @"";
	TypeDesc[6] = @"";
	TypeDesc[7] = @"";
	TypeDesc[8] = FFTR(@"Other Properties");
}

- (void)_setupParagraphStyleWithColonAtLocation:(float)loc {
    NSMutableArray*	tabs		= [NSMutableArray array];
    float			f;
	
	m_paraStyle = [[NSParagraphStyle defaultParagraphStyle] mutableCopy];
    
	[tabs addObject:[[[NSTextTab alloc] initWithType:NSRightTabStopType location:loc] autorelease]];
    [tabs addObject:[[[NSTextTab alloc] initWithType:NSLeftTabStopType location:loc + 5.0] autorelease]];
    for (f = loc + 10.0; f < loc + 40.0; f += 5.0)
		[tabs addObject:[[[NSTextTab alloc] initWithType:NSLeftTabStopType location:f] autorelease]];

	[m_paraStyle setTabStops:tabs];
    [m_paraStyle setFirstLineHeadIndent:0.0];
    [m_paraStyle setHeadIndent:loc + 5.0];
}

- (id)init {
	self = [super init];
	if (self) {
		[NSBundle loadNibNamed:@"EXIF" owner:self];
		
		// awakeFromNib
		m_textStorage = [m_text textStorage];
		
		[self _setupParagraphStyleWithColonAtLocation:190.0f];

		// The used fonts
		m_normalFont	= [[NSFont systemFontOfSize:10.0] retain];
		m_boldFont		= [[NSFont boldSystemFontOfSize:10.0] retain];
		
		// Now its OK to receive EXIF information
		setEXIFInfoHandler(self);		
	}
	return self;
}

- (void)dealloc {
	[m_paraStyle release];
	[m_normalFont release];
	[m_boldFont release];
	
	[super dealloc];
}

- (void)_loadEXIFData {
	NSString* errMsg;
	
	[m_text setString:@""]; // Clear

	if ([m_imgList numberOfImages] > 0) {
		[m_textStorage beginEditing];		
		switch (readEXIF([m_imgList fullPathAtIndex:[m_imgList selectedImageIndex]])) {
			case READ_RET_OK:
				errMsg = nil;
				break; // We are fine
			case READ_RET_FILE_NOT_FOUND:
				errMsg = FFTR(@"File not found");
				break;
			case READ_RET_NO_EXIF_DATA:
				errMsg = FFTR(@"No EXIF data");
				break;
			case READ_JPEG_ERROR:
				errMsg = FFTR(@"JPEG err");
				break;
			case READ_INTERNAL_ERROR:
				errMsg = FFTR(@"Internal error");
				break;
		}
		
		if (errMsg != nil)
			[m_textStorage replaceCharactersInRange:NSMakeRange([m_textStorage length], 0) withString:errMsg];
		
		[m_textStorage endEditing];				
	}
}

- (void)_showAndLoadFromImageList:(FFImageList*)imgList {
	m_imgList = imgList;
	
	if ([m_panel isVisible])
		return;
	
	NSNotificationCenter* nc = [NSNotificationCenter defaultCenter];
	
	[nc addObserver:self selector:@selector(_panelWillClosed:)
			   name:NSWindowWillCloseNotification object:m_panel];
	[nc addObserver:self selector:@selector(newImageSelected:)
			   name:NewImageSelectedNotification object:nil];

	[m_panel makeKeyAndOrderFront:self];
	[self _loadEXIFData];
}

+ (void)showPanelWithImageList:(FFImageList*)imgList {
	if (exifCtrlInstance == nil)
		exifCtrlInstance = [[FFEXIFController alloc] init];
	
	[exifCtrlInstance _showAndLoadFromImageList:imgList];
}

- (void)_panelWillClosed:(NSNotification*)_unused {
	// Deregister from all notifications
	[[NSNotificationCenter defaultCenter] removeObserver:self];
}

#pragma mark -
#pragma mark Image list notifications

- (void)newImageSelected:(NSNotification*)_unused {
	[self _loadEXIFData];
}

#pragma mark -
#pragma mark The EXIF Handler methods

- (void)beginOfInfoType:(FFEXIFInfoType)type {
	int			len = [m_textStorage length];
	NSString*	td	= [NSString stringWithFormat:@"\n%@:\n\n", TypeDesc[(int)type]];

	[m_textStorage replaceCharactersInRange:NSMakeRange([m_textStorage length], 0)
								 withString:td];
	[m_textStorage addAttribute:NSUnderlineStyleAttributeName 
						  value:[NSNumber numberWithInt:1] 
						  range:NSMakeRange(len, [td length]-2)];
}

// Format: "\t<name>:\t<value>
- (NSAttributedString *)_attributedResult:(NSString *)result {
	NSMutableAttributedString *attrExif = [[[NSMutableAttributedString alloc] initWithString:result] autorelease];
	
	// Set the font and tabs over the whole string
	[attrExif addAttribute:NSFontAttributeName value:m_normalFont range:NSMakeRange(0, [attrExif length])];
	[attrExif addAttribute:NSParagraphStyleAttributeName value:m_paraStyle range:NSMakeRange(0, [attrExif length])];
	
	// The rest of the code is to fix up the headers
	int length = [attrExif length];
	NSRange remainingRange = NSMakeRange(0, length); // Part of the string still to be processed		
		
	while (remainingRange.length) {
		NSMutableString*	str	= [attrExif mutableString];
		NSRange				sepRange;
		int					start, endOfLine, endOfContents;
			
		sepRange = [str rangeOfString:@":\t" options:NSLiteralSearch range:remainingRange];
		[str getLineStart:&start end:&endOfLine contentsEnd:&endOfContents forRange:sepRange];

		// Make the first part of the string bold
		[attrExif addAttribute:NSFontAttributeName value:m_boldFont range:NSMakeRange(start, sepRange.location - start)];
								
		// remainingRange now represents the rest of the string, from beginning of next line to end of the whole string
		remainingRange.location = endOfLine;
		remainingRange.length = length - remainingRange.location;
	}

    return attrExif;
}

- (void)handleInfoWithName:(const char*)name andValue:(const char*)value {
	int len = [m_textStorage length];
	[m_textStorage replaceCharactersInRange:NSMakeRange(len, 0) withAttributedString:
		[self _attributedResult:[NSString stringWithFormat:@"\t%s:\t%s\n", name, value]]];
}

@end
