RCS_ID("$Id: FFPreferences.m 610 2007-08-26 19:40:40Z ravemax $")

#import "FFPreferences.h"
#import "FFInputEvent.h"
#import "FFApplication.h"
#import "FFMainController.h"
#import "NSColor_Additions.h"
#import "NSArray_Additions.h"

// Notifications
NSString*   CtrlForPanningEnOrDisabledNotification  = @"ctrl_pan_en_or_dis";
NSString*   RelativePanningEnOrDisabledNotification = @"rel_pan_en_or_dis";
NSString*	DirectoryRootChangedNotification		= @"dir_root_changed";
NSString*	WindowBackgroundChangedNotification		= @"win_bg_changed";
NSString*	DoublePageAlignmentChangedNotification	= @"dbl_align_changed";

#define POST_NOTIFICATION(MSG) \
	[[NSNotificationCenter defaultCenter] postNotificationName:MSG object:nil]

// Keys for the user defaults
static NSString*	UDNameSaveOpts			= @"udn_save_opts";
static NSString*	UDNameZoomFactor		= @"udn_zoom_factor";
static NSString*	UDNameBorderlessWin		= @"udn_borderless";
static NSString*	UDNameWinLevel			= @"udn_win_level";
static NSString*	UDNameWinBgAuto			= @"udn_win_bg_auto";
static NSString*	UDNameWinBgCol			= @"udn_win_bg_col";
static NSString*	UDNameSlideshowTime		= @"udn_slide_time";
static NSString*	UDNameKeepMouseHidden	= @"udn_mouse_hidden";
static NSString*	UDNameDoubleAlignment	= @"udn_double_align";
static NSString*	UDNameMagLensWidth		= @"udn_mag_lens_width";
static NSString*	UDNameMagLensHeight		= @"udn_mag_lens_height";
static NSString*	UDNameListWrap			= @"udn_list_wrap";
static NSString*	UDNameDirectoryRoot		= @"udn_dir_root";
static NSString*	UDNameTrashDelete		= @"udn_trash_delete";
static NSString*	UDNameListWinHidden		= @"udn_img_win_hidden";
static NSString*	UDNameThumbWidth		= @"udn_thumb_width";
static NSString*	UDNameThumbHeight		= @"udn_thumb_height";
static NSString*	UDNameCtrlForPanning	= @"udn_ctrl_pan";
static NSString*	UDNameRelativePanning   = @"udn_rel_pan";
static NSString*	UDNameNormalCursorShift = @"udn_normal_cshift";
static NSString*	UDNameAccelCursorShift  = @"udn_accel_cshift";
static NSString*	UDNameMouseWheelSpeedup = @"udn_mouse_wheel_speedup";
static NSString*	UDNameInputEvents		= @"udn_input_events";
static NSString*	UDNameRingBufSize		= @"udn_rb_size";
static NSString*	UDNameFetchDist			= @"udn_fetch_dist";
static NSString*	UDNameImgWinAlpha		= @"udn_img_win_alpha";
static NSString*	UDNameListWinSnapTol	= @"udn_list_win_snap";
static NSString*	UDNameImageWinSnapTol	= @"udn_img_win_snap";
static NSString*	UDNameClearListBefore	= @"udn_clear_list_before";
static NSString*	UDNameMaxTileSize		= @"udn_max_tile_size";
static NSString*	UDNameAddAllOnDrop		= @"udn_add_all_on_drop";
static NSString*	UDNameLensZoom			= @"udn_lens_zoom";
static NSString*	UDNameAutoFullscreen	= @"udn_auto_fullscreen";
static NSString*	UDNameAutoSinglePageAdj	= @"udn_auto_single_page_adj";
static NSString*	UDNameDontResizeImgWin	= @"udn_dont_resize_img_win";
static NSString*	UDNameAutoShowMenuBar	= @"udn_disable_autoshow_menubar";
static NSString*	UDNameMaxDirSearchDepth	= @"udn_max_dir_search_depth";
static NSString*	UDNameClearRecentOnQuit	= @"udn_clear_recent_on_quit";
static NSString*	UDNameScrollWheelAction	= @"udn_scroll_wheel_action";
static NSString*	UDNameDirBlacklist		= @"udn_dir_blacklist";
static NSString*	UDNameImgListSortOrder  = @"udn_imglist_sort_order";
static NSString*	UDNameDirDrawerVisible	= @"udn_dir_drawer_visible";
static NSString*	UDNameScreenNumber		= @"udn_screen_number";

@implementation FFPreferences

#pragma mark -
#pragma mark Init, save and cleanup

// Singleton - some methods still have an "withPrefs" argument because it
// this was not planned from the beginning
static FFPreferences*   prefInstance = nil;

- (void)_loadInputEventsFromUserDefaults:(NSUserDefaults*)ud {
	NSArray* sea = [ud arrayForKey:UDNameInputEvents];

	// Create the event objects
	if (sea != nil) {
		NSEnumerator*	en;
		NSDictionary*	sdict;

		m_inputEvents = [[NSMutableArray alloc] initWithCapacity:[sea count]];
		en	= [sea objectEnumerator];
		while (sdict = [en nextObject])
			[m_inputEvents addObject:[FFInputEvent eventFromDictionary:sdict]];

	// Setup defaults
	} else
		[self _setupDefaultInputEvents];
}

- (id)init {
	self = [super init];
	if (self) {
		// Load user defaults
		NSUserDefaults* ud = [NSUserDefaults standardUserDefaults];

		[ud registerDefaults:[NSDictionary dictionaryWithObjectsAndKeys:
			// General
			@"yes", UDNameSaveOpts,
			[NSNumber numberWithFloat:0.25], UDNameZoomFactor,
			@"no", UDNameBorderlessWin,
			[NSNumber numberWithInt:NSNormalWindowLevel], UDNameWinLevel,
			@"no", UDNameWinBgAuto,
			[[NSColor blackColor] data], UDNameWinBgCol,
			[NSNumber numberWithDouble:5.0], UDNameSlideshowTime,
			@"no", UDNameKeepMouseHidden,
			[NSNumber numberWithInt:ALIGNMENT_TOP], UDNameDoubleAlignment,
			[NSNumber numberWithInt:150], UDNameMagLensWidth,
			[NSNumber numberWithInt:150], UDNameMagLensHeight,			
			// Image list
			[NSNumber numberWithInt:PREF_WRAP_NEVER], UDNameListWrap,
			NSHomeDirectory(), UDNameDirectoryRoot,
			@"no", UDNameTrashDelete,
			@"no", UDNameListWinHidden,
			[NSNumber numberWithInt:128], UDNameThumbWidth,
			[NSNumber numberWithInt:128], UDNameThumbHeight,
			// Panning
			@"yes", UDNameCtrlForPanning,
			@"no",  UDNameRelativePanning,
			[NSNumber numberWithUnsignedInt:5], UDNameNormalCursorShift,
			[NSNumber numberWithUnsignedInt:25], UDNameAccelCursorShift,
			[NSNumber numberWithFloat:5.0], UDNameMouseWheelSpeedup,
			// Input
			// The input events are complex so they are handled below
			// Advanced
			[NSNumber numberWithInt:5], UDNameRingBufSize,
			[NSNumber numberWithInt:2], UDNameFetchDist,

			// Misc
			[NSNumber numberWithFloat:1.0f], UDNameImgWinAlpha,
			[NSNumber numberWithFloat:40.0f], UDNameListWinSnapTol,
			[NSNumber numberWithFloat:15.0f], UDNameImageWinSnapTol,
			@"no", UDNameDirDrawerVisible,
			@"no", UDNameClearListBefore,
			@"no", UDNameAddAllOnDrop,
			[NSNumber numberWithFloat:1.0f], UDNameLensZoom,
			@"no", UDNameAutoFullscreen,
			[NSNumber numberWithFloat:1.0f], UDNameAutoSinglePageAdj,
			@"no", UDNameDontResizeImgWin,
			@"no", UDNameAutoShowMenuBar,
			[NSNumber numberWithInt:1], UDNameMaxDirSearchDepth,
			@"no", UDNameClearRecentOnQuit,
			[NSNumber numberWithInt:PREF_SCROLL_WHEEL_PAN], UDNameScrollWheelAction,
			[NSArray arrayWithObjects: @".thumbs", @".xvpics", nil], UDNameDirBlacklist,
			
			// External & recent
			[NSNumber numberWithInt:IMGLIST_USER_ASC], UDNameImgListSortOrder,
			nil]];
		
		// General
		[self setSaveOpts:[ud boolForKey:UDNameSaveOpts]];
		[self setZoomFactor:[ud floatForKey:UDNameZoomFactor]];
		[self setBorderlessWin:[ud boolForKey:UDNameBorderlessWin]];
		[self setWinLevel:[ud integerForKey:UDNameWinLevel]];
		[self setWinBackgroundAuto:[ud boolForKey:UDNameWinBgAuto]];
		m_winBgCol = nil;
		[self setWinBackgroundColor:[NSColor colorFromData:[ud dataForKey:UDNameWinBgCol]]];
		[self setSlideshowTime:(double)[ud floatForKey:UDNameSlideshowTime]];
		[self setKeepMouseHidden:[ud boolForKey:UDNameKeepMouseHidden]];
		[self setDoublePageAlignment:[ud integerForKey:UDNameDoubleAlignment]];
		[self setMagnifyingLensWidth:[ud integerForKey:UDNameMagLensWidth]];
		[self setMagnifyingLensHeight:[ud integerForKey:UDNameMagLensHeight]];
		// Image list
		[self setListWrap:[ud integerForKey:UDNameListWrap]];
		m_directoryRoot = [[ud stringForKey:UDNameDirectoryRoot] retain];
		[self setTrashDelete:[ud boolForKey:UDNameTrashDelete]];
		[self setListWinHiddenOnStartup:[ud boolForKey:UDNameListWinHidden]];
		[self setThumbWidth:[ud integerForKey:UDNameThumbWidth]];
		[self setThumbHeight:[ud integerForKey:UDNameThumbHeight]];
		// Panning
		[self setCtrlForPanning:[ud boolForKey:UDNameCtrlForPanning]];
		[self setRelativePanning:[ud boolForKey:UDNameRelativePanning]];
		[self setNormalCursorShift:(unsigned)[ud integerForKey:UDNameNormalCursorShift]];
		[self setAcceleratedCursorShift:(unsigned)[ud integerForKey:UDNameAccelCursorShift]];		
		[self setMouseWheelSpeedup:[ud floatForKey:UDNameMouseWheelSpeedup]];
		// Advanced
		[self setRingBufferSize:[ud integerForKey:UDNameRingBufSize]];
		[self setFetchDistance:[ud integerForKey:UDNameFetchDist]];
		
		// Misc
		m_imgWindowAlpha			= [ud floatForKey:UDNameImgWinAlpha];
		m_listWinSnapTolerance		= [ud floatForKey:UDNameListWinSnapTol];
		m_imageWinSnapTolerance		= [ud floatForKey:UDNameImageWinSnapTol];
		m_clearListBeforeDrop		= [ud boolForKey:UDNameClearListBefore];
		m_maxTileSize				= [ud integerForKey:UDNameMaxTileSize];
		m_addAllOnDrop				= [ud boolForKey:UDNameAddAllOnDrop];
		m_lensZoom					= [ud floatForKey:UDNameLensZoom];
		m_autoFullscreen			= [ud boolForKey:UDNameAutoFullscreen];
		m_autoSinglePageAdj			= [ud floatForKey:UDNameAutoSinglePageAdj];
		m_dontResizeImgWin			= [ud boolForKey:UDNameDontResizeImgWin];
		m_disableAutoShowMenuBar	= [ud boolForKey:UDNameAutoShowMenuBar];
		m_maxDirSearchDepth			= [ud integerForKey:UDNameMaxDirSearchDepth];
		m_clearRecentOnQuit			= [ud boolForKey:UDNameClearRecentOnQuit];
		m_scrollWheelAction			= (FFPrefScrollWheelAction)[ud integerForKey:UDNameScrollWheelAction];
		m_dirBlacklist				= [[ud arrayForKey:UDNameDirBlacklist] retain];
		
		// External & recent
		[self setImageListSortOrder:(FFImageListSortOrder)[ud integerForKey:UDNameImgListSortOrder]];
		[self setDirDrawerVisibleOnStartup:[ud boolForKey:UDNameDirDrawerVisible]];
		[self setScreenNumber:[ud objectForKey:UDNameScreenNumber]];
		
		// Input events
		[self _loadInputEventsFromUserDefaults:ud];
		
		// Not saving every time
		m_needToSave = FALSE;
	}
	return self;
}

+ (FFPreferences*)instance {
	if (prefInstance == nil)
		prefInstance = [[FFPreferences alloc] init];
	return prefInstance;
}

- (void)dealloc {
	[m_winBgCol release];
	[m_inputEvents release];
	[m_directoryRoot release];
	[m_dirBlacklist release];
	if (m_screenNumber != nil)
		[m_screenNumber release];
	
	[super dealloc];
}

- (void)_saveInputEventsInUserDefaults:(NSUserDefaults*)ud {
	NSMutableArray*	toSave	= [NSMutableArray arrayWithCapacity:[m_inputEvents count]];
	NSEnumerator*	en		= [m_inputEvents objectEnumerator];
	FFInputEvent*	event;

	while (event = [en nextObject])
		[toSave addObject:[event exportAsDictionary]];
		
	[ud setObject:toSave forKey:UDNameInputEvents];
}

- (void)save {
	NSUserDefaults* ud = [NSUserDefaults standardUserDefaults];

	if (m_needToSave) {
		// General
		[ud setBool:m_saveOpts forKey:UDNameSaveOpts];
		[ud setFloat:m_zoomFactor forKey:UDNameZoomFactor];
		[ud setBool:m_borderlessWin forKey:UDNameBorderlessWin];
		[ud setInteger:m_winLevel forKey:UDNameWinLevel];
		[ud setBool:m_winBgAuto forKey:UDNameWinBgAuto];
		[ud setObject:[m_winBgCol data] forKey:UDNameWinBgCol];
		[ud setFloat:(float)m_slideshowTime forKey:UDNameSlideshowTime];
		[ud setBool:m_keepMouseHidden forKey:UDNameKeepMouseHidden];
		[ud setInteger:m_doubleAlign forKey:UDNameDoubleAlignment];
		[ud setInteger:m_magLensWidth forKey:UDNameMagLensWidth];
		[ud setInteger:m_magLensHeight forKey:UDNameMagLensHeight];
		// Image list
		[ud setInteger:m_listWrap forKey:UDNameListWrap];
		[ud setObject:m_directoryRoot forKey:UDNameDirectoryRoot];
		[ud setBool:m_trashDelete forKey:UDNameTrashDelete];
		[ud setBool:m_listWinHiddenOnStartup forKey:UDNameListWinHidden];
		[ud setInteger:m_thumbWidth forKey:UDNameThumbWidth];
		[ud setInteger:m_thumbHeight forKey:UDNameThumbHeight];
		// Panning
		[ud setBool:m_ctrlForPanning forKey:UDNameCtrlForPanning];
		[ud setBool:m_relativePanning forKey:UDNameRelativePanning];
		[ud setInteger:(int)m_normalCursorShift forKey:UDNameNormalCursorShift];
		[ud setInteger:(int)m_accelCursorShift forKey:UDNameAccelCursorShift];
		[ud setFloat:m_mouseWheelSpeedup forKey:UDNameMouseWheelSpeedup];
		// Advanced
		[ud setInteger:m_ringBufSize forKey:UDNameRingBufSize];
		[ud setInteger:m_fetchDist forKey:UDNameFetchDist];
	
		// Input events
		[self _saveInputEventsInUserDefaults:ud];
	}
	
	// External
	[ud setInteger:(int)m_imageListSortOrder forKey:UDNameImgListSortOrder];
	[ud setBool:m_dirDrawerVisibleOnStartup forKey:UDNameDirDrawerVisible];
	if (m_screenNumber == nil)
		[ud removeObjectForKey:UDNameScreenNumber];
	else
		[ud setObject:m_screenNumber forKey:UDNameScreenNumber];
}

- (void)setNeedToSave:(BOOL)need {
	m_needToSave = need;
}

#pragma mark -
#pragma mark General

- (BOOL)saveOpts									{ return m_saveOpts; }
- (void)setSaveOpts:(BOOL)save						{ m_saveOpts = save; }
- (float)zoomFactor									{ return m_zoomFactor; }
- (void)setZoomFactor:(float)factor					{ m_zoomFactor = factor; }
- (BOOL)borderlessWin								{ return m_borderlessWin; }
- (void)setBorderlessWin:(BOOL)borderless			{ m_borderlessWin = borderless; }
- (int)winLevel										{ return m_winLevel; }
- (void)setWinLevel:(int)level						{ m_winLevel = level; }
- (BOOL)winBackgroundAuto							{ return m_winBgAuto; }
- (NSColor*)winBackgroundColor						{ return m_winBgCol; }
- (double)slideshowTime								{ return m_slideshowTime; }
- (void)setSlideshowTime:(double)time				{ m_slideshowTime = time; }
- (BOOL)keepMouseHidden								{ return m_keepMouseHidden; }
- (void)setKeepMouseHidden:(BOOL)hidden				{ m_keepMouseHidden = hidden; }
- (FFDoublePageAlignment)doublePageAlignment		{ return m_doubleAlign; }
- (int)magnifyingLensWidth							{ return m_magLensWidth; }
- (void)setMagnifyingLensWidth:(int)width			{ m_magLensWidth = width; }
- (int)magnifyingLensHeight							{ return m_magLensHeight; }
- (void)setMagnifyingLensHeight:(int)height			{ m_magLensHeight = height; }

- (void)setWinBackgroundAuto:(BOOL)bgauto {
	m_winBgAuto = bgauto;
	POST_NOTIFICATION(WindowBackgroundChangedNotification);
}

- (void)setWinBackgroundColor:(NSColor*)col {
	NSColor* old = m_winBgCol;
	m_winBgCol = [[col colorUsingColorSpaceName:NSCalibratedRGBColorSpace] retain];
	if (old != nil)
		[old release];
	POST_NOTIFICATION(WindowBackgroundChangedNotification);
}

- (void)setDoublePageAlignment:(FFDoublePageAlignment)alignment {
	m_doubleAlign = alignment;
	POST_NOTIFICATION(DoublePageAlignmentChangedNotification);
}

#pragma mark -
#pragma mark Image list

- (FFPrefListWrap)listWrap						{ return m_listWrap; }
- (void)setListWrap:(FFPrefListWrap)mode		{ m_listWrap = mode; }
- (BOOL)trashDelete								{ return m_trashDelete; }
- (void)setTrashDelete:(BOOL)allow				{ m_trashDelete = allow; }
- (NSString*)directoryRoot						{ return m_directoryRoot; }

- (void)setDirectoryRoot:(NSString*)root {
	if (m_directoryRoot != nil)
		[m_directoryRoot release];
	m_directoryRoot = [root retain];	
	POST_NOTIFICATION(DirectoryRootChangedNotification);
}

- (BOOL)listWinHiddenOnStartup					{ return m_listWinHiddenOnStartup; }
- (void)setListWinHiddenOnStartup:(BOOL)hidden	{ m_listWinHiddenOnStartup = hidden; }
- (int)thumbWidth								{ return m_thumbWidth; }
- (void)setThumbWidth:(int)width				{ m_thumbWidth = width; }
- (int)thumbHeight								{ return m_thumbHeight; }
- (void)setThumbHeight:(int)height				{ m_thumbHeight = height; }

#pragma mark -
#pragma mark Panning

- (BOOL)ctrlForPanning { 
	return m_ctrlForPanning;
}

- (void)setCtrlForPanning:(BOOL)ctrl { 
	m_ctrlForPanning = ctrl;
	POST_NOTIFICATION(CtrlForPanningEnOrDisabledNotification);
}

- (BOOL)relativePanning {
	return m_relativePanning;
}

- (void)setRelativePanning:(BOOL)relative {
	m_relativePanning = relative;
	POST_NOTIFICATION(RelativePanningEnOrDisabledNotification);
}

- (unsigned)normalCursorShift						{ return m_normalCursorShift; }
- (void)setNormalCursorShift:(unsigned)pixels		{ m_normalCursorShift = pixels; }
- (unsigned)acceleratedCursorShift					{ return m_accelCursorShift; }
- (void)setAcceleratedCursorShift:(unsigned)pixels  { m_accelCursorShift = pixels; }
- (float)mouseWheelSpeedup							{ return m_mouseWheelSpeedup; }
- (void)setMouseWheelSpeedup:(float)speedup			{ m_mouseWheelSpeedup = speedup; }

#pragma mark -
#pragma mark Input events

- (void)addInputEvent:(FFInputEvent*)event {
	[m_inputEvents addObject:event];
	[NSApp didAddInputEvent:event];
}

- (void)removeInputEvent:(FFInputEvent*)event {
	[NSApp willRemoveInputEvent:event];
	[m_inputEvents removeObject:event];
}

- (void)insertInputEvent:(FFInputEvent*)event after:(FFInputEvent*)afterEvent {
	[m_inputEvents insertObject:event atIndex:([m_inputEvents indexOfObject:afterEvent]+1)];
	[NSApp didAddInputEvent:event];
}

- (void)replaceInputEvent:(FFInputEvent*)oldEvent with:(FFInputEvent*)newEvent {
	[NSApp willReplaceInputEvent:oldEvent with:newEvent];
	[m_inputEvents replaceObjectAtIndex:[m_inputEvents indexOfObject:oldEvent] 
							 withObject:newEvent];
}

- (FFInputEvent*)inputEventAtIndex:(unsigned)idx {
	return [m_inputEvents objectAtIndex:idx];
}

- (NSEnumerator*)inputEventEnumerator {
	return [m_inputEvents objectEnumerator];
}

- (unsigned)numberOfInputEvents {
	return [m_inputEvents count];
}

- (BOOL)isInputEventAlreadyTaken:(FFInputEvent*)event {
	NSEnumerator*	en = [m_inputEvents objectEnumerator];
	FFInputEvent*	ie;

	while (ie = [en nextObject])
		if ([ie	isEqualToInputEvent:event])
			return TRUE;

	return FALSE;
}

#pragma mark -
#pragma mark Advanced

- (int)ringBufferSize				{ return m_ringBufSize; }
- (void)setRingBufferSize:(int)size { m_ringBufSize = size; }
- (int)fetchDistance				{ return m_fetchDist; }
- (void)setFetchDistance:(int)dist  { m_fetchDist = dist; }

#pragma mark -
#pragma mark Misc. - w/o pref view

- (float)imageWindowAlpha			{ return m_imgWindowAlpha; }
- (float)listWinSnapTolerance		{ return m_listWinSnapTolerance; }
- (float)imageWinSnapTolerance		{ return m_imageWinSnapTolerance; }
- (BOOL)clearListBeforeDrop			{ return m_clearListBeforeDrop; }
- (int)maxTileSize					{ return m_maxTileSize; }
- (BOOL)addAllOnDrop				{ return m_addAllOnDrop; }
- (float)lensZoom					{ return m_lensZoom; }
- (BOOL)autoFullscreen				{ return m_autoFullscreen; }
- (float)autoSinglePageAdjustment	{ return m_autoSinglePageAdj; }
- (BOOL)dontResizeImageWindow		{ return m_dontResizeImgWin; }
- (BOOL)disableAutoShowMenuBar		{ return m_disableAutoShowMenuBar; }
- (int)maxDirectorySearchDepth		{ return m_maxDirSearchDepth; }
- (BOOL)clearRecentOnQuit			{ return m_clearRecentOnQuit; }

- (FFPrefScrollWheelAction)scrollWheelAction {
	return m_scrollWheelAction;
}

- (BOOL)isBlacklistedDirectory:(NSString*)name {
	return [m_dirBlacklist containsCaseInsensitiveString:name];
}

#pragma mark -
#pragma mark External - not set thru the pref dialog

- (FFImageListSortOrder)imageListSortOrder {
	return m_imageListSortOrder;
}

- (void)setImageListSortOrder:(FFImageListSortOrder)sortOrder {
	m_imageListSortOrder = sortOrder;
}

- (BOOL)dirDrawerVisibleOnStartup { 
	return m_dirDrawerVisibleOnStartup;
}

- (void)setDirDrawerVisibleOnStartup:(BOOL)visible {
	m_dirDrawerVisibleOnStartup = visible;
}

- (NSNumber*)screenNumber {
	return m_screenNumber;
}

- (void)setScreenNumber:(NSNumber*)num {
	if (m_screenNumber != nil)
		[m_screenNumber release];
	m_screenNumber = (num != nil) ? [num retain] : nil;
}

#pragma mark -
#pragma mark Default input events (huge)

- (void)_setupDefaultInputEvents {
	m_inputEvents = [[NSMutableArray alloc] initWithObjects:
		// App
		[FFInputEvent eventWithKey:',' modifier:NSCommandKeyMask andAction:MENU_APP_PREFERENCES],
		[FFInputEvent eventWithKey:'h' modifier:NSCommandKeyMask andAction:MENU_APP_HIDE_FFVIEW],
		[FFInputEvent eventWithSpeechCommand:@"boss" andAction:MENU_APP_HIDE_FFVIEW],
		[FFInputEvent eventWithKey:'h' modifier:(NSCommandKeyMask | NSAlternateKeyMask) andAction:MENU_APP_HIDE_OTHERS],
		[FFInputEvent eventWithKey:'q' modifier:(NSCommandKeyMask | NSAlternateKeyMask) andAction:MENU_APP_QUICKSAVE_AND_QUIT],
		[FFInputEvent eventWithKey:'q' modifier:NSCommandKeyMask andAction:MENU_APP_QUIT_FFVIEW],
		
		// File
		[FFInputEvent eventWithKey:'o' modifier:NSCommandKeyMask andAction:MENU_FILE_OPEN],
		[FFInputEvent eventWithKey:'s' modifier:NSCommandKeyMask andAction:MENU_FILE_SAVE_IMGLIST],
		[FFInputEvent eventWithKey:0x0008 modifier:NSCommandKeyMask andAction:MENU_FILE_REMOVE], //0x007F=backspace
		[FFInputEvent eventWithKey:0x007F modifier:NSCommandKeyMask andAction:MENU_FILE_REMOVE], //0x007F=del
		[FFInputEvent eventWithKey:0x0008 modifier:0 andAction:MENU_FILE_REMOVE], //0x0008=backspace
		[FFInputEvent eventWithKey:0x007F modifier:0 andAction:MENU_FILE_REMOVE], //0x007F=del
		[FFInputEvent eventWithKey:0x0008 modifier:(NSCommandKeyMask | NSAlternateKeyMask) andAction:MENU_FILE_MOVE_TO_TRASH], //0x0008=backspace
		[FFInputEvent eventWithKey:0x007F modifier:(NSCommandKeyMask | NSAlternateKeyMask) andAction:MENU_FILE_MOVE_TO_TRASH], //0x007F=del
		
		// View
		[FFInputEvent eventWithKey:'f' modifier:NSCommandKeyMask andAction:MENU_VIEW_FULLSCREEN],
		[FFInputEvent eventWithKey:'f' modifier:0 andAction:MENU_VIEW_FULLSCREEN],
		[FFInputEvent eventWithKey:0x001B modifier:0 andAction:MENU_VIEW_FULLSCREEN], //0x001B=esc
		[FFInputEvent eventWithKey:'[' modifier:NSCommandKeyMask andAction:MENU_VIEW_PREV_IMG],
		[FFInputEvent eventWithKey:'p' modifier:0 andAction:MENU_VIEW_PREV_IMG],
		[FFInputEvent eventWithKey:NSPageUpFunctionKey modifier:0 andAction:MENU_VIEW_PREV_IMG],
		[FFInputEvent eventWithButton:4 modifier:0 andAction:MENU_VIEW_PREV_IMG],
		[FFInputEvent eventWithSpeechCommand:@"previous" andAction:MENU_VIEW_PREV_IMG],
		[FFInputEvent eventWithKey:']' modifier:NSCommandKeyMask andAction:MENU_VIEW_NEXT_IMG],
		[FFInputEvent eventWithKey:'n' modifier:0 andAction:MENU_VIEW_NEXT_IMG],
		[FFInputEvent eventWithKey:NSPageDownFunctionKey modifier:0 andAction:MENU_VIEW_NEXT_IMG],
		[FFInputEvent eventWithButton:3 modifier:0 andAction:MENU_VIEW_NEXT_IMG],
		[FFInputEvent eventWithSpeechCommand:@"next" andAction:MENU_VIEW_NEXT_IMG],	
		[FFInputEvent eventWithKey:NSHomeFunctionKey modifier:NSCommandKeyMask andAction:MENU_VIEW_FIRST_IMG],
		[FFInputEvent eventWithKey:NSHomeFunctionKey modifier:0 andAction:MENU_VIEW_FIRST_IMG],
		[FFInputEvent eventWithKey:NSEndFunctionKey modifier:NSCommandKeyMask andAction:MENU_VIEW_LAST_IMG],
		[FFInputEvent eventWithKey:NSEndFunctionKey modifier:0 andAction:MENU_VIEW_LAST_IMG],
		[FFInputEvent eventWithKey:NSPageUpFunctionKey modifier:NSCommandKeyMask andAction:MENU_VIEW_PAGE_UP],
		[FFInputEvent eventWithKey:0x0020 modifier:NSAlternateKeyMask andAction:MENU_VIEW_PAGE_UP], //0x0020=space
		[FFInputEvent eventWithKey:0x0020 modifier:NSShiftKeyMask andAction:MENU_VIEW_PAGE_UP], //0x0020=space
		[FFInputEvent eventWithKey:NSPageDownFunctionKey modifier:NSCommandKeyMask andAction:MENU_VIEW_PAGE_DOWN],
		[FFInputEvent eventWithKey:0x0020 modifier:0 andAction:MENU_VIEW_PAGE_DOWN], // 0x0020=space
		[FFInputEvent eventWithKey:'0' modifier:NSCommandKeyMask andAction:MENU_VIEW_ACTUAL_SIZE],
		[FFInputEvent eventWithKey:'+' modifier:NSCommandKeyMask andAction:MENU_VIEW_ZOOM_IN],
		[FFInputEvent eventWithKey:'+' modifier:0 andAction:MENU_VIEW_ZOOM_IN],
		[FFInputEvent eventWithKey:'=' modifier:0 andAction:MENU_VIEW_ZOOM_IN],
		[FFInputEvent eventWithKey:'-' modifier:NSCommandKeyMask andAction:MENU_VIEW_ZOOM_OUT],
		[FFInputEvent eventWithKey:'-' modifier:0 andAction:MENU_VIEW_ZOOM_OUT],
		[FFInputEvent eventWithKey:'d' modifier:NSCommandKeyMask andAction:MENU_VIEW_OSD],
		[FFInputEvent eventWithKey:'o' modifier:0 andAction:MENU_VIEW_OSD],
		
		// Options
		[FFInputEvent eventWithKey:'n' modifier:NSCommandKeyMask andAction:MENU_OPT_NO_ROTATION],
		[FFInputEvent eventWithKey:'r' modifier:NSCommandKeyMask andAction:MENU_OPT_ROTATE_90],
		[FFInputEvent eventWithKey:'l' modifier:NSCommandKeyMask andAction:MENU_OPT_ROTATE_270],
		[FFInputEvent eventWithKey:'c' modifier:NSCommandKeyMask andAction:MENU_OPT_NO_SCALING],
		[FFInputEvent eventWithKey:'i' modifier:NSCommandKeyMask andAction:MENU_OPT_FIT_WIN],
		[FFInputEvent eventWithKey:'p' modifier:NSCommandKeyMask andAction:MENU_OPT_PAGEWIDTH],
		[FFInputEvent eventWithKey:'a' modifier:NSCommandKeyMask andAction:MENU_OPT_ANTIALIASING],
		
		// Navigation
		[FFInputEvent eventWithKey:NSLeftArrowFunctionKey modifier:NSCommandKeyMask andAction:MENU_NAVI_PAN_LEFT],
		[FFInputEvent eventWithKey:NSLeftArrowFunctionKey modifier:0 andAction:MENU_NAVI_PAN_LEFT],
		[FFInputEvent eventWithKey:NSLeftArrowFunctionKey modifier:NSShiftKeyMask andAction:MENU_NAVI_PAN_LEFT_ACCEL],
		[FFInputEvent eventWithKey:NSRightArrowFunctionKey modifier:NSCommandKeyMask andAction:MENU_NAVI_PAN_RIGHT],
		[FFInputEvent eventWithKey:NSRightArrowFunctionKey modifier:0 andAction:MENU_NAVI_PAN_RIGHT],
		[FFInputEvent eventWithKey:NSRightArrowFunctionKey modifier:NSShiftKeyMask andAction:MENU_NAVI_PAN_RIGHT_ACCEL],
		[FFInputEvent eventWithKey:NSUpArrowFunctionKey modifier:NSCommandKeyMask andAction:MENU_NAVI_PAN_UP],
		[FFInputEvent eventWithKey:NSUpArrowFunctionKey modifier:0 andAction:MENU_NAVI_PAN_UP],
		[FFInputEvent eventWithKey:NSUpArrowFunctionKey modifier:NSShiftKeyMask andAction:MENU_NAVI_PAN_UP_ACCEL],
		[FFInputEvent eventWithKey:NSDownArrowFunctionKey modifier:NSCommandKeyMask andAction:MENU_NAVI_PAN_DOWN],
		[FFInputEvent eventWithKey:NSDownArrowFunctionKey modifier:0 andAction:MENU_NAVI_PAN_DOWN],
		[FFInputEvent eventWithKey:NSDownArrowFunctionKey modifier:NSShiftKeyMask andAction:MENU_NAVI_PAN_DOWN_ACCEL],
		
		// Window
		[FFInputEvent eventWithKey:'w' modifier:NSCommandKeyMask andAction:MENU_WIN_CLOSE_WINDOW],
		[FFInputEvent eventWithKey:'m' modifier:NSCommandKeyMask andAction:MENU_WIN_MINIMIZE_WINDOW],
		[FFInputEvent eventWithKey:'1' modifier:NSCommandKeyMask andAction:MENU_WIN_IMAGE_LIST],
		[FFInputEvent eventWithKey:'2' modifier:NSCommandKeyMask andAction:MENU_WIN_IMAGE],
		[FFInputEvent eventWithKey:'3' modifier:NSCommandKeyMask andAction:MENU_WIN_EXIF],
		
		// Help
		[FFInputEvent eventWithKey:'?' modifier:NSCommandKeyMask andAction:MENU_HELP_HELP],
		[FFInputEvent eventWithKey:'?' modifier:(NSCommandKeyMask | NSAlternateKeyMask) andAction:MENU_HELP_BROWSER],
		nil];	
}

@end
