RCS_ID("$Id: FFOptions_Scriptable.m 415 2005-06-09 15:32:36Z ravemax $")

#import "FFOptions_Scriptable.h"
#import "FFApplication.h"

@implementation FFOptions (Scriptable)

// Four char code <-> enum mapping
static const unsigned RotationFCC[OPT_NUM_ROTATION] = {
	FOUR_CHAR_CODE('eron'),	// OPT_NO_ROTATION
	FOUR_CHAR_CODE('eror'),	// OPT_ROTATE_RIGHT
	FOUR_CHAR_CODE('erof'),	// OPT_ROTATE_180
	FOUR_CHAR_CODE('erol')	// OPT_ROTATE_LEFT
};

static const unsigned ScalingFCC[OPT_NUM_SCALING] = {
	FOUR_CHAR_CODE('escn'),	// OPT_NO_SCALING
	FOUR_CHAR_CODE('escf'),	// OPT_FIT_TO_WINDOW
	FOUR_CHAR_CODE('escp')	// OPT_PAGEWIDTH
};

static const unsigned PageModeFCC[OPT_NUM_PAGE_MODE] = {
	FOUR_CHAR_CODE('epms'),	// OPT_MODE_SINGLE
	FOUR_CHAR_CODE('epmw'),	// OPT_MODE_WESTERN
	FOUR_CHAR_CODE('epmm')	// OPT_MODE_MANGA
};

#pragma mark Setup

- (void)registerProperties {	
	[NSApp registerPropertyWithTarget:self getter:@selector(rotationAS) 
							andSetter:@selector(setRotationAS:) forKey:@"rotation"];
	[NSApp registerPropertyWithTarget:self getter:@selector(scalingAS) 
							andSetter:@selector(setScalingAS:) forKey:@"scaling"];
	[NSApp registerPropertyWithTarget:self getter:@selector(pageModeAS) 
							andSetter:@selector(setPageModeAS:) forKey:@"pageMode"];
	[NSApp registerPropertyWithTarget:self getter:@selector(antialiasingAS) 
							andSetter:@selector(setAntialiasingAS:) forKey:@"antialiasing"];
	[NSApp registerPropertyWithTarget:self getter:@selector(speechOnAS) 
							andSetter:@selector(setSpeechOnAS:) forKey:@"speechOn"];
	[NSApp registerPropertyWithTarget:self getter:@selector(noBlowUpAS) 
							andSetter:@selector(setNoBlowUpAS:) forKey:@"noBlowUp"];
	[NSApp registerPropertyWithTarget:self getter:@selector(fullScreenAS) 
							andSetter:@selector(setFullscreenAS:) forKey:@"fullScreenMode"];
	[NSApp registerPropertyWithTarget:self getter:@selector(OSDVisibilityAS)
							andSetter:@selector(setOSDVisibilityAS:) forKey:@"OSDVisibility"];
}

#pragma mark -
#pragma mark Getters

- (NSNumber*)rotationAS {
	return [NSNumber numberWithUnsignedInt:RotationFCC[[self rotation]]];
}

- (NSNumber*)scalingAS {
	return [NSNumber numberWithUnsignedInt:ScalingFCC[[self scaling]]];
}

- (NSNumber*)pageModeAS {
	return [NSNumber numberWithUnsignedInt:PageModeFCC[[self pageMode]]];
}

- (NSNumber*)antialiasingAS {
	return [NSNumber numberWithBool:[self antialiasing]];
}

- (NSNumber*)speechOnAS {
	return [NSNumber numberWithBool:[self speechOn]];
}

- (NSNumber*)noBlowUpAS {
	return [NSNumber numberWithBool:[self noBlowUp]];
}

- (NSNumber*)fullScreenAS {
	return [NSNumber numberWithBool:[self fullscreen]];
}

- (NSNumber*)OSDVisibilityAS {
	return [NSNumber numberWithBool:[self isOSDVisible]];
}

#pragma mark -
#pragma mark Setters

static inline int FCCToInt(const unsigned cma[], unsigned fcc, int num) {
	int	i;
	for (i = 0; i < num; i++)
		if (cma[i] == fcc)
			return i;
	return 0; // Returns the first entry if something goes wrong
}

- (void)setRotationAS:(NSNumber*)rot {
	[self setRotation:(FFOptRotation)
		FCCToInt(RotationFCC, [rot unsignedIntValue], OPT_NUM_ROTATION)];
}

- (void)setScalingAS:(NSNumber*)scale {
	[self setScaling:(FFOptScaling)
		FCCToInt(ScalingFCC, [scale unsignedIntValue], OPT_NUM_SCALING)];
}

- (void)setPageModeAS:(NSNumber*)mode {
	[self setPageMode:(FFOptPageMode)
		FCCToInt(PageModeFCC, [mode unsignedIntValue], OPT_NUM_PAGE_MODE)];
}

- (void)setAntialiasingAS:(NSNumber*)aa {
	[self setAntialiasing:[aa boolValue]];
}

- (void)setSpeechOnAS:(NSNumber*)speech {
	[self setSpeechOn:[speech boolValue]];
}

- (void)setNoBlowUpAS:(NSNumber*)nobu {
	[self setNoBlowUp:[nobu boolValue]];
}

- (void)setFullscreenAS:(NSNumber*)fullscreen {
	[self setFullscreen:[fullscreen boolValue]];
}

- (void)setOSDVisibilityAS:(NSNumber*)visible {
	[self setOSDVisibility:[visible boolValue]];
}

@end
