/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import shared.FileUtils;
import shared.State.LogBoxStateless;
import shared.StateStack;
import shared.cancel;
import shared.translation;
import shared.uncaughtexception;

public class m {
    public static Integer debugCount = 0;
    private static LogBoxStateless _outputTextArea;
    private static JProgressBar _outputProgressBar;
    private static boolean justUseConsole;
    private static int tab;
    private static final String tabsp = "  ";
    private static int numerrors;
    private static int numwarnings;
    private static JLabel errorlabel;
    private static JLabel warninglabel;
    public static final Color warningColor;
    public static final Color errorColor;
    public static StateStack<stateclass> state;
    private static long lasttime;
    private static String lasttimemsg;

    public static void increaseindentation() {
        ++tab;
    }

    public static void decreaseindentation() {
        --tab;
    }

    public static void SetErrorLabel(JLabel label) {
        errorlabel = label;
        label.putClientProperty("trans", false);
        m.UpdateErrorCount();
    }

    public static void SetWarningLabel(JLabel label) {
        warninglabel = label;
        label.putClientProperty("trans", false);
        m.UpdateErrorCount();
    }

    public static void ResetWarningsAndErrors() {
        numerrors = 0;
        numwarnings = 0;
        m.UpdateErrorCount();
    }

    public static void time() {
        long time = m.gettime();
        m.msg("time(ms): ", Long.toString(time));
    }

    public static long gettime() {
        long time = Calendar.getInstance().getTimeInMillis();
        return time;
    }

    public static void marktime(String msg) {
        long time = m.gettime();
        if (lasttime == -1L) {
            m.msg(msg + ": (Starting timer)");
        } else {
            m.msg(msg + ": " + Long.toString(time - lasttime) + "ms (since '" + lasttimemsg + "')");
        }
        lasttime = time;
        lasttimemsg = msg;
    }

    public static void redirectStdOut() {
        if (!justUseConsole) {
            System.setOut(new PrintStream(new Outstream("stdout:"), true));
        }
    }

    public static void redirectStdErr() {
        if (!justUseConsole) {
            System.setErr(new PrintStream(new Outstream("stderr:"), true));
        }
    }

    public static void setLogbox(LogBoxStateless newJTextArea) {
        if (newJTextArea == null) {
            justUseConsole = true;
        } else {
            justUseConsole = false;
            _outputTextArea = newJTextArea;
        }
    }

    public static void setProgressBar(JProgressBar newProgressBar) {
        _outputProgressBar = newProgressBar;
    }

    private static void UpdateErrorCount() {
        if (errorlabel != null) {
            errorlabel.setText(Integer.toString(numerrors));
            if (numerrors > 0) {
                errorlabel.setForeground(errorColor);
            } else {
                errorlabel.setForeground(null);
            }
        }
        if (warninglabel != null) {
            warninglabel.setText(Integer.toString(numwarnings));
            if (numwarnings > 0) {
                warninglabel.setForeground(warningColor);
            } else {
                warninglabel.setForeground(null);
            }
        }
    }

    private static void message(final MessageType type, String ... ss) {
        String indicator;
        switch (type) {
            case error: {
                ++numerrors;
                m.UpdateErrorCount();
                break;
            }
            case warning: {
                ++numwarnings;
                m.UpdateErrorCount();
            }
        }
        if (((stateclass)m.state.curstate).translate) {
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = translation.translate(ss[i]);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tab; ++i) {
            sb.append(tabsp);
        }
        for (String spart : ss) {
            sb.append(spart);
        }
        String s = sb.toString();
        if (justUseConsole) {
            indicator = type.getIndicator();
            System.out.println(indicator + s);
        } else if (_outputTextArea != null) {
            final String s2 = s;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String indicator = type.getIndicator();
                    _outputTextArea.append(indicator, type);
                    _outputTextArea.append(s2 + "\n");
                    if (((stateclass)m.state.curstate).scrollOutput) {
                        int h = _outputTextArea.getHeight();
                        _outputTextArea.scrollRectToVisible(new Rectangle(0, h + 40, 0, 0));
                    }
                }
            });
        } else {
            indicator = type.getIndicator();
            String errormsg = "Programming Error: shared.m messages are being generated before the output TextArea is set, or there is no output TextArea.\nThe error is: " + indicator + s;
            System.out.println(errormsg);
            JOptionPane.showMessageDialog(null, errormsg);
        }
        if (((stateclass)m.state.curstate).writeToFile) {
            FileUtils.AppendText(((stateclass)m.state.curstate).filename, s + "\n");
        }
        String[] trapmessages = new String[]{"compile not implemented"};
        for (int i = 0; i < trapmessages.length; ++i) {
            if (!s.toLowerCase().startsWith(trapmessages[i].toLowerCase())) continue;
            boolean bl = false;
        }
    }

    public static void msg(String ... s) {
        if (((stateclass)m.state.curstate).showNormalMessages) {
            m.message(MessageType.normal, s);
        }
    }

    public static void err(String ... s) {
        if (((stateclass)m.state.curstate).showErrorMessages) {
            m.message(MessageType.error, s);
        }
    }

    public static void warn(String ... s) {
        if (((stateclass)m.state.curstate).showWarningMessages) {
            m.message(MessageType.warning, s);
        }
    }

    public static void console(String ... s) {
        if (((stateclass)m.state.curstate).showConsoleMessages) {
            m.message(MessageType.console, s);
        }
    }

    public static void status(String ... s) {
        if (((stateclass)m.state.curstate).showStatusMessages) {
            m.message(MessageType.status, s);
        }
    }

    public static void throwUncaughtException(String ... s) {
        String msg = m.trans(s);
        throw new uncaughtexception(msg);
    }

    public static void cancel() {
        m.cancel("");
    }

    public static void cancel(String s) {
        throw new cancel(s);
    }

    public static void setWorking(boolean isWorking) {
        if (_outputProgressBar != null) {
            if (isWorking) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        _outputProgressBar.setIndeterminate(true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        _outputProgressBar.setIndeterminate(false);
                    }
                });
            }
        }
    }

    public static String trans(String ... ss) {
        String r = "";
        for (int i = 0; i < ss.length; ++i) {
            r = r + translation.translate(ss[i]);
        }
        return r;
    }

    static {
        justUseConsole = true;
        tab = 0;
        numerrors = 0;
        numwarnings = 0;
        warningColor = new Color(16740369);
        errorColor = Color.RED;
        state = new StateStack<stateclass>(new stateclass(), true, true);
        lasttime = -1L;
    }

    public static class StreamRedirector {
        public static void Redirect(Process p) {
            Poller poller = new Poller(p);
            poller.start();
        }

        public static class Poller
        extends Thread {
            private static final int polltime = 100;
            InputStream parentStdin = System.in;
            PrintStream parentStdout = System.out;
            PrintStream parentStderr = System.err;
            OutputStream childStdin;
            InputStream childStdout;
            InputStream childStderr;
            private boolean quit = false;

            public Poller(Process p) {
                this.childStdin = p.getOutputStream();
                this.childStdout = p.getInputStream();
                this.childStderr = p.getErrorStream();
                this.setDaemon(true);
            }

            @Override
            public void run() {
                while (!this.quit) {
                    this.poll();
                    try {
                        Poller.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
            }

            private void poll() {
                try {
                    int b2;
                    while (this.childStdout.available() != 0) {
                        b2 = this.childStdout.read();
                        this.parentStdout.write(b2);
                        this.parentStdout.flush();
                    }
                    while (this.childStderr.available() != 0) {
                        b2 = this.childStderr.read();
                        this.parentStderr.write(b2);
                        this.parentStderr.flush();
                    }
                    while (this.parentStdin.available() != 0) {
                        b2 = this.parentStdin.read();
                        this.parentStdout.write(b2);
                        this.parentStdout.flush();
                        this.childStdin.write(b2);
                        this.childStdin.flush();
                    }
                }
                catch (Exception e2) {
                    boolean bl = false;
                }
            }
        }
    }

    public static class Outstream
    extends OutputStream {
        Vector<Character> unprinted = new Vector();
        String tag;

        public Outstream(String tag) {
            this.tag = tag;
        }

        @Override
        public void flush() {
            char[] CharString = new char[this.unprinted.size()];
            for (int i = 0; i < CharString.length; ++i) {
                CharString[i] = this.unprinted.elementAt(i).charValue();
            }
            this.unprinted.clear();
            String msg = new String(CharString);
            if (msg.equals("\r\n")) {
                return;
            }
            if (msg.equals("")) {
                return;
            }
            m.console(this.tag, msg);
        }

        @Override
        public void write(int b2) {
            this.unprinted.add(Character.valueOf((char)b2));
        }
    }

    public static class stateclass
    implements Serializable {
        public boolean showNormalMessages = true;
        public boolean showWarningMessages = true;
        public boolean showErrorMessages = true;
        public boolean showConsoleMessages = true;
        public boolean showStatusMessages = true;
        public boolean writeToFile = false;
        public boolean scrollOutput = true;
        public boolean translate = false;
        public String filename = FileUtils.GetInitialWorkingDirectory() + "/Drizzle.output.txt";

        public stateclass clone() {
            stateclass result = new stateclass();
            result.showNormalMessages = this.showNormalMessages;
            result.showConsoleMessages = this.showConsoleMessages;
            result.showErrorMessages = this.showErrorMessages;
            result.showStatusMessages = this.showStatusMessages;
            result.showWarningMessages = this.showWarningMessages;
            result.writeToFile = this.writeToFile;
            result.scrollOutput = this.scrollOutput;
            result.translate = this.translate;
            result.filename = this.filename;
            return result;
        }
    }

    public static enum MessageType {
        normal,
        warning,
        error,
        console,
        status;


        public String getIndicator() {
            switch (this) {
                case warning: {
                    return translation.translate("Warning: ");
                }
                case error: {
                    return translation.translate("Error: ");
                }
                case console: {
                    return translation.translate("Console: ");
                }
            }
            return "";
        }
    }
}

