/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import prpobjects.Objheader;
import prpobjects.PrpObject;
import prpobjects.Typeid;
import prpobjects.Uruobjectdesc;
import prpobjects.Uruobjectref;
import prpobjects.plSceneObject;
import prpobjects.prpfile;
import prpobjects.uruobj;
import prpobjects.x0000Scenenode;
import shared.CryptHashes;
import shared.m;
import shared.readexception;
import shared.uncaughtexception;
import uru.Bytedeque;
import uru.Bytestream;
import uru.context;

public class PrpRootObject
extends uruobj
implements Comparable {
    public Objheader header;
    PrpObject prpobject;
    public boolean hasChanged;
    public boolean hasRaw;
    public boolean hasParsed;
    byte[] rawdata;
    int readversion;
    public boolean tagDeleted = false;

    public PrpRootObject(context c, boolean readRaw, int length) throws readexception {
        int headerStart = c.in.getAbsoluteOffset();
        this.header = new Objheader(c);
        int headerEnd = c.in.getAbsoluteOffset();
        this.hasChanged = false;
        this.hasRaw = readRaw;
        this.hasParsed = true;
        this.readversion = c.readversion;
        String breakname = "fanroomcrank_drag";
        Object breaktype = null;
        if (this.header.desc.objectname.toString().toLowerCase().startsWith(breakname.toLowerCase()) && (breaktype == null || breaktype == this.header.desc.objecttype)) {
            boolean bl = false;
        }
        if (readRaw) {
            this.rawdata = c.readBytes(length - (headerEnd - headerStart));
            this.hasParsed = false;
        } else {
            this.prpobject = new PrpObject(c, this.header.objecttype);
        }
    }

    public Uruobjectref getref() {
        return this.header.desc.toRef();
    }

    public int compareTo(Object o) {
        if (!(o instanceof PrpRootObject)) {
            return -1;
        }
        PrpRootObject obj = (PrpRootObject)o;
        int a = this.header.desc.objecttype.compareTo(obj.header.desc.objecttype);
        if (a < 0) {
            return -1;
        }
        if (a > 0) {
            return 1;
        }
        return this.header.desc.objectname.toString().compareTo(obj.header.desc.objectname.toString());
    }

    private PrpRootObject() {
    }

    public static PrpRootObject createFromDescAndObject(Uruobjectdesc desc, uruobj object) {
        PrpRootObject result = new PrpRootObject();
        result.prpobject = PrpObject.createFromUruobj(object);
        result.header = Objheader.createFromDesc(desc);
        result.readversion = 3;
        result.hasChanged = true;
        result.hasRaw = false;
        result.hasParsed = true;
        return result;
    }

    public static PrpRootObject createFromTypeNamePrpObject(Typeid type, String name, prpfile prp, uruobj obj) {
        PrpRootObject r = new PrpRootObject();
        r.prpobject = PrpObject.createFromUruobj(obj);
        r.header = Objheader.createFromDesc(Uruobjectdesc.createDefaultWithTypeNamePrp(type, name, prp));
        r.hasChanged = true;
        r.hasRaw = false;
        r.hasParsed = true;
        return r;
    }

    public void ensureParsed() {
        try {
            this.parseRawDataNow();
        }
        catch (readexception e2) {
            m.err("Unable to parse rawdata: ", e2.getMessage());
        }
    }

    public void parseRawDataNow() throws readexception {
        if (!this.hasParsed) {
            context c = context.createFromBytestream(new Bytestream(this.rawdata));
            c.readversion = this.readversion;
            c.curRootObject = this.header.desc;
            this.prpobject = new PrpObject(c, this.header.objecttype);
            this.hasParsed = true;
        }
    }

    public void markAsChanged() {
        this.hasChanged = true;
    }

    @Override
    public void compile(Bytedeque c) {
        if (this.hasRaw && !this.hasChanged) {
            c.writeBytes(this.rawdata);
        } else {
            this.prpobject.compile(c);
        }
    }

    public String toString() {
        return "PrpRootObject: " + this.header.desc.toString();
    }

    public <T> T castTo() {
        this.ensureParsed();
        uruobj result = this.prpobject.object;
        return (T)result;
    }

    public <T> T castTo(T dummy) {
        this.ensureParsed();
        uruobj result = this.prpobject.object;
        return (T)result;
    }

    public <T> T castTo(Class<T> cls) {
        this.ensureParsed();
        uruobj result = this.prpobject.object;
        return (T)result;
    }

    public x0000Scenenode castToSceneNode() {
        this.ensureParsed();
        x0000Scenenode result = (x0000Scenenode)this.castTo();
        return result;
    }

    public plSceneObject castToSceneObject() {
        this.ensureParsed();
        plSceneObject result = (plSceneObject)this.castTo();
        return result;
    }

    public uruobj getObject() {
        this.ensureParsed();
        return this.prpobject.object;
    }

    public int getRawSize() {
        if (!this.hasRaw) {
            throw new uncaughtexception("Cannot get rawsize on non-raw object.");
        }
        int result = this.rawdata.length;
        return result;
    }

    public byte[] getRawMd5() {
        if (!this.hasRaw) {
            throw new uncaughtexception("Cannot get md5 on non-raw object.");
        }
        byte[] result = CryptHashes.GetHash(this.rawdata, CryptHashes.Hashtype.md5);
        return result;
    }
}

