/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Vector;
import jonelo.jacksum.adapt.gnu.crypto.hash.Sha0;
import moulserver.AuthServerSecureFiles;
import moulserver.ChunkSendHandler;
import moulserver.Comm;
import moulserver.ConnectionState;
import moulserver.Database;
import moulserver.FileServer;
import moulserver.GameServer;
import moulserver.Manager;
import moulserver.Node;
import moulserver.NodeManager;
import moulserver.NodeUtils;
import moulserver.RawNode;
import moulserver.SecureDownloadManifest;
import moulserver.Server;
import moulserver.SuperManager;
import prpobjects.Guid;
import shared.Concurrent;
import shared.CryptHashes;
import shared.Format;
import shared.IBytedeque;
import shared.IBytestream;
import shared.RandomUtils;
import shared.Str;
import shared.b;
import shared.m;
import shared.nested;
import shared.uncaughtexception;
import uru.Bytedeque;

public class AuthServer
extends Thread {
    static final short kCli2Auth_PingRequest = 0;
    static final short kCli2Auth_ClientRegisterRequest = 1;
    static final short kCli2Auth_ClientSetCCRLevel = 2;
    static final short kCli2Auth_AcctLoginRequest = 3;
    static final short kCli2Auth_AcctSetEulaVersion = 4;
    static final short kCli2Auth_AcctSetDataRequest = 5;
    static final short kCli2Auth_AcctSetPlayerRequest = 6;
    static final short kCli2Auth_AcctCreateRequest = 7;
    static final short kCli2Auth_AcctChangePasswordRequest = 8;
    static final short kCli2Auth_AcctSetRolesRequest = 9;
    static final short kCli2Auth_AcctSetBillingTypeRequest = 10;
    static final short kCli2Auth_AcctActivateRequest = 11;
    static final short kCli2Auth_AcctCreateFromKeyRequest = 12;
    static final short kCli2Auth_PlayerDeleteRequest = 13;
    static final short kCli2Auth_PlayerUndeleteRequest = 14;
    static final short kCli2Auth_PlayerSelectRequest = 15;
    static final short kCli2Auth_PlayerRenameRequest = 16;
    static final short kCli2Auth_PlayerCreateRequest = 17;
    static final short kCli2Auth_PlayerSetStatus = 18;
    static final short kCli2Auth_PlayerChat = 19;
    static final short kCli2Auth_UpgradeVisitorRequest = 20;
    static final short kCli2Auth_SetPlayerBanStatusRequest = 21;
    static final short kCli2Auth_KickPlayer = 22;
    static final short kCli2Auth_ChangePlayerNameRequest = 23;
    static final short kCli2Auth_SendFriendInviteRequest = 24;
    static final short kCli2Auth_VaultNodeCreate = 25;
    static final short kCli2Auth_VaultNodeFetch = 26;
    static final short kCli2Auth_VaultNodeSave = 27;
    static final short kCli2Auth_VaultNodeDelete = 28;
    static final short kCli2Auth_VaultNodeAdd = 29;
    static final short kCli2Auth_VaultNodeRemove = 30;
    static final short kCli2Auth_VaultFetchNodeRefs = 31;
    static final short kCli2Auth_VaultInitAgeRequest = 32;
    static final short kCli2Auth_VaultNodeFind = 33;
    static final short kCli2Auth_VaultSetSeen = 34;
    static final short kCli2Auth_VaultSendNode = 35;
    static final short kCli2Auth_AgeRequest = 36;
    static final short kCli2Auth_FileListRequest = 37;
    static final short kCli2Auth_FileDownloadRequest = 38;
    static final short kCli2Auth_FileDownloadChunkAck = 39;
    static final short kCli2Auth_PropagateBuffer = 40;
    static final short kCli2Auth_GetPublicAgeList = 41;
    static final short kCli2Auth_SetAgePublic = 42;
    static final short kCli2Auth_LogPythonTraceback = 43;
    static final short kCli2Auth_LogStackDump = 44;
    static final short kCli2Auth_LogClientDebuggerConnect = 45;
    static final short kCli2Auth_ScoreCreate = 46;
    static final short kCli2Auth_ScoreDelete = 47;
    static final short kCli2Auth_ScoreGetScores = 48;
    static final short kCli2Auth_ScoreAddPoints = 49;
    static final short kCli2Auth_ScoreTransferPoints = 50;
    static final short kCli2Auth_ScoreSetPoints = 51;
    static final short kCli2Auth_ScoreGetRanks = 52;
    static final short kCli2Auth_AcctExistsRequest = 53;
    static final short kAuth2Cli_PingReply = 0;
    static final short kAuth2Cli_ServerAddr = 1;
    static final short kAuth2Cli_NotifyNewBuild = 2;
    static final short kAuth2Cli_ClientRegisterReply = 3;
    static final short kAuth2Cli_AcctLoginReply = 4;
    static final short kAuth2Cli_AcctData = 5;
    static final short kAuth2Cli_AcctPlayerInfo = 6;
    static final short kAuth2Cli_AcctSetPlayerReply = 7;
    static final short kAuth2Cli_AcctCreateReply = 8;
    static final short kAuth2Cli_AcctChangePasswordReply = 9;
    static final short kAuth2Cli_AcctSetRolesReply = 10;
    static final short kAuth2Cli_AcctSetBillingTypeReply = 11;
    static final short kAuth2Cli_AcctActivateReply = 12;
    static final short kAuth2Cli_AcctCreateFromKeyReply = 13;
    static final short kAuth2Cli_PlayerList = 14;
    static final short kAuth2Cli_PlayerChat = 15;
    static final short kAuth2Cli_PlayerCreateReply = 16;
    static final short kAuth2Cli_PlayerDeleteReply = 17;
    static final short kAuth2Cli_UpgradeVisitorReply = 18;
    static final short kAuth2Cli_SetPlayerBanStatusReply = 19;
    static final short kAuth2Cli_ChangePlayerNameReply = 20;
    static final short kAuth2Cli_SendFriendInviteReply = 21;
    static final short kAuth2Cli_FriendNotify = 22;
    static final short kAuth2Cli_VaultNodeCreated = 23;
    static final short kAuth2Cli_VaultNodeFetched = 24;
    static final short kAuth2Cli_VaultNodeChanged = 25;
    static final short kAuth2Cli_VaultNodeDeleted = 26;
    static final short kAuth2Cli_VaultNodeAdded = 27;
    static final short kAuth2Cli_VaultNodeRemoved = 28;
    static final short kAuth2Cli_VaultNodeRefsFetched = 29;
    static final short kAuth2Cli_VaultInitAgeReply = 30;
    static final short kAuth2Cli_VaultNodeFindReply = 31;
    static final short kAuth2Cli_VaultSaveNodeReply = 32;
    static final short kAuth2Cli_VaultAddNodeReply = 33;
    static final short kAuth2Cli_VaultRemoveNodeReply = 34;
    static final short kAuth2Cli_AgeReply = 35;
    static final short kAuth2Cli_FileListReply = 36;
    static final short kAuth2Cli_FileDownloadChunk = 37;
    static final short kAuth2Cli_PropagateBuffer = 38;
    static final short kAuth2Cli_KickedOff = 39;
    static final short kAuth2Cli_PublicAgeList = 40;
    static final short kAuth2Cli_ScoreCreateReply = 41;
    static final short kAuth2Cli_ScoreDeleteReply = 42;
    static final short kAuth2Cli_ScoreGetScoresReply = 43;
    static final short kAuth2Cli_ScoreAddPointsReply = 44;
    static final short kAuth2Cli_ScoreTransferPointsReply = 45;
    static final short kAuth2Cli_ScoreSetPointsReply = 46;
    static final short kAuth2Cli_ScoreGetRanksReply = 47;
    static final short kAuth2Cli_AcctExistsReply = 48;
    Queue<Comm.CommItem> items = Concurrent.getConcurrentQueue();
    Comm comm = new Comm();
    Manager manager;
    AuthServerSecureFiles securefiles = new AuthServerSecureFiles();

    public AuthServer(Manager manager) {
        this.manager = manager;
    }

    @Override
    public void run() {
        m.msg("Starting AuthServer...");
        while (true) {
            Comm.CommItem item;
            if ((item = this.items.poll()) != null) {
                if (item.type == Comm.CommItemType.HandleMessage) {
                    this.HandleMessage(item.msg, item.connstate);
                    continue;
                }
                if (item.type == Comm.CommItemType.GetAgeSdl) {
                    Node.AgeInfoNode ageinfo = Node.AgeInfoNode.getFromAgeInstanceGuid(item.guid);
                    Node sdl = null;
                    for (Node node : ageinfo.getChildrenNodes()) {
                        if (node.getType() != 27) continue;
                        sdl = node;
                        break;
                    }
                    if (sdl != null) {
                        this.manager.comm.Respond(item, Comm.CommItem.ResponseNode(sdl));
                        continue;
                    }
                    m.throwUncaughtException("node not found");
                    continue;
                }
                if (item.type == Comm.CommItemType.SaveNode) {
                    Node nodeToSave = item.node;
                    VaultNodeChanged reply2 = new VaultNodeChanged();
                    reply2.nodeId = nodeToSave.getIdx();
                    reply2.revisionId = Guid.fullyRandom();
                    byte[] nodeData = nodeToSave.getAllBytes();
                    Node.SaveNode(nodeData, reply2, null);
                    continue;
                }
                m.throwUncaughtException("unhandled");
                continue;
            }
            try {
                Thread.sleep(4L);
            }
            catch (Exception exception) {
            }
        }
    }

    public void HandleMessage(Object msg, ConnectionState cs) {
        Class<?> klass = msg.getClass();
        if (klass == PingRequest.class) {
            m.msg("AuthServer PingRequest");
            PingRequest request = (PingRequest)msg;
            PingReply reply = new PingReply();
            reply.timestamp = request.timestamp;
            reply.transId = request.transId;
            reply.buffersize = request.buffer.length;
            reply.buffer = request.buffer;
            AuthServer.SendMsg(cs, reply);
        } else if (klass == ClientRegisterRequest.class) {
            m.msg("AuthServer ClientRegisterRequest");
            ClientRegisterRequest request = (ClientRegisterRequest)msg;
            ClientRegisterReply reply = new ClientRegisterReply();
            reply.serverchallenge = RandomUtils.rng.nextInt();
            cs.serverchallenge = reply.serverchallenge;
            AuthServer.SendMsg(cs, reply);
        } else if (klass == AcctLoginRequest.class) {
            AcctLoginRequest request = (AcctLoginRequest)msg;
            m.msg("AuthServer AcctLoginRequest: " + request.accountName.toString());
            Database.accountinfo user = this.manager.database.GetUser(request.accountName.toString());
            AcctLoginReply reply = new AcctLoginReply();
            reply.transId = request.transId;
            if (user == null) {
                reply.result = 13;
                reply.accountUUID = Guid.none();
                reply.accountFlags = 0;
                reply.billingType = 0;
            } else if (!request.checkPassword(user.passwordhash, cs.serverchallenge)) {
                reply.result = 20;
                reply.accountUUID = Guid.none();
                reply.accountFlags = 0;
                reply.billingType = 0;
            } else {
                reply.result = 0;
                reply.accountUUID = user.guid;
                reply.accountFlags = user.flags;
                reply.billingType = user.billingtype;
                cs.setAccount(user);
            }
            reply.encryptionKey = SuperManager.GetTalcumNotthedroids();
            if (reply.result == 0) {
                ServerAddr msg1 = new ServerAddr();
                msg1.address = 168496141;
                msg1.guid = Guid.none();
                AuthServer.SendMsg(cs, msg1);
                Vector nodes = this.manager.database.sqlquery("SELECT * FROM vault WHERE type=? AND uuid_1=?", 2, cs.account.guid).cast();
                for (Node.PlayerNode node : nodes) {
                    AcctPlayerInfo msg2 = new AcctPlayerInfo();
                    msg2.transId = request.transId;
                    msg2.playerId = node.getIdx();
                    msg2.playerName = new Str(node.getPlayerName());
                    msg2.avatarModel = new Str(node.getAvatarShape());
                    msg2.explorer = node.getExplorer();
                    AuthServer.SendMsg(cs, msg2);
                }
            }
            AuthServer.SendMsg(cs, reply);
        } else if (klass == FileListRequest.class) {
            m.msg("AuthServer FileListRequest");
            FileListRequest request = (FileListRequest)msg;
            FileListReply reply = new FileListReply();
            reply.transId = request.transId;
            reply.result = 0;
            reply.manifest = SecureDownloadManifest.getManifest(request.dir.toString(), request.extension.toString(), this.manager, this.securefiles);
            AuthServer.SendMsg(cs, reply);
        } else if (klass == FileDownloadRequest.class) {
            try {
                m.msg("AuthServer FileDownloadRequest");
                FileDownloadRequest request = (FileDownloadRequest)msg;
                File f = FileServer.GetFile(request.filename.toString(), this.manager.settings.getAuthFileserverPath());
                byte[] encdata = this.securefiles.GetEncrypted(f.getAbsolutePath());
                ByteArrayInputStream fis = new ByteArrayInputStream(encdata);
                int filesize = encdata.length;
                ChunkSendHandler.ChunkFile chunk = cs.chunksendhandler.startfile(request.filename.toString(), filesize, request.transId, fis, true);
                FileDownloadChunk reply = new FileDownloadChunk();
                reply.transId = request.transId;
                reply.result = 0;
                reply.filesize = filesize;
                reply.chunkOffset = chunk.offset();
                reply.buffer = chunk.read();
                AuthServer.SendMsg(cs, reply);
            }
            catch (Exception e2) {
                throw new nested(e2);
            }
        } else if (klass == FileDownloadChunkAck.class) {
            FileDownloadChunkAck ack = (FileDownloadChunkAck)msg;
            ChunkSendHandler.ChunkFile chunk = cs.chunksendhandler.ack(ack.transId);
            if (!chunk.done) {
                FileDownloadChunk reply = new FileDownloadChunk();
                reply.transId = ack.transId;
                reply.result = 0;
                reply.filesize = chunk.filesize;
                reply.chunkOffset = chunk.offset();
                reply.buffer = chunk.read();
                AuthServer.SendMsg(cs, reply);
            } else {
                cs.chunksendhandler.clearfile(ack.transId);
            }
        } else if (klass == AcctSetPlayerRequest.class) {
            m.msg("AuthServer AcctSetPlayerRequest");
            AcctSetPlayerRequest request = (AcctSetPlayerRequest)msg;
            cs.setPlayerIdx(request.playerId);
            if (cs.listener != null) {
                cs.listener.unregister();
            }
            if (cs.playerId != 0) {
                Node.PlayerInfoNode playerinfo = Node.PlayerInfoNode.getFromPlayerId(cs.playerId);
                cs.playerInfoIdx = playerinfo.getIdx();
                cs.nodemgr = NodeManager.CreateNewNodeManager(cs.playerId);
            }
            AcctSetPlayerReply reply = new AcctSetPlayerReply();
            reply.transId = request.transId;
            reply.result = 0;
            AuthServer.SendMsg(cs, reply);
        } else if (klass == PlayerCreateRequest.class) {
            m.msg("AuthServer PlayerCreateRequest");
            PlayerCreateRequest request = (PlayerCreateRequest)msg;
            PlayerCreateReply reply = new PlayerCreateReply();
            String playerName = request.playerName.toString();
            Node.PlayerNode playernode = Node.PlayerNode.findByName(playerName);
            if (playernode == null) {
                playernode = NodeUtils.CreatePlayer(playerName, request.avatarShape.toString(), new Guid(cs.account.guid));
                reply.result = 0;
                reply.playerId = playernode.getIdx();
                reply.explorer = playernode.getExplorer();
            } else {
                reply.result = 12;
                reply.playerId = 0;
                reply.explorer = 0;
            }
            reply.transId = request.transId;
            reply.playerName = request.playerName;
            reply.avatarModel = request.avatarShape;
            AuthServer.SendMsg(cs, reply);
        } else if (klass == VaultFetchNodeRefs.class) {
            m.msg("AuthServer VaultFetchNodeRefs");
            VaultFetchNodeRefs request = (VaultFetchNodeRefs)msg;
            VaultNodeRefsFetched reply = new VaultNodeRefsFetched();
            reply.transId = request.transId;
            reply.refs = Node.FindTreeRefs(request.nodeId);
            for (Node.Ref ref : reply.refs) {
                m.msg("    " + ref.dump());
            }
            reply.result = 0;
            this.manager.vaultlistener.SubscribeIfApplicable(request.nodeId, cs.weakitems, reply.refs);
            AuthServer.SendMsg(cs, reply);
        } else if (klass == VaultNodeFetch.class) {
            m.msg("AuthServer VaultNodeFetch");
            VaultNodeFetch request = (VaultNodeFetch)msg;
            Object n = Node.getNodeWithIndex(request.nodeId);
            byte[] nodedata = ((Node)n).getAllBytes();
            VaultNodeFetched reply = new VaultNodeFetched();
            reply.transId = request.transId;
            reply.result = 0;
            reply.data = nodedata;
            AuthServer.SendMsg(cs, reply);
        } else if (klass == VaultNodeSave.class) {
            VaultNodeSave request = (VaultNodeSave)msg;
            m.msg("AuthServer VaultNodeSave: " + Integer.toString(request.nodeId));
            VaultSaveNodeReply reply = new VaultSaveNodeReply();
            reply.transId = request.transId;
            reply.result = 0;
            AuthServer.SendMsg(cs, reply);
            VaultNodeChanged reply2 = new VaultNodeChanged();
            reply2.nodeId = request.nodeId;
            reply2.revisionId = request.revisionId;
            Node.SaveNode(request.nodeData, reply2, cs);
        } else if (klass == VaultInitAgeRequest.class) {
            m.msg("AuthServer VaultInitAgeRequest");
            VaultInitAgeRequest request = (VaultInitAgeRequest)msg;
            NodeUtils.CreateAgeReturnInfo info = NodeUtils.CreateAge(cs.playerId, request.ageFilename.toString(), request.ageinstanceGuid, cs.playerInfoIdx, request.ageInstanceName.toString(), request.ageUserName.toString(), request.ageDescription.toString());
            VaultInitAgeReply reply = new VaultInitAgeReply();
            reply.transId = request.transId;
            reply.result = 0;
            reply.ageVaultId = info.age.getIdx();
            reply.ageInfoVaultId = info.ageinfo.getIdx();
            AuthServer.SendMsg(cs, reply);
        } else if (klass == VaultNodeCreate.class) {
            m.msg("AuthServer VaultNodeCreate");
            VaultNodeCreate request = (VaultNodeCreate)msg;
            RawNode n = new RawNode(request.nodeData);
            n.setFieldsOnNewNode();
            n.insert();
            VaultNodeCreated reply = new VaultNodeCreated();
            reply.transId = request.transId;
            reply.result = 0;
            reply.nodeId = n.nodeIdx;
            AuthServer.SendMsg(cs, reply);
        } else if (klass == VaultNodeAdd.class) {
            m.msg("AuthServer VaultNodeAdd");
            VaultNodeAdd request = (VaultNodeAdd)msg;
            Node.createLink(request.parentId, request.childId, request.ownerId, (byte)0);
            VaultNodeAdded reply2 = new VaultNodeAdded();
            reply2.parentId = request.parentId;
            reply2.childId = request.childId;
            reply2.ownerId = request.ownerId;
            AuthServer.SendMsg(cs, reply2);
            VaultAddNodeReply reply = new VaultAddNodeReply();
            reply.transId = request.transId;
            reply.result = 0;
            AuthServer.SendMsg(cs, reply);
        } else if (klass == AgeRequest.class) {
            m.msg("AuthServer AgeRequest");
            AgeRequest request = (AgeRequest)msg;
            AgeReply reply = new AgeReply();
            reply.transId = request.transId;
            reply.result = 0;
            GameServer gameserver = this.manager.gamemainserver.requestGameserverFromGuid(request.ageInstanceGuid, request.ageName.toString(), cs.playerId);
            reply.ageMCPId = gameserver.gameServerNumber;
            reply.ageInstanceGuid = request.ageInstanceGuid;
            Node.AgeNode age = Node.AgeNode.findFromGuid(request.ageInstanceGuid);
            reply.ageVaultId = age.getIdx();
            reply.gameServerAddress = this.manager.address;
            AuthServer.SendMsg(cs, reply);
        } else if (klass == LogPythonTraceback.class) {
            m.msg("AuthServer LogPythonTraceback");
            LogPythonTraceback log = (LogPythonTraceback)msg;
            m.msg(log.text.toString());
        } else if (klass == LogStackDump.class) {
            m.msg("AuthServer LogStackDump");
            LogStackDump log = (LogStackDump)msg;
            m.msg(log.dumptext.toString());
        } else if (klass == VaultNodeFind.class) {
            m.msg("AuthServer VaultNodeFind");
            VaultNodeFind request = (VaultNodeFind)msg;
            VaultNodeFindReply reply = new VaultNodeFindReply();
            reply.transId = request.transId;
            RawNode rawnode = new RawNode(request.nodedata);
            reply.nodeIds = rawnode.makeSqlQuery();
            if (reply.nodeIds.length == 1) {
                reply.result = 0;
            } else if (reply.nodeIds.length == 0) {
                reply.result = 18;
            } else {
                m.throwUncaughtException("is this okay?");
            }
            AuthServer.SendMsg(cs, reply);
            boolean bl = false;
        } else {
            m.throwUncaughtException("Unhandled AuthServer packet: " + klass.getSimpleName());
        }
    }

    public static AuthMsg ReadMessage(IBytestream c, boolean isServer) {
        short msgId = c.readShort();
        if (isServer) {
            switch (msgId) {
                case 0: {
                    return new PingRequest(c);
                }
                case 1: {
                    return new ClientRegisterRequest(c);
                }
                case 3: {
                    return new AcctLoginRequest(c);
                }
                case 37: {
                    return new FileListRequest(c);
                }
                case 38: {
                    return new FileDownloadRequest(c);
                }
                case 39: {
                    return new FileDownloadChunkAck(c);
                }
                case 6: {
                    return new AcctSetPlayerRequest(c);
                }
                case 17: {
                    return new PlayerCreateRequest(c);
                }
                case 31: {
                    return new VaultFetchNodeRefs(c);
                }
                case 26: {
                    return new VaultNodeFetch(c);
                }
                case 27: {
                    return new VaultNodeSave(c);
                }
                case 32: {
                    return new VaultInitAgeRequest(c);
                }
                case 25: {
                    return new VaultNodeCreate(c);
                }
                case 29: {
                    return new VaultNodeAdd(c);
                }
                case 36: {
                    return new AgeRequest(c);
                }
                case 33: {
                    return new VaultNodeFind(c);
                }
                case 43: {
                    return new LogPythonTraceback(c);
                }
                case 48: {
                    return new ScoreGetScores(c);
                }
                case 13: {
                    return new PlayerDeleteRequest(c);
                }
                case 44: {
                    return new LogStackDump(c);
                }
            }
            throw new uncaughtexception("Unread AuthServer packet: " + Short.toString(msgId));
        }
        switch (msgId) {
            case 0: {
                return new PingReply(c);
            }
            case 3: {
                return new ClientRegisterReply(c);
            }
            case 1: {
                return new ServerAddr(c);
            }
            case 6: {
                return new AcctPlayerInfo(c);
            }
            case 4: {
                return new AcctLoginReply(c);
            }
            case 36: {
                return new FileListReply(c);
            }
            case 37: {
                return new FileDownloadChunk(c);
            }
            case 24: {
                return new VaultNodeFetched(c);
            }
            case 29: {
                return new VaultNodeRefsFetched(c);
            }
            case 7: {
                return new AcctSetPlayerReply(c);
            }
            case 31: {
                return new VaultNodeFindReply(c);
            }
            case 25: {
                return new VaultNodeChanged(c);
            }
            case 32: {
                return new VaultSaveNodeReply(c);
            }
            case 35: {
                return new AgeReply(c);
            }
            case 43: {
                return new ScoreGetScoresReply(c);
            }
            case 17: {
                return new PlayerDeleteReply(c);
            }
            case 16: {
                return new PlayerCreateReply(c);
            }
            case 30: {
                return new VaultInitAgeReply(c);
            }
            case 23: {
                return new VaultNodeCreated(c);
            }
            case 27: {
                return new VaultNodeAdded(c);
            }
            case 33: {
                return new VaultAddNodeReply(c);
            }
            case 39: {
                return new KickedOff(c);
            }
        }
        throw new uncaughtexception("Unread AuthServer packet: " + Short.toString(msgId));
    }

    static void SendMsg(ConnectionState cs, AuthMsg msg) {
        Bytedeque c = new Bytedeque(Format.moul);
        c.writeShort(msg.type());
        msg.write(c);
        byte[] data = c.getAllBytes();
        cs.sendMsgBytes(data);
    }

    public static abstract class AuthMsg
    extends Server.ServerMsg {
        public abstract short type();

        @Override
        public byte[] GetMsgBytes() {
            Bytedeque c = new Bytedeque(Format.moul);
            ((IBytedeque)c).writeShort(this.type());
            this.write(c);
            byte[] data = ((IBytedeque)c).getAllBytes();
            return data;
        }
    }

    public static class ClientRegisterRequest
    extends AuthMsg {
        int buildId;

        public ClientRegisterRequest() {
        }

        public ClientRegisterRequest(IBytestream c) {
            this.buildId = c.readInt();
        }

        @Override
        public short type() {
            return 1;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.buildId);
        }
    }

    public static class ClientRegisterReply
    extends AuthMsg {
        int serverchallenge;

        public ClientRegisterReply() {
        }

        public ClientRegisterReply(IBytestream c) {
            this.serverchallenge = c.readInt();
        }

        @Override
        public short type() {
            return 3;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.serverchallenge);
        }
    }

    public static class PingReply
    extends AuthMsg {
        int timestamp;
        int transId;
        int buffersize;
        byte[] buffer;

        public PingReply() {
        }

        public PingReply(IBytestream c) {
            this.timestamp = c.readInt();
            this.transId = c.readInt();
            this.buffersize = c.readInt();
            this.buffer = c.readBytes(this.buffersize);
        }

        @Override
        public short type() {
            return 0;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.timestamp);
            c.writeInt(this.transId);
            c.writeInt(this.buffer.length);
            c.writeBytes(this.buffer);
        }
    }

    public static class PingRequest
    extends AuthMsg {
        int timestamp;
        int transId;
        private int buffersize;
        byte[] buffer;

        public PingRequest(IBytestream c) {
            this.timestamp = c.readInt();
            this.transId = c.readInt();
            this.buffersize = c.readInt();
            this.buffer = c.readBytes(this.buffersize);
        }

        @Override
        public short type() {
            return 0;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.timestamp);
            c.writeInt(this.transId);
            c.writeInt(this.buffer.length);
            c.writeBytes(this.buffer);
        }
    }

    public static class AcctLoginRequest
    extends AuthMsg {
        int transId;
        int clientchallenge;
        Str accountName;
        byte[] passwordHash;
        Str authToken;
        Str OS;

        public AcctLoginRequest(IBytestream c) {
            this.transId = c.readInt();
            this.clientchallenge = c.readInt();
            this.accountName = Str.readAsUtf16Sized16(c);
            this.passwordHash = c.readBytes(20);
            this.authToken = Str.readAsUtf16Sized16(c);
            this.OS = Str.readAsUtf16Sized16(c);
        }

        public AcctLoginRequest() {
        }

        @Override
        public short type() {
            return 3;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.clientchallenge);
            this.accountName.writeAsUtf16Sized16(c);
            if (this.passwordHash.length != 20) {
                m.throwUncaughtException("unexpected");
            }
            c.writeBytes(this.passwordHash);
            this.authToken.writeAsUtf16Sized16(c);
            this.OS.writeAsUtf16Sized16(c);
        }

        public static byte[] getStoredHash(String username, String password) {
            if (AcctLoginRequest.isUsernameEmailForm(username)) {
                byte[] pwbs = b.Utf16ToBytes(password);
                byte[] unbs = b.Utf16ToBytes(username.toLowerCase());
                byte[] both = new byte[pwbs.length + unbs.length];
                b.CopyBytes(pwbs, both, 0);
                b.CopyBytes(unbs, both, pwbs.length);
                both[pwbs.length - 1] = 0;
                both[pwbs.length - 2] = 0;
                both[both.length - 1] = 0;
                both[both.length - 2] = 0;
                Sha0 sha0 = new Sha0();
                sha0.update(both, 0, both.length);
                return sha0.digest();
            }
            return CryptHashes.GetHash(b.StringToBytes(password), CryptHashes.Hashtype.sha1);
        }

        public boolean checkPassword(byte[] storedhash, int serverchallenge) {
            return b.isEqual(this.passwordHash, AcctLoginRequest.getTransmittedHash(this.accountName.toString(), storedhash, serverchallenge, this.clientchallenge));
        }

        public static boolean isUsernameEmailForm(String username) {
            return username.matches(".+\\@.+\\..+");
        }

        public static byte[] getTransmittedHash(String username, byte[] storedhash, int serverchallenge, int clientchallenge) {
            if (AcctLoginRequest.isUsernameEmailForm(username)) {
                byte[] all = new byte[8 + storedhash.length];
                b.loadInt32IntoBytes(clientchallenge, all, 0);
                b.loadInt32IntoBytes(serverchallenge, all, 4);
                b.CopyBytes(storedhash, all, 8);
                Sha0 sha0 = new Sha0();
                sha0.update(all, 0, all.length);
                return sha0.digest();
            }
            byte[] r = new byte[20];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    r[i * 4 + j] = storedhash[i * 4 + (3 - j)];
                }
            }
            return r;
        }

        public void setPassword(String username, String password, int serverchallenge, int clientchallenge) {
            this.passwordHash = AcctLoginRequest.getTransmittedHash(username, AcctLoginRequest.getStoredHash(username, password), serverchallenge, clientchallenge);
        }
    }

    public static class AcctLoginReply
    extends AuthMsg {
        int transId;
        int result;
        byte[] accountUUID;
        int accountFlags;
        int billingType;
        int[] encryptionKey;

        public AcctLoginReply() {
        }

        public AcctLoginReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.accountUUID = c.readBytes(16);
            this.accountFlags = c.readInt();
            this.billingType = c.readInt();
            this.encryptionKey = c.readInts(4);
        }

        @Override
        public short type() {
            return 4;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeBytes(this.accountUUID);
            c.writeInt(this.accountFlags);
            c.writeInt(this.billingType);
            c.writeInts(this.encryptionKey);
        }
    }

    public static class FileListRequest
    extends AuthMsg {
        int transId;
        Str dir;
        Str extension;

        public FileListRequest() {
        }

        @Override
        public short type() {
            return 37;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        public FileListRequest(IBytestream c) {
            this.transId = c.readInt();
            this.dir = Str.readAsUtf16Sized16(c);
            this.extension = Str.readAsUtf16Sized16(c);
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            this.dir.writeAsUtf16Sized16(c);
            this.extension.writeAsUtf16Sized16(c);
        }
    }

    public static class FileListReply
    extends AuthMsg {
        int transId;
        int result;
        private int charcount;
        SecureDownloadManifest manifest;

        @Override
        public short type() {
            return 36;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        public FileListReply() {
        }

        public FileListReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.charcount = c.readInt();
            this.manifest = new SecureDownloadManifest(c);
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            Bytedeque d = new Bytedeque(Format.moul);
            this.manifest.write(d);
            byte[] manifestbs = d.getAllBytes();
            c.writeInt(manifestbs.length / 2);
            c.writeBytes(manifestbs);
        }
    }

    public static class ServerAddr
    extends AuthMsg {
        int address;
        byte[] guid;

        public ServerAddr(IBytestream c) {
            this.address = c.readInt();
            this.guid = c.readBytes(16);
        }

        public ServerAddr() {
        }

        @Override
        public short type() {
            return 1;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.address);
            c.writeBytes(this.guid);
        }
    }

    public static class AcctPlayerInfo
    extends AuthMsg {
        int transId;
        int playerId;
        Str playerName;
        Str avatarModel;
        int explorer;

        public AcctPlayerInfo(IBytestream c) {
            this.transId = c.readInt();
            this.playerId = c.readInt();
            this.playerName = Str.readAsUtf16Sized16(c);
            this.avatarModel = Str.readAsUtf16Sized16(c);
            this.explorer = c.readInt();
        }

        public AcctPlayerInfo() {
        }

        @Override
        public short type() {
            return 6;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.playerId);
            this.playerName.writeAsUtf16Sized16(c);
            this.avatarModel.writeAsUtf16Sized16(c);
            c.writeInt(this.explorer);
        }
    }

    public static class FileDownloadRequest
    extends AuthMsg {
        int transId;
        Str filename;

        @Override
        public short type() {
            return 38;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        public FileDownloadRequest() {
        }

        public FileDownloadRequest(IBytestream c) {
            this.transId = c.readInt();
            this.filename = Str.readAsUtf16Sized16(c);
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            this.filename.writeAsUtf16Sized16(c);
        }
    }

    public static class FileDownloadChunk
    extends AuthMsg {
        int transId;
        int result;
        int filesize;
        int chunkOffset;
        int buffersize;
        byte[] buffer;

        @Override
        public short type() {
            return 37;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        public FileDownloadChunk() {
        }

        public FileDownloadChunk(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.filesize = c.readInt();
            this.chunkOffset = c.readInt();
            this.buffersize = c.readInt();
            this.buffer = c.readBytes(this.buffersize);
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.filesize);
            c.writeInt(this.chunkOffset);
            c.writeInt(this.buffer.length);
            c.writeBytes(this.buffer);
        }
    }

    public static class FileDownloadChunkAck
    extends AuthMsg {
        int transId;

        @Override
        public short type() {
            return 39;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        public FileDownloadChunkAck() {
        }

        public FileDownloadChunkAck(IBytestream c) {
            this.transId = c.readInt();
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
        }
    }

    public static class AcctSetPlayerRequest
    extends AuthMsg {
        int transId;
        int playerId;

        public AcctSetPlayerRequest(IBytestream c) {
            this.transId = c.readInt();
            this.playerId = c.readInt();
        }

        public AcctSetPlayerRequest() {
        }

        @Override
        public short type() {
            return 6;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.playerId);
        }
    }

    public static class AcctSetPlayerReply
    extends AuthMsg {
        int transId;
        int result;

        public AcctSetPlayerReply() {
        }

        public AcctSetPlayerReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
        }

        @Override
        public short type() {
            return 7;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
        }
    }

    public static class PlayerCreateRequest
    extends AuthMsg {
        int transId;
        Str playerName;
        Str avatarShape;
        Str friendInvite;

        public PlayerCreateRequest(IBytestream c) {
            this.transId = c.readInt();
            this.playerName = Str.readAsUtf16Sized16(c);
            this.avatarShape = Str.readAsUtf16Sized16(c);
            this.friendInvite = Str.readAsUtf16Sized16(c);
        }

        public PlayerCreateRequest() {
        }

        @Override
        public short type() {
            return 17;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            this.playerName.writeAsUtf16Sized16(c);
            this.avatarShape.writeAsUtf16Sized16(c);
            this.friendInvite.writeAsUtf16Sized16(c);
        }
    }

    public static class PlayerCreateReply
    extends AuthMsg {
        int transId;
        int result;
        int playerId;
        int explorer;
        Str playerName;
        Str avatarModel;

        public PlayerCreateReply() {
        }

        public PlayerCreateReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.playerId = c.readInt();
            this.explorer = c.readInt();
            this.playerName = Str.readAsUtf16Sized16(c);
            this.avatarModel = Str.readAsUtf16Sized16(c);
        }

        @Override
        public short type() {
            return 16;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.playerId);
            c.writeInt(this.explorer);
            this.playerName.writeAsUtf16Sized16(c);
            this.avatarModel.writeAsUtf16Sized16(c);
        }
    }

    public static class VaultFetchNodeRefs
    extends AuthMsg {
        int transId;
        int nodeId;

        public VaultFetchNodeRefs(IBytestream c) {
            this.transId = c.readInt();
            this.nodeId = c.readInt();
        }

        public VaultFetchNodeRefs() {
        }

        @Override
        public short type() {
            return 31;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.nodeId);
        }

        @Override
        public String dump() {
            return super.dump() + " : nodeId=" + Integer.toString(this.nodeId);
        }
    }

    public static class VaultNodeRefsFetched
    extends AuthMsg {
        public int transId;
        public int result;
        private int numrefs;
        public ArrayList<Node.Ref> refs;

        public VaultNodeRefsFetched() {
            this.refs = new ArrayList();
        }

        public VaultNodeRefsFetched(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.numrefs = c.readInt();
            this.refs = new ArrayList();
            for (int i = 0; i < this.numrefs; ++i) {
                this.refs.add(new Node.Ref(c));
            }
        }

        @Override
        public short type() {
            return 29;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.refs.size());
            for (Node.Ref ref : this.refs) {
                ref.write(c);
            }
        }

        @Override
        public String dump() {
            StringBuilder r = new StringBuilder();
            r.append(super.dump() + " : ");
            for (Node.Ref ref : this.refs) {
                r.append("\n    " + ref.dump());
            }
            return r.toString();
        }
    }

    public static class VaultNodeFetch
    extends AuthMsg {
        int transId;
        int nodeId;

        public VaultNodeFetch() {
        }

        public VaultNodeFetch(IBytestream c) {
            this.transId = c.readInt();
            this.nodeId = c.readInt();
        }

        @Override
        public short type() {
            return 26;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.nodeId);
        }

        @Override
        public String dump() {
            return super.dump() + " : nodeIdx=" + Integer.toString(this.nodeId);
        }
    }

    public static class VaultNodeFetched
    extends AuthMsg {
        int transId;
        int result;
        int sizeofbytes;
        byte[] data;

        public VaultNodeFetched() {
        }

        public VaultNodeFetched(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.sizeofbytes = c.readInt();
            this.data = c.readBytes(this.sizeofbytes);
        }

        @Override
        public short type() {
            return 24;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.data.length);
            c.writeBytes(this.data);
        }

        @Override
        public String dump() {
            RawNode raw = new RawNode(this.data);
            return super.dump() + " : " + raw.dump();
        }
    }

    public static class VaultNodeSave
    extends AuthMsg {
        int transId;
        int nodeId;
        Guid revisionId;
        private int size;
        byte[] nodeData;

        public VaultNodeSave(IBytestream c) {
            this.transId = c.readInt();
            this.nodeId = c.readInt();
            this.revisionId = new Guid(c);
            this.size = c.readInt();
            this.nodeData = c.readBytes(this.size);
        }

        public VaultNodeSave() {
        }

        @Override
        public short type() {
            return 27;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.nodeId);
            this.revisionId.write(c);
            c.writeInt(this.nodeData.length);
            c.writeBytes(this.nodeData);
        }

        @Override
        public String dump() {
            RawNode raw = new RawNode(this.nodeData);
            return super.dump() + " : nodeId=" + Integer.toString(this.nodeId) + " revisionId=" + this.revisionId.toString() + " node=" + raw.dump();
        }
    }

    public static class VaultNodeChanged
    extends AuthMsg {
        int nodeId;
        Guid revisionId;

        public VaultNodeChanged() {
        }

        public VaultNodeChanged(IBytestream c) {
            this.nodeId = c.readInt();
            this.revisionId = new Guid(c);
        }

        @Override
        public short type() {
            return 25;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.nodeId);
            this.revisionId.write(c);
        }

        @Override
        public String dump() {
            return super.dump() + " : nodeId=" + Integer.toString(this.nodeId) + " revisionId=" + this.revisionId.toString();
        }
    }

    public static class VaultSaveNodeReply
    extends AuthMsg {
        int transId;
        int result;

        public VaultSaveNodeReply() {
        }

        public VaultSaveNodeReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
        }

        @Override
        public short type() {
            return 32;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
        }
    }

    public static class VaultInitAgeRequest
    extends AuthMsg {
        int transId;
        Guid ageinstanceGuid;
        Guid parentAgeGuid;
        Str ageFilename;
        Str ageInstanceName;
        Str ageUserName;
        Str ageDescription;
        int ageSequenceNumber;
        int ageLanguage;

        public VaultInitAgeRequest(IBytestream c) {
            this.transId = c.readInt();
            this.ageinstanceGuid = new Guid(c);
            this.parentAgeGuid = new Guid(c);
            this.ageFilename = Str.readAsUtf16Sized16(c);
            this.ageInstanceName = Str.readAsUtf16Sized16(c);
            this.ageUserName = Str.readAsUtf16Sized16(c);
            this.ageDescription = Str.readAsUtf16Sized16(c);
            this.ageSequenceNumber = c.readInt();
            this.ageLanguage = c.readInt();
        }

        @Override
        public short type() {
            return 32;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            this.ageinstanceGuid.write(c);
            this.parentAgeGuid.write(c);
            this.ageFilename.writeAsUtf16Sized16(c);
            this.ageInstanceName.writeAsUtf16Sized16(c);
            this.ageUserName.writeAsUtf16Sized16(c);
            this.ageDescription.writeAsUtf16Sized16(c);
            c.writeInt(this.ageSequenceNumber);
            c.writeInt(this.ageLanguage);
        }
    }

    public static class VaultInitAgeReply
    extends AuthMsg {
        int transId;
        int result;
        int ageVaultId;
        int ageInfoVaultId;

        public VaultInitAgeReply() {
        }

        public VaultInitAgeReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.ageVaultId = c.readInt();
            this.ageInfoVaultId = c.readInt();
        }

        @Override
        public short type() {
            return 30;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.ageVaultId);
            c.writeInt(this.ageInfoVaultId);
        }
    }

    public static class VaultNodeCreate
    extends AuthMsg {
        int transId;
        private int size;
        byte[] nodeData;

        public VaultNodeCreate(IBytestream c) {
            this.transId = c.readInt();
            this.size = c.readInt();
            this.nodeData = c.readBytes(this.size);
        }

        @Override
        public short type() {
            return 25;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.nodeData.length);
            c.writeBytes(this.nodeData);
        }
    }

    public static class VaultNodeCreated
    extends AuthMsg {
        int transId;
        int result;
        int nodeId;

        public VaultNodeCreated() {
        }

        public VaultNodeCreated(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.nodeId = c.readInt();
        }

        @Override
        public short type() {
            return 23;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.nodeId);
        }
    }

    public static class VaultNodeAdd
    extends AuthMsg {
        int transId;
        int parentId;
        int childId;
        int ownerId;

        public VaultNodeAdd(IBytestream c) {
            this.transId = c.readInt();
            this.parentId = c.readInt();
            this.childId = c.readInt();
            this.ownerId = c.readInt();
        }

        @Override
        public short type() {
            return 29;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.parentId);
            c.writeInt(this.childId);
            c.writeInt(this.ownerId);
        }
    }

    public static class VaultNodeAdded
    extends AuthMsg {
        int parentId;
        int childId;
        int ownerId;

        public VaultNodeAdded() {
        }

        public VaultNodeAdded(IBytestream c) {
            this.parentId = c.readInt();
            this.childId = c.readInt();
            this.ownerId = c.readInt();
        }

        @Override
        public short type() {
            return 27;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.parentId);
            c.writeInt(this.childId);
            c.writeInt(this.ownerId);
        }
    }

    public static class VaultAddNodeReply
    extends AuthMsg {
        int transId;
        int result;

        public VaultAddNodeReply() {
        }

        public VaultAddNodeReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
        }

        @Override
        public short type() {
            return 33;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
        }
    }

    public static class AgeRequest
    extends AuthMsg {
        int transId;
        Str ageName;
        Guid ageInstanceGuid;

        public AgeRequest(IBytestream c) {
            this.transId = c.readInt();
            this.ageName = Str.readAsUtf16Sized16(c);
            this.ageInstanceGuid = new Guid(c);
        }

        @Override
        public short type() {
            return 36;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            this.ageName.writeAsUtf16Sized16(c);
            this.ageInstanceGuid.write(c);
        }
    }

    public static class AgeReply
    extends AuthMsg {
        int transId;
        int result;
        int ageMCPId;
        Guid ageInstanceGuid;
        int ageVaultId;
        int gameServerAddress;

        public AgeReply() {
        }

        public AgeReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.ageMCPId = c.readInt();
            this.ageInstanceGuid = new Guid(c);
            this.ageVaultId = c.readInt();
            this.gameServerAddress = c.readInt();
        }

        @Override
        public short type() {
            return 35;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.ageMCPId);
            this.ageInstanceGuid.write(c);
            c.writeInt(this.ageVaultId);
            c.writeInt(this.gameServerAddress);
        }
    }

    public static class VaultNodeFind
    extends AuthMsg {
        int transId;
        private int size;
        byte[] nodedata;

        public VaultNodeFind() {
        }

        public VaultNodeFind(IBytestream c) {
            this.transId = c.readInt();
            this.size = c.readInt();
            this.nodedata = c.readBytes(this.size);
            boolean dummy = false;
        }

        @Override
        public short type() {
            return 33;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.nodedata.length);
            c.writeBytes(this.nodedata);
        }

        @Override
        public String dump() {
            StringBuilder r = new StringBuilder();
            r.append(super.dump());
            RawNode node = new RawNode(this.nodedata);
            r.append(" : " + node.toString());
            return r.toString();
        }
    }

    public static class VaultNodeFindReply
    extends AuthMsg {
        int transId;
        int result;
        int numNodesFound;
        int[] nodeIds;

        public VaultNodeFindReply() {
        }

        public VaultNodeFindReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.numNodesFound = c.readInt();
            this.nodeIds = c.readInts(this.numNodesFound);
        }

        @Override
        public short type() {
            return 31;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.nodeIds.length);
            c.writeInts(this.nodeIds);
        }
    }

    public static class LogPythonTraceback
    extends AuthMsg {
        Str text;

        public LogPythonTraceback() {
        }

        public LogPythonTraceback(IBytestream c) {
            this.text = Str.readAsUtf16Sized16(c);
        }

        @Override
        public short type() {
            return 43;
        }

        @Override
        public void write(IBytedeque c) {
            this.text.writeAsUtf16Sized16(c);
        }
    }

    public static class ScoreGetScores
    extends AuthMsg {
        int transId;
        int ownerIdx;
        Str gamename;

        public ScoreGetScores() {
        }

        public ScoreGetScores(IBytestream c) {
            this.transId = c.readInt();
            this.ownerIdx = c.readInt();
            this.gamename = Str.readAsUtf16Sized16(c);
        }

        @Override
        public short type() {
            return 48;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.ownerIdx);
            this.gamename.writeAsUtf16Sized16(c);
        }
    }

    public static class ScoreGetScoresReply
    extends AuthMsg {
        int transId;
        int result;
        int scoreCount;
        private int size;
        byte[] scoreData;

        public ScoreGetScoresReply() {
        }

        public ScoreGetScoresReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.scoreCount = c.readInt();
            this.size = c.readInt();
            if (this.size != 0) {
                boolean bl = false;
            }
            this.scoreData = c.readBytes(this.size);
        }

        @Override
        public short type() {
            return 43;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.scoreCount);
            c.writeInt(this.scoreData.length);
            c.writeBytes(this.scoreData);
        }
    }

    public static class PlayerDeleteRequest
    extends AuthMsg {
        int transId;
        int playerId;

        public PlayerDeleteRequest() {
        }

        public PlayerDeleteRequest(IBytestream c) {
            this.transId = c.readInt();
            this.playerId = c.readInt();
        }

        @Override
        public short type() {
            return 13;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.playerId);
        }
    }

    public static class PlayerDeleteReply
    extends AuthMsg {
        int transId;
        int result;

        public PlayerDeleteReply() {
        }

        public PlayerDeleteReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
        }

        @Override
        public short type() {
            return 17;
        }

        @Override
        public Integer transid() {
            return this.transId;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
        }
    }

    public static class KickedOff
    extends AuthMsg {
        int reason;

        public KickedOff() {
        }

        public KickedOff(IBytestream c) {
            this.reason = c.readInt();
            m.msg("Kicked off! Reason: ", Integer.toString(this.reason));
        }

        @Override
        public short type() {
            return 39;
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.reason);
        }
    }

    public static class LogStackDump
    extends AuthMsg {
        Str dumptext;

        public LogStackDump() {
        }

        public LogStackDump(IBytestream c) {
            this.dumptext = Str.readAsUtf16Sized16(c);
        }

        @Override
        public short type() {
            return 44;
        }

        @Override
        public void write(IBytedeque c) {
            this.dumptext.writeAsUtf16Sized16(c);
        }
    }
}

