/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.util.ArrayDeque;
import java.util.Iterator;
import prpobjects.Uruobjectdesc;
import prpobjects._staticsettings;
import shared.BaseContext;
import shared.Bytes;
import shared.Format;
import shared.IBytedeque;
import shared.b;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bytedeque2
extends IBytedeque {
    ArrayDeque<byte[]> deque = new ArrayDeque();
    private int curpos = 0;
    public Uruobjectdesc curRootObject = null;
    public BaseContext context;

    public Bytedeque2(Format format) {
        this.format = format;
    }

    @Override
    protected Iterator<byte[]> getIterator() {
        return this.deque.iterator();
    }

    public void prependBytes(byte[] data) {
        this.deque.addFirst(data);
    }

    public void writeBytes(Bytes data) {
        this.writeBytes(data.getByteArray());
    }

    public void writeBytes(byte[] data, int offset, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = data[offset + i];
        }
        this.writeBytes(result);
    }

    @Override
    public void writeBytes(byte[] data) {
        this.deque.addLast(data);
        int oldpos = this.curpos;
        this.curpos += data.length;
        int breakpoint = _staticsettings.breakpoint;
        if (breakpoint > oldpos && breakpoint <= this.curpos) {
            boolean i = false;
        }
    }

    public void writeMultiDimensionBytes(byte[][] data) {
        for (int i = 0; i < data.length; ++i) {
            this.writeBytes(data[i]);
        }
    }

    public void writeMultiDimensionInts2(int[][] data) {
        for (int i = 0; i < data.length; ++i) {
            this.writeInts2(data[i]);
        }
    }

    public void writeInts2(int[] ints) {
        for (int i = 0; i < ints.length; ++i) {
            this.writeInt(ints[i]);
        }
    }

    @Override
    public void writeShorts(short[] shorts) {
        for (int i = 0; i < shorts.length; ++i) {
            this.writeShort(shorts[i]);
        }
    }

    public void prependInts(int[] ints) {
        for (int i = ints.length - 1; i >= 0; --i) {
            this.prependInt(ints[i]);
        }
    }

    public void prependShorts(short[] shorts) {
        for (int i = shorts.length - 1; i >= 0; --i) {
            this.writeShort(shorts[i]);
        }
    }

    public void prependByte(byte num) {
        byte[] data = b.ByteToBytes(num);
        this.prependBytes(data);
    }

    public void prependShort(short num) {
        byte[] data = b.Int16ToBytes(num);
        this.prependBytes(data);
    }

    public void prependInt(int num) {
        byte[] data = b.Int32ToBytes(num);
        this.prependBytes(data);
    }

    @Override
    public void writeByte(byte b2) {
        byte[] data = new byte[]{b2};
        this.writeBytes(data);
    }

    @Override
    public void writeShort(short s) {
        byte[] data = b.Int16ToBytes(s);
        this.writeBytes(data);
    }

    @Override
    public void writeInt(int i) {
        byte[] data = b.Int32ToBytes(i);
        this.writeBytes(data);
    }

    public void prependBytedeque(Bytedeque2 d) {
        byte[] bytes = d.getAllBytes();
        this.prependBytes(bytes);
    }

    public void writeBytedeque(Bytedeque2 d) {
        byte[] bytes = d.getAllBytes();
        this.writeBytes(bytes);
    }

    @Override
    public byte[] getAllBytes() {
        int bytecount = 0;
        Iterator<byte[]> iterator = this.deque.iterator();
        while (iterator.hasNext()) {
            bytecount += iterator.next().length;
        }
        if (bytecount > 50000000) {
            boolean dummy = false;
        }
        byte[] result = null;
        result = new byte[bytecount];
        int curpos = 0;
        for (byte[] curarray : this.deque) {
            b.CopyBytes(curarray, result, curpos);
            curpos += curarray.length;
        }
        return result;
    }

    public Bytes getBytes() {
        return new Bytes(this.getAllBytes());
    }

    @Override
    public IBytedeque Fork() {
        Bytedeque2 result = new Bytedeque2(this.format);
        return result;
    }
}

