/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.Arrays;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.security.SHA256;
import org.h2.table.MetaTable;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends RightOwner {
    private final boolean systemUser;
    private byte[] salt;
    private byte[] passwordHash;
    private boolean admin;

    public User(Database database, int n, String string, boolean bl) {
        super(database, n, string, "user");
        this.systemUser = bl;
    }

    public void setAdmin(boolean bl) {
        this.admin = bl;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setSaltAndHash(byte[] byArray, byte[] byArray2) {
        this.salt = byArray;
        this.passwordHash = byArray2;
    }

    public void setUserPasswordHash(byte[] byArray) {
        if (byArray != null) {
            this.salt = new byte[8];
            MathUtils.randomBytes(this.salt);
            SHA256 sHA256 = new SHA256();
            this.passwordHash = sHA256.getHashWithSalt(byArray, this.salt);
        }
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(true, false);
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    public void checkRight(Table table, int n) {
        if (!this.hasRight(table, n)) {
            throw DbException.get(90096, table.getSQL());
        }
    }

    public boolean hasRight(Table table, int n) {
        TableView tableView;
        if (n != 1 && !this.systemUser) {
            table.checkWritingAllowed();
        }
        if (this.admin) {
            return true;
        }
        Role role = this.database.getPublicRole();
        if (role.isRightGrantedRecursive(table, n)) {
            return true;
        }
        if (table instanceof MetaTable || table instanceof RangeTable) {
            return true;
        }
        String string = table.getTableType();
        if ("VIEW".equals(string) ? (tableView = (TableView)table).getOwner() == this : string == null) {
            return true;
        }
        if (table.isTemporary() && !table.isGlobalTemporary()) {
            return true;
        }
        return this.isRightGrantedRecursive(table, n);
    }

    public String getCreateSQL(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder("CREATE USER ");
        if (bl2) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(this.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        if (bl) {
            stringBuilder.append(" SALT '").append(Utils.convertBytesToString(this.salt)).append("' HASH '").append(Utils.convertBytesToString(this.passwordHash)).append('\'');
        } else {
            stringBuilder.append(" PASSWORD ''");
        }
        if (this.admin) {
            stringBuilder.append(" ADMIN");
        }
        return stringBuilder.toString();
    }

    public boolean validateUserPasswordHash(byte[] byArray) {
        SHA256 sHA256 = new SHA256();
        byte[] byArray2 = sHA256.getHashWithSalt(byArray, this.salt);
        return Utils.compareSecure(byArray2, this.passwordHash);
    }

    public void checkAdmin() {
        if (!this.admin) {
            throw DbException.get(90040);
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> arrayList = New.arrayList();
        for (Right dbObjectBase : this.database.getAllRights()) {
            if (dbObjectBase.getGrantee() != this) continue;
            arrayList.add(dbObjectBase);
        }
        for (Schema schema : this.database.getAllSchemas()) {
            if (schema.getOwner() != this) continue;
            arrayList.add(schema);
        }
        return arrayList;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantee() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        this.salt = null;
        Arrays.fill(this.passwordHash, (byte)0);
        this.passwordHash = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public void checkOwnsNoSchemas() {
        for (Schema schema : this.database.getAllSchemas()) {
            if (this != schema.getOwner()) continue;
            throw DbException.get(90107, this.getName(), schema.getName());
        }
    }
}

