/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingArrayQueue<E>
extends AbstractList<E>
implements BlockingQueue<E> {
    public final int DEFAULT_CAPACITY = 128;
    public final int DEFAULT_GROWTH = 64;
    private final int _limit;
    private final AtomicInteger _size = new AtomicInteger();
    private final int _growCapacity;
    private volatile int _capacity;
    private Object[] _elements;
    private int _head;
    private int _tail;
    private final ReentrantLock _headLock = new ReentrantLock();
    private final Condition _notEmpty = this._headLock.newCondition();
    private final ReentrantLock _tailLock = new ReentrantLock();

    public BlockingArrayQueue() {
        this._elements = new Object[128];
        this._growCapacity = 64;
        this._capacity = this._elements.length;
        this._limit = Integer.MAX_VALUE;
    }

    public BlockingArrayQueue(int limit) {
        this._elements = new Object[limit];
        this._capacity = this._elements.length;
        this._growCapacity = -1;
        this._limit = limit;
    }

    public BlockingArrayQueue(int capacity, int growBy) {
        this._elements = new Object[capacity];
        this._capacity = this._elements.length;
        this._growCapacity = growBy;
        this._limit = Integer.MAX_VALUE;
    }

    public BlockingArrayQueue(int capacity, int growBy, int limit) {
        if (capacity > limit) {
            throw new IllegalArgumentException();
        }
        this._elements = new Object[capacity];
        this._capacity = this._elements.length;
        this._growCapacity = growBy;
        this._limit = limit;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public int getLimit() {
        return this._limit;
    }

    @Override
    public boolean add(E e2) {
        return this.offer(e2);
    }

    @Override
    public E element() {
        E e2 = this.peek();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        if (this._size.get() == 0) {
            return null;
        }
        Object e2 = null;
        this._headLock.lock();
        try {
            if (this._size.get() > 0) {
                e2 = this._elements[this._head];
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        boolean not_empty = false;
        this._tailLock.lock();
        try {
            if (this._size.get() >= this._limit) {
                boolean bl = false;
                return bl;
            }
            if (this._size.get() == this._capacity) {
                this._headLock.lock();
                try {
                    if (!this.grow()) {
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    this._headLock.unlock();
                }
            }
            this._elements[this._tail] = e2;
            this._tail = (this._tail + 1) % this._capacity;
            not_empty = 0 == this._size.getAndIncrement();
        }
        finally {
            this._tailLock.unlock();
        }
        if (not_empty) {
            this._headLock.lock();
            try {
                this._notEmpty.signal();
            }
            finally {
                this._headLock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        if (this._size.get() == 0) {
            return null;
        }
        Object e2 = null;
        this._headLock.lock();
        try {
            if (this._size.get() > 0) {
                int head = this._head;
                e2 = this._elements[head];
                this._elements[head] = null;
                this._head = (head + 1) % this._capacity;
                if (this._size.decrementAndGet() > 0) {
                    this._notEmpty.signal();
                }
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        Object e2 = null;
        this._headLock.lockInterruptibly();
        try {
            try {
                while (this._size.get() == 0) {
                    this._notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this._notEmpty.signal();
                throw ie;
            }
            int head = this._head;
            e2 = this._elements[head];
            this._elements[head] = null;
            this._head = (head + 1) % this._capacity;
            if (this._size.decrementAndGet() > 0) {
                this._notEmpty.signal();
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long time, TimeUnit unit) throws InterruptedException {
        Object e2 = null;
        long nanos = unit.toNanos(time);
        this._headLock.lockInterruptibly();
        try {
            while (this._size.get() == 0) {
                if (nanos <= 0L) {
                    E e3 = null;
                    return e3;
                }
                try {
                    nanos = this._notEmpty.awaitNanos(nanos);
                }
                catch (InterruptedException ie) {
                    this._notEmpty.signal();
                    throw ie;
                }
            }
            e2 = this._elements[this._head];
            this._elements[this._head] = null;
            this._head = (this._head + 1) % this._capacity;
            if (this._size.decrementAndGet() > 0) {
                this._notEmpty.signal();
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)e2;
    }

    @Override
    public E remove() {
        E e2 = this.poll();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                this._head = 0;
                this._tail = 0;
                this._size.set(0);
            }
            finally {
                this._headLock.unlock();
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this._size.get() == 0;
    }

    @Override
    public int size() {
        return this._size.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        this._tailLock.lock();
        try {
            Object object;
            this._headLock.lock();
            try {
                if (index < 0 || index >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
                }
                int i = this._head + index;
                if (i >= this._capacity) {
                    i -= this._capacity;
                }
                object = this._elements[i];
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return (E)object;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        this._tailLock.lock();
        try {
            Object object;
            this._headLock.lock();
            try {
                if (index < 0 || index >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
                }
                int i = this._head + index;
                if (i >= this._capacity) {
                    i -= this._capacity;
                }
                Object old = this._elements[i];
                if (i < this._tail) {
                    System.arraycopy(this._elements, i + 1, this._elements, i, this._tail - i);
                    --this._tail;
                    this._size.decrementAndGet();
                } else {
                    System.arraycopy(this._elements, i + 1, this._elements, i, this._capacity - i - 1);
                    if (this._tail > 0) {
                        this._elements[this._capacity] = this._elements[0];
                        System.arraycopy(this._elements, 1, this._elements, 0, this._tail - 1);
                        --this._tail;
                    } else {
                        this._tail = this._capacity - 1;
                    }
                    this._size.decrementAndGet();
                }
                object = old;
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return (E)object;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        this._tailLock.lock();
        try {
            Object object;
            this._headLock.lock();
            try {
                if (index < 0 || index >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
                }
                int i = this._head + index;
                if (i >= this._capacity) {
                    i -= this._capacity;
                }
                Object old = this._elements[i];
                this._elements[i] = e2;
                object = old;
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return (E)object;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                if (index < 0 || index > this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
                }
                if (index == this._size.get()) {
                    this.add(e2);
                } else {
                    if (this._tail == this._head && !this.grow()) {
                        throw new IllegalStateException("full");
                    }
                    int i = this._head + index;
                    if (i >= this._capacity) {
                        i -= this._capacity;
                    }
                    this._size.incrementAndGet();
                    this._tail = (this._tail + 1) % this._capacity;
                    if (i < this._tail) {
                        System.arraycopy(this._elements, i, this._elements, i + 1, this._tail - i);
                        this._elements[i] = e2;
                    } else {
                        if (this._tail > 0) {
                            System.arraycopy(this._elements, 0, this._elements, 1, this._tail);
                            this._elements[0] = this._elements[this._capacity - 1];
                        }
                        System.arraycopy(this._elements, i, this._elements, i + 1, this._capacity - i - 1);
                        this._elements[i] = e2;
                    }
                }
            }
            finally {
                this._headLock.unlock();
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean grow() {
        if (this._growCapacity <= 0) {
            return false;
        }
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int new_tail;
                int head = this._head;
                int tail = this._tail;
                Object[] elements = new Object[this._capacity + this._growCapacity];
                if (head < tail) {
                    new_tail = tail - head;
                    System.arraycopy(this._elements, head, elements, 0, new_tail);
                } else if (head > tail || this._size.get() > 0) {
                    new_tail = this._capacity + tail - head;
                    int cut = this._capacity - head;
                    System.arraycopy(this._elements, head, elements, 0, cut);
                    System.arraycopy(this._elements, 0, elements, cut, tail);
                } else {
                    new_tail = 0;
                }
                this._elements = elements;
                this._capacity = this._elements.length;
                this._head = 0;
                this._tail = new_tail;
                boolean bl = true;
                this._headLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(E o) throws InterruptedException {
        if (!this.add(o)) {
            throw new IllegalStateException("full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int n = this.getCapacity() - this.size();
                this._headLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }
}

