//
//  Tables.h
//  DPCIManager
//
//  Created by PHPdev32 on 9/16/12.
//

#ifndef DPCIManager_Tables_h
#define DPCIManager_Tables_h

#include "License.h"

#define CODEC_ID(vendor,device) ((((UInt32) vendor & 0xffff) << 16) | \
((UInt32) device & 0xffff))

#define HDA_DEV_MATCH(fl, v)		((fl) == (v) || (fl) == 0xffffffff || \
(((fl) & 0xffff0000) == 0xffff0000 && ((fl) & 0x0000ffff) == ((v) & 0x0000ffff)) || \
(((fl) & 0x0000ffff) == 0x0000ffff && ((fl) & 0xffff0000) == ((v) & 0xffff0000)))

/* All codecs you can eat... */
#define HDA_CODEC_CONSTRUCT(vendor, id) (((UInt32) (vendor##_VENDORID) << 16) | ((id) & 0xffff))

/* Cirrus Logic */
#define CIRRUSLOGIC_VENDORID		0x1013
#define HDA_CODEC_CS4206			HDA_CODEC_CONSTRUCT(CIRRUSLOGIC, 0x4206)
#define HDA_CODEC_CS4207			HDA_CODEC_CONSTRUCT(CIRRUSLOGIC, 0x4207)
#define HDA_CODEC_CS4210			HDA_CODEC_CONSTRUCT(CIRRUSLOGIC, 0x4210)
#define HDA_CODEC_CS4213            HDA_CODEC_CONSTRUCT(CIRRUSLOGIC, 0x4213)
#define HDA_CODEC_CSXXXX			HDA_CODEC_CONSTRUCT(CIRRUSLOGIC, 0xffff)

/* Realtek */
#define REALTEK_VENDORID			0x10ec
#define HDA_CODEC_ALC221			HDA_CODEC_CONSTRUCT(REALTEK, 0x0221)
#define HDA_CODEC_ALC225            HDA_CODEC_CONSTRUCT(REALTEK, 0x0225)
#define HDA_CODEC_ALC230            HDA_CODEC_CONSTRUCT(REALTEK, 0x0230)
#define HDA_CODEC_ALC233            HDA_CODEC_CONSTRUCT(REALTEK, 0x0233)
#define HDA_CODEC_ALC235            HDA_CODEC_CONSTRUCT(REALTEK, 0x0235)
#define HDA_CODEC_ALC236            HDA_CODEC_CONSTRUCT(REALTEK, 0x0236)
#define HDA_CODEC_ALC255            HDA_CODEC_CONSTRUCT(REALTEK, 0x0255)
#define HDA_CODEC_ALC256            HDA_CODEC_CONSTRUCT(REALTEK, 0x0256)
#define HDA_CODEC_ALC257            HDA_CODEC_CONSTRUCT(REALTEK, 0x0257)
#define HDA_CODEC_ALC260			HDA_CODEC_CONSTRUCT(REALTEK, 0x0260)
#define HDA_CODEC_ALC262			HDA_CODEC_CONSTRUCT(REALTEK, 0x0262)
#define HDA_CODEC_ALC267			HDA_CODEC_CONSTRUCT(REALTEK, 0x0267)
#define HDA_CODEC_ALC268			HDA_CODEC_CONSTRUCT(REALTEK, 0x0268)
#define HDA_CODEC_ALC269			HDA_CODEC_CONSTRUCT(REALTEK, 0x0269)
#define HDA_CODEC_ALC270			HDA_CODEC_CONSTRUCT(REALTEK, 0x0270)
#define HDA_CODEC_ALC272			HDA_CODEC_CONSTRUCT(REALTEK, 0x0272)
#define HDA_CODEC_ALC273			HDA_CODEC_CONSTRUCT(REALTEK, 0x0273)
#define HDA_CODEC_ALC275			HDA_CODEC_CONSTRUCT(REALTEK, 0x0275)
#define HDA_CODEC_ALC276			HDA_CODEC_CONSTRUCT(REALTEK, 0x0276)
#define HDA_CODEC_ALC280            HDA_CODEC_CONSTRUCT(REALTEK, 0x0280)
#define HDA_CODEC_ALC282            HDA_CODEC_CONSTRUCT(REALTEK, 0x0282)
#define HDA_CODEC_ALC283            HDA_CODEC_CONSTRUCT(REALTEK, 0x0283)
#define HDA_CODEC_ALC284            HDA_CODEC_CONSTRUCT(REALTEK, 0x0284)
#define HDA_CODEC_ALC285            HDA_CODEC_CONSTRUCT(REALTEK, 0x0285)
#define HDA_CODEC_ALC286            HDA_CODEC_CONSTRUCT(REALTEK, 0x0286)
#define HDA_CODEC_ALC288            HDA_CODEC_CONSTRUCT(REALTEK, 0x0288)
#define HDA_CODEC_ALC290            HDA_CODEC_CONSTRUCT(REALTEK, 0x0290)
#define HDA_CODEC_ALC292            HDA_CODEC_CONSTRUCT(REALTEK, 0x0292)
#define HDA_CODEC_ALC293            HDA_CODEC_CONSTRUCT(REALTEK, 0x0293)
#define HDA_CODEC_ALC294            HDA_CODEC_CONSTRUCT(REALTEK, 0x0294)
#define HDA_CODEC_ALC295            HDA_CODEC_CONSTRUCT(REALTEK, 0x0295)
#define HDA_CODEC_ALC298            HDA_CODEC_CONSTRUCT(REALTEK, 0x0298)
#define HDA_CODEC_ALC299            HDA_CODEC_CONSTRUCT(REALTEK, 0x0299)
#define HDA_CODEC_ALC660			HDA_CODEC_CONSTRUCT(REALTEK, 0x0660)
#define HDA_CODEC_ALC861            HDA_CODEC_CONSTRUCT(REALTEK, 0x0861)
#define HDA_CODEC_ALC662			HDA_CODEC_CONSTRUCT(REALTEK, 0x0662)
#define HDA_CODEC_ALC861VD          HDA_CODEC_CONSTRUCT(REALTEK, 0x0862)
#define HDA_CODEC_ALC663			HDA_CODEC_CONSTRUCT(REALTEK, 0x0663)
#define HDA_CODEC_ALC665			HDA_CODEC_CONSTRUCT(REALTEK, 0x0665)
#define HDA_CODEC_ALC668            HDA_CODEC_CONSTRUCT(REALTEK, 0x0668)
#define HDA_CODEC_ALC670			HDA_CODEC_CONSTRUCT(REALTEK, 0x0670)
#define HDA_CODEC_ALC671            HDA_CODEC_CONSTRUCT(REALTEK, 0x0671)
#define HDA_CODEC_ALC680			HDA_CODEC_CONSTRUCT(REALTEK, 0x0680)
#define HDA_CODEC_ALC880			HDA_CODEC_CONSTRUCT(REALTEK, 0x0880)
#define HDA_CODEC_ALC882			HDA_CODEC_CONSTRUCT(REALTEK, 0x0882)
#define HDA_CODEC_ALC883			HDA_CODEC_CONSTRUCT(REALTEK, 0x0883)
#define HDA_CODEC_ALC885			HDA_CODEC_CONSTRUCT(REALTEK, 0x0885)
#define HDA_CODEC_ALC887			HDA_CODEC_CONSTRUCT(REALTEK, 0x0887)
#define HDA_CODEC_ALC888			HDA_CODEC_CONSTRUCT(REALTEK, 0x0888)
#define HDA_CODEC_ALC889			HDA_CODEC_CONSTRUCT(REALTEK, 0x0889)
#define HDA_CODEC_ALC891            HDA_CODEC_CONSTRUCT(REALTEK, 0x0891)
#define HDA_CODEC_ALC892			HDA_CODEC_CONSTRUCT(REALTEK, 0x0892)
#define HDA_CODEC_ALC898			HDA_CODEC_CONSTRUCT(REALTEK, 0x0898)
#define HDA_CODEC_ALC899            HDA_CODEC_CONSTRUCT(REALTEK, 0x0899)
#define HDA_CODEC_ALC1150			HDA_CODEC_CONSTRUCT(REALTEK, 0x0900)
#define HDA_CODEC_ALCS1200A         HDA_CODEC_CONSTRUCT(REALTEK, 0x0B00) // A = Asus
#define HDA_CODEC_ALCS1220A         HDA_CODEC_CONSTRUCT(REALTEK, 0x1168) // A = Asus
#define HDA_CODEC_ALC1220           HDA_CODEC_CONSTRUCT(REALTEK, 0x1220)
#define HDA_CODEC_ALCXXXX			HDA_CODEC_CONSTRUCT(REALTEK, 0xffff)

/* Motorola */
#define MOTO_VENDORID				0x1057
#define HDA_CODEC_MOTOXXXX			HDA_CODEC_CONSTRUCT(MOTO, 0xffff)

/* Creative */
#define CREATIVE_VENDORID			0x1102
#define HDA_CODEC_CA0110			HDA_CODEC_CONSTRUCT(CREATIVE, 0x000a)
#define HDA_CODEC_CA0110_2			HDA_CODEC_CONSTRUCT(CREATIVE, 0x000b)
#define HDA_CODEC_SB0880			HDA_CODEC_CONSTRUCT(CREATIVE, 0x000d)
#define HDA_CODEC_CA0132			HDA_CODEC_CONSTRUCT(CREATIVE, 0x0011)
#define HDA_CODEC_CAXXXX			HDA_CODEC_CONSTRUCT(CREATIVE, 0xffff)

/* Analog Devices */
#define ANALOGDEVICES_VENDORID		0x11d4
#define HDA_CODEC_AD1884A			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x184a)
#define HDA_CODEC_AD1882			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x1882)
#define HDA_CODEC_AD1883			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x1883)
#define HDA_CODEC_AD1884			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x1884)
#define HDA_CODEC_AD1984A			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x194a)
#define HDA_CODEC_AD1984B			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x194b)
#define HDA_CODEC_AD1981HD			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x1981)
#define HDA_CODEC_AD1983			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x1983)
#define HDA_CODEC_AD1984			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x1984)
#define HDA_CODEC_AD1986A			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x1986)
#define HDA_CODEC_AD1987			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x1987)
#define HDA_CODEC_AD1988			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x1988)
#define HDA_CODEC_AD1988B			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x198b)
#define HDA_CODEC_AD1882A			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x882a)
#define HDA_CODEC_AD1989A			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x989a)
#define HDA_CODEC_AD1989B			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0x989b)
#define HDA_CODEC_ADXXXX			HDA_CODEC_CONSTRUCT(ANALOGDEVICES, 0xffff)

/* CMedia */
#define CMEDIA_VENDORID				0x13f6
#define HDA_CODEC_CMI9880			HDA_CODEC_CONSTRUCT(CMEDIA, 0x9880)
#define HDA_CODEC_CMIXXXX			HDA_CODEC_CONSTRUCT(CMEDIA, 0xffff)

#define CMEDIA2_VENDORID			0x434d
#define HDA_CODEC_CMI98802			HDA_CODEC_CONSTRUCT(CMEDIA2, 0x4980)
#define HDA_CODEC_CMIXXXX2			HDA_CODEC_CONSTRUCT(CMEDIA2, 0xffff)

/* Sigmatel */
#define SIGMATEL_VENDORID			0x8384
#define HDA_CODEC_STAC9230X			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7612)
#define HDA_CODEC_STAC9230D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7613)
#define HDA_CODEC_STAC9229X			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7614)
#define HDA_CODEC_STAC9229D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7615)
#define HDA_CODEC_STAC9228X			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7616)
#define HDA_CODEC_STAC9228D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7617)
#define HDA_CODEC_STAC9227X			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7618)
#define HDA_CODEC_STAC9227D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7619)
#define HDA_CODEC_STAC9274			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7620)
#define HDA_CODEC_STAC9274D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7621)
#define HDA_CODEC_STAC9273X			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7622)
#define HDA_CODEC_STAC9273D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7623)
#define HDA_CODEC_STAC9272X			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7624)
#define HDA_CODEC_STAC9272D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7625)
#define HDA_CODEC_STAC9271X			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7626)
#define HDA_CODEC_STAC9271D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7627)
#define HDA_CODEC_STAC9274X5NH		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7628)
#define HDA_CODEC_STAC9274D5NH		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7629)
#define HDA_CODEC_STAC9250			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7634)
#define HDA_CODEC_STAC9251			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7636)
#define HDA_CODEC_IDT92HD700X		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7638)
#define HDA_CODEC_IDT92HD700D		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7639)
#define HDA_CODEC_IDT92HD206X		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7645)
#define HDA_CODEC_IDT92HD206D		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7646)
#define HDA_CODEC_CXD9872RDK		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7661)
#define HDA_CODEC_STAC9872AK		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7662)
#define HDA_CODEC_CXD9872AKD		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7664)
#define HDA_CODEC_STAC9221			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7680)
#define HDA_CODEC_STAC922XD			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7681)
#define HDA_CODEC_STAC9221_A2		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7682)
#define HDA_CODEC_STAC9221D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7683)
#define HDA_CODEC_STAC9220			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7690)
#define HDA_CODEC_STAC9200          HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7690)
#define HDA_CODEC_STAC9200D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7691)
#define HDA_CODEC_IDT92HD005		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7698)
#define HDA_CODEC_IDT92HD005D		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7699)
#define HDA_CODEC_STAC9205X			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x76a0)
#define HDA_CODEC_STAC9205D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x76a1)
#define HDA_CODEC_STAC9204X			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x76a2)
#define HDA_CODEC_STAC9204D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x76a3)
#define HDA_CODEC_STAC9255			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x76a4)
#define HDA_CODEC_STAC9255D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x76a5)
#define HDA_CODEC_STAC9254			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x76a6)
#define HDA_CODEC_STAC9254D			HDA_CODEC_CONSTRUCT(SIGMATEL, 0x76a7)
#define HDA_CODEC_STAC9220_A2		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7880)
#define HDA_CODEC_STAC9220_A1		HDA_CODEC_CONSTRUCT(SIGMATEL, 0x7882)
#define HDA_CODEC_STACXXXX			HDA_CODEC_CONSTRUCT(SIGMATEL, 0xffff)

/* IDT */
#define IDT_VENDORID				0x111d
#define HDA_CODEC_IDT92HD75BX		HDA_CODEC_CONSTRUCT(IDT, 0x7603)
#define HDA_CODEC_IDT92HD83C1X		HDA_CODEC_CONSTRUCT(IDT, 0x7604)
#define HDA_CODEC_IDT92HD81B1X		HDA_CODEC_CONSTRUCT(IDT, 0x7605)
#define HDA_CODEC_IDT92HD75B3		HDA_CODEC_CONSTRUCT(IDT, 0x7608)
#define HDA_CODEC_IDT92HD73D1		HDA_CODEC_CONSTRUCT(IDT, 0x7674)
#define HDA_CODEC_IDT92HD73C1		HDA_CODEC_CONSTRUCT(IDT, 0x7675)
#define HDA_CODEC_IDT92HD73E1		HDA_CODEC_CONSTRUCT(IDT, 0x7676)
#define HDA_CODEC_IDTID7695         HDA_CODEC_CONSTRUCT(IDT, 0x7695)
#define HDA_CODEC_IDT92HD71B8		HDA_CODEC_CONSTRUCT(IDT, 0x76b0)
#define HDA_CODEC_IDT92HD71B8_2		HDA_CODEC_CONSTRUCT(IDT, 0x76b1)
#define HDA_CODEC_IDT92HD71B7		HDA_CODEC_CONSTRUCT(IDT, 0x76b2)
#define HDA_CODEC_IDT92HD71B7_2		HDA_CODEC_CONSTRUCT(IDT, 0x76b3)
#define HDA_CODEC_IDT92HD71B6		HDA_CODEC_CONSTRUCT(IDT, 0x76b4)
#define HDA_CODEC_IDT92HD71B6_2		HDA_CODEC_CONSTRUCT(IDT, 0x76b5)
#define HDA_CODEC_IDT92HD71B5		HDA_CODEC_CONSTRUCT(IDT, 0x76b6)
#define HDA_CODEC_IDT92HD71B5_2		HDA_CODEC_CONSTRUCT(IDT, 0x76b7)
#define HDA_CODEC_IDT92HD89C3		HDA_CODEC_CONSTRUCT(IDT, 0x76c0)
#define HDA_CODEC_IDT92HD89C2		HDA_CODEC_CONSTRUCT(IDT, 0x76c1)
#define HDA_CODEC_IDT92HD89C1		HDA_CODEC_CONSTRUCT(IDT, 0x76c2)
#define HDA_CODEC_IDT92HD89B3		HDA_CODEC_CONSTRUCT(IDT, 0x76c3)
#define HDA_CODEC_IDT92HD89B2		HDA_CODEC_CONSTRUCT(IDT, 0x76c4)
#define HDA_CODEC_IDT92HD89B1		HDA_CODEC_CONSTRUCT(IDT, 0x76c5)
#define HDA_CODEC_IDT92HD89E3		HDA_CODEC_CONSTRUCT(IDT, 0x76c6)
#define HDA_CODEC_IDT92HD89E2		HDA_CODEC_CONSTRUCT(IDT, 0x76c7)
#define HDA_CODEC_IDT92HD89E1		HDA_CODEC_CONSTRUCT(IDT, 0x76c8)
#define HDA_CODEC_IDT92HD89D3		HDA_CODEC_CONSTRUCT(IDT, 0x76c9)
#define HDA_CODEC_IDT92HD89D2		HDA_CODEC_CONSTRUCT(IDT, 0x76ca)
#define HDA_CODEC_IDT92HD89D1		HDA_CODEC_CONSTRUCT(IDT, 0x76cb)
#define HDA_CODEC_IDT92HD89F3		HDA_CODEC_CONSTRUCT(IDT, 0x76cc)
#define HDA_CODEC_IDT92HD89F2		HDA_CODEC_CONSTRUCT(IDT, 0x76cd)
#define HDA_CODEC_IDT92HD89F1		HDA_CODEC_CONSTRUCT(IDT, 0x76ce)
#define HDA_CODEC_IDT92HD87B1_3		HDA_CODEC_CONSTRUCT(IDT, 0x76d1)
#define HDA_CODEC_IDT92HD83C1C		HDA_CODEC_CONSTRUCT(IDT, 0x76d4)
#define HDA_CODEC_IDT92HD81B1C		HDA_CODEC_CONSTRUCT(IDT, 0x76d5)
#define HDA_CODEC_IDT92HD87B2_4		HDA_CODEC_CONSTRUCT(IDT, 0x76d9)
#define HDA_CODEC_IDT92HD93BXX		HDA_CODEC_CONSTRUCT(IDT, 0x76df)
#define HDA_CODEC_IDT92HD91BXX		HDA_CODEC_CONSTRUCT(IDT, 0x76e0)
#define HDA_CODEC_IDT92HD98BXX		HDA_CODEC_CONSTRUCT(IDT, 0x76e3)
#define HDA_CODEC_IDT92HD99BXX		HDA_CODEC_CONSTRUCT(IDT, 0x76e5)
#define HDA_CODEC_IDT92HD90BXX		HDA_CODEC_CONSTRUCT(IDT, 0x76e7)
#define HDA_CODEC_IDT92HD66B1X5		HDA_CODEC_CONSTRUCT(IDT, 0x76e8)
#define HDA_CODEC_IDT92HD66B2X5		HDA_CODEC_CONSTRUCT(IDT, 0x76e9)
#define HDA_CODEC_IDT92HD66B3X5		HDA_CODEC_CONSTRUCT(IDT, 0x76ea)
#define HDA_CODEC_IDT92HD66C1X5		HDA_CODEC_CONSTRUCT(IDT, 0x76eb)
#define HDA_CODEC_IDT92HD66C2X5		HDA_CODEC_CONSTRUCT(IDT, 0x76ec)
#define HDA_CODEC_IDT92HD66C3X5		HDA_CODEC_CONSTRUCT(IDT, 0x76ed)
#define HDA_CODEC_IDT92HD66B1X3		HDA_CODEC_CONSTRUCT(IDT, 0x76ee)
#define HDA_CODEC_IDT92HD66B2X3		HDA_CODEC_CONSTRUCT(IDT, 0x76ef)
#define HDA_CODEC_IDT92HD66B3X3		HDA_CODEC_CONSTRUCT(IDT, 0x76f0)
#define HDA_CODEC_IDT92HD66C1X3		HDA_CODEC_CONSTRUCT(IDT, 0x76f1)
#define HDA_CODEC_IDT92HD66C2X3		HDA_CODEC_CONSTRUCT(IDT, 0x76f2)
#define HDA_CODEC_IDT92HD66C3_65	HDA_CODEC_CONSTRUCT(IDT, 0x76f3)
#define HDA_CODEC_IDTXXXX			HDA_CODEC_CONSTRUCT(IDT, 0xffff)

/* Silicon Image */
#define SII_VENDORID				0x1095
#define HDA_CODEC_SII1390			HDA_CODEC_CONSTRUCT(SII, 0x1390)
#define HDA_CODEC_SII1392			HDA_CODEC_CONSTRUCT(SII, 0x1392)
#define HDA_CODEC_SIIXXXX			HDA_CODEC_CONSTRUCT(SII, 0xffff)

/* Lucent/Agere */
#define AGERE_VENDORID				0x11c1
#define HDA_CODEC_AGEREXXXX			HDA_CODEC_CONSTRUCT(AGERE, 0xffff)

/* Conexant */
#define CONEXANT_VENDORID			0x14f1
#define HDA_CODEC_CX8050            HDA_CODEC_CONSTRUCT(CONEXANT, 0x1f72)
#define HDA_CODEC_CX8150            HDA_CODEC_CONSTRUCT(CONEXANT, 0x1fd6)
#define HDA_CODEC_CX8200            HDA_CODEC_CONSTRUCT(CONEXANT, 0x2008)
#define HDA_CODEC_CX8400            HDA_CODEC_CONSTRUCT(CONEXANT, 0x20d0)
#define HDA_CODEC_CX20549			HDA_CODEC_CONSTRUCT(CONEXANT, 0x5045)
#define HDA_CODEC_CX20551			HDA_CODEC_CONSTRUCT(CONEXANT, 0x5047)
#define HDA_CODEC_CX20561			HDA_CODEC_CONSTRUCT(CONEXANT, 0x5051)
#define HDA_CODEC_CX20582			HDA_CODEC_CONSTRUCT(CONEXANT, 0x5066)
#define HDA_CODEC_CX20583			HDA_CODEC_CONSTRUCT(CONEXANT, 0x5067)
#define HDA_CODEC_CX20584			HDA_CODEC_CONSTRUCT(CONEXANT, 0x5068)
#define HDA_CODEC_CX20585			HDA_CODEC_CONSTRUCT(CONEXANT, 0x5069)
#define HDA_CODEC_CX20588			HDA_CODEC_CONSTRUCT(CONEXANT, 0x506c)
#define HDA_CODEC_CX20590			HDA_CODEC_CONSTRUCT(CONEXANT, 0x506e)
#define HDA_CODEC_CX20631			HDA_CODEC_CONSTRUCT(CONEXANT, 0x5097)
#define HDA_CODEC_CX20632			HDA_CODEC_CONSTRUCT(CONEXANT, 0x5098)
#define HDA_CODEC_CX20641			HDA_CODEC_CONSTRUCT(CONEXANT, 0x50a1)
#define HDA_CODEC_CX20642			HDA_CODEC_CONSTRUCT(CONEXANT, 0x50a2)
#define HDA_CODEC_CX20651			HDA_CODEC_CONSTRUCT(CONEXANT, 0x50ab)
#define HDA_CODEC_CX20652			HDA_CODEC_CONSTRUCT(CONEXANT, 0x50ac)
#define HDA_CODEC_CX20664			HDA_CODEC_CONSTRUCT(CONEXANT, 0x50b8)
#define HDA_CODEC_CX20665			HDA_CODEC_CONSTRUCT(CONEXANT, 0x50b9)
#define HDA_CODEC_CX20722           HDA_CODEC_CONSTRUCT(CONEXANT, 0x50f2)
#define HDA_CODEC_CX20724           HDA_CODEC_CONSTRUCT(CONEXANT, 0x50f4)
#define HDA_CODEC_CX20751_2         HDA_CODEC_CONSTRUCT(CONEXANT, 0x510f)
#define HDA_CODEC_CX20753_4         HDA_CODEC_CONSTRUCT(CONEXANT, 0x5111)
#define HDA_CODEC_CX20755           HDA_CODEC_CONSTRUCT(CONEXANT, 0x5113)
#define HDA_CODEC_CX20756           HDA_CODEC_CONSTRUCT(CONEXANT, 0x5114)
#define HDA_CODEC_CX20757           HDA_CODEC_CONSTRUCT(CONEXANT, 0x5115)
#define HDA_CODEC_CXXXXX			HDA_CODEC_CONSTRUCT(CONEXANT, 0xffff)

/* VIA */
#define VIA_VENDORID				0x1106
#define HDA_CODEC_VT1702_0          HDA_CODEC_CONSTRUCT(VIA, 0x0398)
#define HDA_CODEC_VT1702_1          HDA_CODEC_CONSTRUCT(VIA, 0x1398)
#define HDA_CODEC_VT1702_2          HDA_CODEC_CONSTRUCT(VIA, 0x2398)
#define HDA_CODEC_VT1702_3          HDA_CODEC_CONSTRUCT(VIA, 0x3398)
#define HDA_CODEC_VT1702_4          HDA_CODEC_CONSTRUCT(VIA, 0x4398)
#define HDA_CODEC_VT1702_5          HDA_CODEC_CONSTRUCT(VIA, 0x5398)
#define HDA_CODEC_VT1702_6          HDA_CODEC_CONSTRUCT(VIA, 0x6398)
#define HDA_CODEC_VT1702_7          HDA_CODEC_CONSTRUCT(VIA, 0x7398)
#define HDA_CODEC_VT1705            HDA_CODEC_CONSTRUCT(VIA, 0x4760)
#define HDA_CODEC_VT1708_8			HDA_CODEC_CONSTRUCT(VIA, 0x1708)
#define HDA_CODEC_VT1708_9			HDA_CODEC_CONSTRUCT(VIA, 0x1709)
#define HDA_CODEC_VT1708_A			HDA_CODEC_CONSTRUCT(VIA, 0x170a)
#define HDA_CODEC_VT1708_B			HDA_CODEC_CONSTRUCT(VIA, 0x170b)
#define HDA_CODEC_VT1708B_0         HDA_CODEC_CONSTRUCT(VIA, 0xe720)
#define HDA_CODEC_VT1708B_1         HDA_CODEC_CONSTRUCT(VIA, 0xe721)
#define HDA_CODEC_VT1708B_2         HDA_CODEC_CONSTRUCT(VIA, 0xe722)
#define HDA_CODEC_VT1708B_3         HDA_CODEC_CONSTRUCT(VIA, 0xe723)
#define HDA_CODEC_VT1708B_4         HDA_CODEC_CONSTRUCT(VIA, 0xe724)
#define HDA_CODEC_VT1708B_5         HDA_CODEC_CONSTRUCT(VIA, 0xe725)
#define HDA_CODEC_VT1708B_6         HDA_CODEC_CONSTRUCT(VIA, 0xe726)
#define HDA_CODEC_VT1708B_7         HDA_CODEC_CONSTRUCT(VIA, 0xe727)
#define HDA_CODEC_VT1708S_0         HDA_CODEC_CONSTRUCT(VIA, 0x0397)
#define HDA_CODEC_VT1708S_1         HDA_CODEC_CONSTRUCT(VIA, 0x1397)
#define HDA_CODEC_VT1708S_2         HDA_CODEC_CONSTRUCT(VIA, 0x2397)
#define HDA_CODEC_VT1708S_3         HDA_CODEC_CONSTRUCT(VIA, 0x3397)
#define HDA_CODEC_VT1708S_4         HDA_CODEC_CONSTRUCT(VIA, 0x4397)
#define HDA_CODEC_VT1708S_5         HDA_CODEC_CONSTRUCT(VIA, 0x5397)
#define HDA_CODEC_VT1708S_6         HDA_CODEC_CONSTRUCT(VIA, 0x6397)
#define HDA_CODEC_VT1708S_7         HDA_CODEC_CONSTRUCT(VIA, 0x7397)
#define HDA_CODEC_VT1709_0			HDA_CODEC_CONSTRUCT(VIA, 0xe710)
#define HDA_CODEC_VT1709_1			HDA_CODEC_CONSTRUCT(VIA, 0xe711)
#define HDA_CODEC_VT1709_2			HDA_CODEC_CONSTRUCT(VIA, 0xe712)
#define HDA_CODEC_VT1709_3			HDA_CODEC_CONSTRUCT(VIA, 0xe713)
#define HDA_CODEC_VT1709_4			HDA_CODEC_CONSTRUCT(VIA, 0xe714)
#define HDA_CODEC_VT1709_5			HDA_CODEC_CONSTRUCT(VIA, 0xe715)
#define HDA_CODEC_VT1709_6			HDA_CODEC_CONSTRUCT(VIA, 0xe716)
#define HDA_CODEC_VT1709_7			HDA_CODEC_CONSTRUCT(VIA, 0xe717)
#define HDA_CODEC_VT1716S_0			HDA_CODEC_CONSTRUCT(VIA, 0x0433)
#define HDA_CODEC_VT1716S_1			HDA_CODEC_CONSTRUCT(VIA, 0xa721)
#define HDA_CODEC_VT1718S_0			HDA_CODEC_CONSTRUCT(VIA, 0x0428)
#define HDA_CODEC_VT1718S_1			HDA_CODEC_CONSTRUCT(VIA, 0x4428)
#define HDA_CODEC_VT1802_0			HDA_CODEC_CONSTRUCT(VIA, 0x0446)
#define HDA_CODEC_VT1802_1			HDA_CODEC_CONSTRUCT(VIA, 0x8446)
#define HDA_CODEC_VT1812			HDA_CODEC_CONSTRUCT(VIA, 0x0448)
#define HDA_CODEC_VT1818S			HDA_CODEC_CONSTRUCT(VIA, 0x0440)
#define HDA_CODEC_VT1828S			HDA_CODEC_CONSTRUCT(VIA, 0x4441)
#define HDA_CODEC_VT2002P_0			HDA_CODEC_CONSTRUCT(VIA, 0x0438)
#define HDA_CODEC_VT2002P_1			HDA_CODEC_CONSTRUCT(VIA, 0x4438)
#define HDA_CODEC_VT2020			HDA_CODEC_CONSTRUCT(VIA, 0x0441)
#define HDA_CODEC_VTXXXX			HDA_CODEC_CONSTRUCT(VIA, 0xffff)

/* ATI */
#define ATI_VENDORID				0x1002
#define HDA_CODEC_ATIRS600_1		HDA_CODEC_CONSTRUCT(ATI, 0x793c)
#define HDA_CODEC_ATIRS600_2		HDA_CODEC_CONSTRUCT(ATI, 0x7919)
#define HDA_CODEC_ATIRS690			HDA_CODEC_CONSTRUCT(ATI, 0x791a)
#define HDA_CODEC_ATIR6XX			HDA_CODEC_CONSTRUCT(ATI, 0xaa01)
#define HDA_CODEC_ATIXXXX			HDA_CODEC_CONSTRUCT(ATI, 0xffff)

/* NVIDIA */
#define NVIDIA_VENDORID				0x10de
#define HDA_CODEC_NVIDIAMCP78		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0002)
#define HDA_CODEC_NVIDIAMCP78_2		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0003)
#define HDA_CODEC_NVIDIAMCP78_3		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0005)
#define HDA_CODEC_NVIDIAMCP78_4		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0006)
#define HDA_CODEC_NVIDIAMCP7A		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0007)
#define HDA_CODEC_NVIDIAGT220		HDA_CODEC_CONSTRUCT(NVIDIA, 0x000a)
#define HDA_CODEC_NVIDIAGT21X		HDA_CODEC_CONSTRUCT(NVIDIA, 0x000b)
#define HDA_CODEC_NVIDIAMCP89		HDA_CODEC_CONSTRUCT(NVIDIA, 0x000c)
#define HDA_CODEC_NVIDIAGT240		HDA_CODEC_CONSTRUCT(NVIDIA, 0x000d)
#define HDA_CODEC_NVIDIAGTX470		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0010)
#define HDA_CODEC_NVIDIAGTS450		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0011)
#define HDA_CODEC_NVIDIAGT440		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0014)
#define HDA_CODEC_NVIDIAGTX550		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0015)
#define HDA_CODEC_NVIDIAGTX570		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0018)
#define HDA_CODEC_NVIDIAGT610       HDA_CODEC_CONSTRUCT(NVIDIA, 0x001c)
#define HDA_CODEC_NVIDIATEGRA30     HDA_CODEC_CONSTRUCT(NVIDIA, 0x0020)
#define HDA_CODEC_NVIDIATEGRA114    HDA_CODEC_CONSTRUCT(NVIDIA, 0x0022)
#define HDA_CODEC_NVIDIATEGRA124    HDA_CODEC_CONSTRUCT(NVIDIA, 0x0028)
#define HDA_CODEC_NVIDIATEGRA210    HDA_CODEC_CONSTRUCT(NVIDIA, 0x0029)
#define HDA_CODEC_NVIDIAGTX680		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0040)
#define HDA_CODEC_NVIDIAMCP67		HDA_CODEC_CONSTRUCT(NVIDIA, 0x0067)
#define HDA_CODEC_NVIDIAMCP73		HDA_CODEC_CONSTRUCT(NVIDIA, 0x8001)
#define HDA_CODEC_NVIDIAXXXX		HDA_CODEC_CONSTRUCT(NVIDIA, 0xffff)

/* Chrontel */
#define CHRONTEL_VENDORID			0x17e8
#define HDA_CODEC_CHXXXX			HDA_CODEC_CONSTRUCT(CHRONTEL, 0xffff)

/* INTEL */
#define INTEL_VENDORID				0x8086
#define HDA_CODEC_INTELIP           HDA_CODEC_CONSTRUCT(INTEL, 0x0054)
#define HDA_CODEC_INTELWB           HDA_CODEC_CONSTRUCT(INTEL, 0x0a0c)
#define HDA_CODEC_INTELBL           HDA_CODEC_CONSTRUCT(INTEL, 0x2801)
#define HDA_CODEC_INTELCA           HDA_CODEC_CONSTRUCT(INTEL, 0x2802)
#define HDA_CODEC_INTELEL           HDA_CODEC_CONSTRUCT(INTEL, 0x2803)
#define HDA_CODEC_INTELIP2          HDA_CODEC_CONSTRUCT(INTEL, 0x2804)
#define HDA_CODEC_INTELCPT          HDA_CODEC_CONSTRUCT(INTEL, 0x2805)
#define HDA_CODEC_INTELPPT          HDA_CODEC_CONSTRUCT(INTEL, 0x2806)
#define HDA_CODEC_INTELHSW          HDA_CODEC_CONSTRUCT(INTEL, 0x2807)
#define HDA_CODEC_INTELBDW          HDA_CODEC_CONSTRUCT(INTEL, 0x2808)
#define HDA_CODEC_INTELSKL          HDA_CODEC_CONSTRUCT(INTEL, 0x2809)
#define HDA_CODEC_INTELBXT          HDA_CODEC_CONSTRUCT(INTEL, 0x280a)
#define HDA_CODEC_INTELKBL          HDA_CODEC_CONSTRUCT(INTEL, 0x280b)
#define HDA_CODEC_INTELCFL          HDA_CODEC_CONSTRUCT(INTEL, 0x280d)
#define HDA_CODEC_INTELCL           HDA_CODEC_CONSTRUCT(INTEL, 0x29fb)
#define HDA_CODEC_INTELXXXX         HDA_CODEC_CONSTRUCT(INTEL, 0xffff)

//
// NOTE: I don't have all the revisions, I included only the ones that I know.
//       Codec Name can be different based on revisions, but I have included only
//       the codec names that I know.
// See: http://web.mit.edu/freebsd/head/sys/dev/sound/pci/hda/hdacc.c
// See: https://sourceforge.net/p/voodoohda/code/HEAD/tree/branches/zdev/Tables.c (2017-04-08 21:02:12)
//
static const struct {UInt32 id; UInt16 rev; char *name;} gCodecList[] = {
	// Codec Constant           Revision Codec Name
    { HDA_CODEC_CS4206,         0x0000, "Cirrus Logic CS4206" },
	{ HDA_CODEC_CS4207,			0x0000,	"Cirrus Logic CS4207" },
	{ HDA_CODEC_CS4210,			0x0000,	"Cirrus Logic CS4210" }, // rev 0x100101
    { HDA_CODEC_CS4213,         0x0000, "Cirrus Logic CS4213" }, // rev 0x100100
	{ HDA_CODEC_ALC221,			0x0000,	"Realtek ALC221" }, // rev 0x100003, 0x100103
    { HDA_CODEC_ALC225,         0x0000, "Realtek ALC225" },
    { HDA_CODEC_ALC230,         0x0000, "Realtek ALC230" }, // rev 0x100002
    { HDA_CODEC_ALC233,         0x0000, "Realtek ALC233" }, // rev 0x100003
    { HDA_CODEC_ALC235,         0x0000, "Realtek ALC235" }, // rev 0x100003
    { HDA_CODEC_ALC236,         0x0000, "Realtek ALC236" }, // rev 0x100001, 0x100002
	{ HDA_CODEC_ALC255,			0x0000,	"Realtek ALC255" }, // rev 0x100002
    { HDA_CODEC_ALC256,         0x0000, "Realtek ALC256 (ALC3246)" }, // rev 0x100002
    { HDA_CODEC_ALC257,         0x0000, "Realtek ALC257" }, // rev 0x100001
    { HDA_CODEC_ALC260,         0x0000, "Realtek ALC260" },
	{ HDA_CODEC_ALC262,			0x0000,	"Realtek ALC262" }, // rev 0x100100, 0x100202
	{ HDA_CODEC_ALC267,			0x0000,	"Realtek ALC267" },
	{ HDA_CODEC_ALC268,			0x0000,	"Realtek ALC268" }, // rev 0x10003, 0x100101
	{ HDA_CODEC_ALC269,			0x0000,	"Realtek ALC269" }, // rev 0x100203, 0x100004, 0x100202, 0x100100
    { HDA_CODEC_ALC269,         0x0004, "Realtek ALC269" },
    { HDA_CODEC_ALC269,         0x0100, "Realtek ALC269VB" },
    { HDA_CODEC_ALC269,         0x0202, "Realtek ALC269VC" },
    { HDA_CODEC_ALC269,         0x0203, "Realtek ALC269VC" },
	{ HDA_CODEC_ALC270,			0x0000,	"Realtek ALC270" }, // rev 0x100100
	{ HDA_CODEC_ALC272,			0x0000,	"Realtek ALC272" }, // rev 0x100001
	{ HDA_CODEC_ALC273,			0x0000,	"Realtek ALC273" },
	{ HDA_CODEC_ALC275,			0x0000,	"Realtek ALC275" }, // rev 0x100005, 0x100008
	{ HDA_CODEC_ALC276,			0x0000,	"Realtek ALC276" },
    { HDA_CODEC_ALC280,         0x0000, "Realtek ALC280" },
    { HDA_CODEC_ALC282,         0x0000, "Realtek ALC282" },
    { HDA_CODEC_ALC283,         0x0000, "Realtek ALC283" },
    { HDA_CODEC_ALC284,         0x0000, "Realtek ALC284" },
    { HDA_CODEC_ALC285,         0x0000, "Realtek ALC285" },
    { HDA_CODEC_ALC286,         0x0000, "Realtek ALC286" }, // rev 0x100002, 0x100003
	{ HDA_CODEC_ALC288,         0x0000, "Realtek ALC288" },
    { HDA_CODEC_ALC290,         0x0000, "Realtek ALC290" },
    { HDA_CODEC_ALC292,         0x0000, "Realtek ALC292" },
    { HDA_CODEC_ALC293,         0x0000, "Realtek ALC293" },
    { HDA_CODEC_ALC294,         0x0000, "Realtek ALC294" },
    { HDA_CODEC_ALC295,         0x0000, "Realtek ALC295" },
    { HDA_CODEC_ALC298,         0x0000, "Realtek ALC298" }, // rev 0x100101, 0x100103
    { HDA_CODEC_ALC299,         0x0000, "Realtek ALC299" }, // rev 0x100002
    { HDA_CODEC_ALC660,			0x0000,	"Realtek ALC660" },
	{ HDA_CODEC_ALC662,			0x0000,	"Realtek ALC662" }, // rev 0x100101, 0x100300
    { HDA_CODEC_ALC662,         0x0002, "Realtek ALC662v2" },
	{ HDA_CODEC_ALC663,			0x0000,	"Realtek ALC663" }, // rev 0x100001, 0x100002
	{ HDA_CODEC_ALC665,			0x0000,	"Realtek ALC665" },
    { HDA_CODEC_ALC668,         0x0000, "Realtek ALC668" }, // rev 0x100003
	{ HDA_CODEC_ALC670,			0x0000,	"Realtek ALC670" }, // rev 0x100002
    { HDA_CODEC_ALC671,         0x0000, "Realtek ALC671" },
	{ HDA_CODEC_ALC680,			0x0000,	"Realtek ALC680" },
	{ HDA_CODEC_ALC861,			0x0000,	"Realtek ALC861" },
	{ HDA_CODEC_ALC861VD,		0x0000,	"Realtek ALC861-VD" },
	{ HDA_CODEC_ALC880,			0x0000,	"Realtek ALC880" },
	{ HDA_CODEC_ALC882,			0x0000,	"Realtek ALC882" },
	{ HDA_CODEC_ALC883,			0x0000,	"Realtek ALC883" }, // rev 0x100002
    { HDA_CODEC_ALC885,         0x0000, "Realtek ALC885" }, // rev 0x100101, 0x100103
    { HDA_CODEC_ALC885,         0x0004, "Realtek ALC889A/ALC885" },
	{ HDA_CODEC_ALC885,			0x0103,	"Realtek ALC889A" },
	{ HDA_CODEC_ALC885,			0x0101,	"Realtek ALC889A" },
    { HDA_CODEC_ALC887,         0x0000, "Realtek ALC887" }, // rev 0x100202, 0x100302
	{ HDA_CODEC_ALC887,			0x0302,	"Realtek ALC888B" },
	{ HDA_CODEC_ALC887,			0x0002,	"Realtek ALC887-VD2" },
	{ HDA_CODEC_ALC887,			0x0001,	"Realtek ALC887-VD" },
    { HDA_CODEC_ALC888,         0x0000, "Realtek ALC888" }, // rev 0x100001, 0x100101, 0x100202, 0x100302
	{ HDA_CODEC_ALC888,			0x0003,	"Realtek ALC888S-VD" },
	{ HDA_CODEC_ALC888,			0x0002,	"Realtek ALC888S-VC" },
	{ HDA_CODEC_ALC888,			0x0001,	"Realtek ALC888S" },
	{ HDA_CODEC_ALC889,			0x0000,	"Realtek ALC889" }, // rev 0x100004
	{ HDA_CODEC_ALC891,			0x0000,	"Realtek ALC891" }, // rev 0x100002
    { HDA_CODEC_ALC892,         0x0000, "Realtek ALC892" }, // rev 0x100302
	{ HDA_CODEC_ALC898,			0x0000,	"Realtek ALC898" }, // rev 0x100003
    { HDA_CODEC_ALC899,         0x0000, "Realtek ALC899" },
	{ HDA_CODEC_ALC1150,		0x0000,	"Realtek ALC1150" }, // rev 0x100001
    { HDA_CODEC_ALC1220,        0x0000, "Realtek ALC1220" }, // rev 0x100101, 0x100003
    { HDA_CODEC_ALCS1200A,      0x0000, "Realtek ALCS1200A" }, // rev 0x100001
    { HDA_CODEC_ALCS1220A,      0x0000, "Realtek ALCS1220A" },
	{ HDA_CODEC_AD1882,			0x0000,	"Analog Devices AD1882" },
	{ HDA_CODEC_AD1882A,		0x0000,	"Analog Devices AD1882A" },
	{ HDA_CODEC_AD1883,			0x0000,	"Analog Devices AD1883" },
	{ HDA_CODEC_AD1884,			0x0000,	"Analog Devices AD1884" },
	{ HDA_CODEC_AD1884A,		0x0000,	"Analog Devices AD1884A" },
	{ HDA_CODEC_AD1981HD,		0x0000,	"Analog Devices AD1981HD" },
	{ HDA_CODEC_AD1983,			0x0000,	"Analog Devices AD1983" },
	{ HDA_CODEC_AD1984,			0x0000,	"Analog Devices AD1984" }, // rev 0x100400
	{ HDA_CODEC_AD1984A,		0x0000,	"Analog Devices AD1984A" }, // rev 0x100400
	{ HDA_CODEC_AD1984B,		0x0000,	"Analog Devices AD1984B" },
	{ HDA_CODEC_AD1986A,		0x0000,	"Analog Devices AD1986A" },
	{ HDA_CODEC_AD1987,			0x0000,	"Analog Devices AD1987" },
	{ HDA_CODEC_AD1988,			0x0000,	"Analog Devices AD1988A" },
	{ HDA_CODEC_AD1988B,		0x0000,	"Analog Devices AD1988B" },
	{ HDA_CODEC_AD1989A,		0x0000,	"Analog Devices AD1989A" },
	{ HDA_CODEC_AD1989B,		0x0000,	"Analog Devices AD2000b" },
	{ HDA_CODEC_CA0110,			0x0000,	"Creative CA0110-IBG" },
	{ HDA_CODEC_CA0110_2,		0x0000,	"Creative CA0110-IBG" },
	{ HDA_CODEC_CA0132,			0x0000,	"Creative CA0132" }, // rev 0x100918
	{ HDA_CODEC_SB0880,			0x0000,	"Creative SB0880 X-Fi" },
	{ HDA_CODEC_CMI9880,		0x0000,	"CMedia CMI9880" },
	{ HDA_CODEC_CMI98802,		0x0000,	"CMedia CMI9880" },
	{ HDA_CODEC_CXD9872RDK,		0x0000,	"Sigmatel CXD9872RD/K" },
	{ HDA_CODEC_CXD9872AKD,		0x0000,	"Sigmatel CXD9872AKD" },
	{ HDA_CODEC_STAC9200,		0x0000,	"Sigmatel STAC9200" }, // rev 0x102201
    { HDA_CODEC_STAC9200D,      0x0000, "Sigmatel STAC9200D" },
	{ HDA_CODEC_STAC9204X,		0x0000,	"Sigmatel STAC9204X" },
	{ HDA_CODEC_STAC9204D,		0x0000,	"Sigmatel STAC9204D" },
	{ HDA_CODEC_STAC9205X,		0x0000,	"Sigmatel STAC9205X" },
	{ HDA_CODEC_STAC9205D,		0x0000,	"Sigmatel STAC9205D" },
	{ HDA_CODEC_STAC9220,		0x0000,	"Sigmatel STAC9220" },
	{ HDA_CODEC_STAC9220_A1,	0x0000,	"Sigmatel STAC9220_A1" },
	{ HDA_CODEC_STAC9220_A2,	0x0000,	"Sigmatel STAC9220_A2" },
	{ HDA_CODEC_STAC9221,		0x0000,	"Sigmatel STAC9221" },
	{ HDA_CODEC_STAC9221_A2,	0x0000,	"Sigmatel STAC9221_A2" },
	{ HDA_CODEC_STAC9221D,		0x0000,	"Sigmatel STAC9221D" },
	{ HDA_CODEC_STAC922XD,		0x0000,	"Sigmatel STAC9220D/9223D" },
	{ HDA_CODEC_STAC9227X,		0x0000,	"Sigmatel STAC9227X" },
	{ HDA_CODEC_STAC9227D,		0x0000,	"Sigmatel STAC9227D" },
	{ HDA_CODEC_STAC9228X,		0x0000,	"Sigmatel STAC9228X" },
	{ HDA_CODEC_STAC9228D,		0x0000,	"Sigmatel STAC9228D" },
	{ HDA_CODEC_STAC9229X,		0x0000,	"Sigmatel STAC9229X" },
	{ HDA_CODEC_STAC9229D,		0x0000,	"Sigmatel STAC9229D" },
	{ HDA_CODEC_STAC9230X,		0x0000,	"Sigmatel STAC9230X" },
	{ HDA_CODEC_STAC9230D,		0x0000,	"Sigmatel STAC9230D" },
	{ HDA_CODEC_STAC9250,		0x0000,	"Sigmatel STAC9250" },
	{ HDA_CODEC_STAC9251,		0x0000,	"Sigmatel STAC9251" },
	{ HDA_CODEC_STAC9255,		0x0000,	"Sigmatel STAC9255" },
	{ HDA_CODEC_STAC9255D,		0x0000,	"Sigmatel STAC9255D" },
	{ HDA_CODEC_STAC9254,		0x0000,	"Sigmatel STAC9254" },
	{ HDA_CODEC_STAC9254D,		0x0000,	"Sigmatel STAC9254D" },
	{ HDA_CODEC_STAC9271X,		0x0000,	"Sigmatel STAC9271X" },
	{ HDA_CODEC_STAC9271D,		0x0000,	"Sigmatel STAC9271D" },
	{ HDA_CODEC_STAC9272X,		0x0000,	"Sigmatel STAC9272X" },
	{ HDA_CODEC_STAC9272D,		0x0000,	"Sigmatel STAC9272D" },
	{ HDA_CODEC_STAC9273X,		0x0000,	"Sigmatel STAC9273X" },
	{ HDA_CODEC_STAC9273D,		0x0000,	"Sigmatel STAC9273D" },
	{ HDA_CODEC_STAC9274,		0x0000,	"Sigmatel STAC9274" },
	{ HDA_CODEC_STAC9274D,		0x0000,	"Sigmatel STAC9274D" },
	{ HDA_CODEC_STAC9274X5NH,	0x0000,	"Sigmatel STAC9274X5NH" },
	{ HDA_CODEC_STAC9274D5NH,	0x0000,	"Sigmatel STAC9274D5NH" },
	{ HDA_CODEC_STAC9872AK,		0x0000,	"Sigmatel STAC9872AK" },
	{ HDA_CODEC_IDT92HD005,		0x0000,	"IDT 92HD005" },
	{ HDA_CODEC_IDT92HD005D,	0x0000,	"IDT 92HD005D" },
	{ HDA_CODEC_IDT92HD206X,	0x0000,	"IDT 92HD206X" },
	{ HDA_CODEC_IDT92HD206D,	0x0000,	"IDT 92HD206D" },
	{ HDA_CODEC_IDT92HD66B1X5,	0x0000,	"IDT 92HD66B1X5" },
	{ HDA_CODEC_IDT92HD66B2X5,	0x0000,	"IDT 92HD66B2X5" },
	{ HDA_CODEC_IDT92HD66B3X5,	0x0000,	"IDT 92HD66B3X5" },
	{ HDA_CODEC_IDT92HD66C1X5,	0x0000,	"IDT 92HD66C1X5" },
	{ HDA_CODEC_IDT92HD66C2X5,	0x0000,	"IDT 92HD66C2X5" },
	{ HDA_CODEC_IDT92HD66C3X5,	0x0000,	"IDT 92HD66C3X5" },
	{ HDA_CODEC_IDT92HD66B1X3,	0x0000,	"IDT 92HD66B1X3" },
	{ HDA_CODEC_IDT92HD66B2X3,	0x0000,	"IDT 92HD66B2X3" },
	{ HDA_CODEC_IDT92HD66B3X3,	0x0000,	"IDT 92HD66B3X3" },
	{ HDA_CODEC_IDT92HD66C1X3,	0x0000,	"IDT 92HD66C1X3" },
	{ HDA_CODEC_IDT92HD66C2X3,	0x0000,	"IDT 92HD66C2X3" },
	{ HDA_CODEC_IDT92HD66C3_65,	0x0000,	"IDT 92HD66C3/65" },
	{ HDA_CODEC_IDT92HD700X,	0x0000,	"IDT 92HD700X" },
	{ HDA_CODEC_IDT92HD700D,	0x0000,	"IDT 92HD700D" },
	{ HDA_CODEC_IDT92HD71B5,	0x0000,	"IDT 92HD71B5" },
	{ HDA_CODEC_IDT92HD71B5_2,	0x0000,	"IDT 92HD71B5" },
	{ HDA_CODEC_IDT92HD71B6,	0x0000,	"IDT 92HD71B6" },
	{ HDA_CODEC_IDT92HD71B6_2,	0x0000,	"IDT 92HD71B6" },
	{ HDA_CODEC_IDT92HD71B7,	0x0000,	"IDT 92HD71B7" },
	{ HDA_CODEC_IDT92HD71B7_2,	0x0000,	"IDT 92HD71B7" },
	{ HDA_CODEC_IDT92HD71B8,	0x0000,	"IDT 92HD71B8" },
	{ HDA_CODEC_IDT92HD71B8_2,	0x0000,	"IDT 92HD71B8" },
	{ HDA_CODEC_IDT92HD73C1,	0x0000,	"IDT 92HD73C1" },
	{ HDA_CODEC_IDT92HD73D1,	0x0000,	"IDT 92HD73D1" },
	{ HDA_CODEC_IDT92HD73E1,	0x0000,	"IDT 92HD73E1" },
    { HDA_CODEC_IDTID7695,      0x0000, "IDT ID7695" },
	{ HDA_CODEC_IDT92HD75B3,	0x0000,	"IDT 92HD75B3" },
	{ HDA_CODEC_IDT92HD75BX,	0x0000,	"IDT 92HD75BX" },
	{ HDA_CODEC_IDT92HD81B1C,	0x0000,	"IDT 92HD81B1C" },
	{ HDA_CODEC_IDT92HD81B1X,	0x0000,	"IDT 92HD81B1X" },
	{ HDA_CODEC_IDT92HD83C1C,	0x0000,	"IDT 92HD83C1C" },
	{ HDA_CODEC_IDT92HD83C1X,	0x0000,	"IDT 92HD83C1X" },
	{ HDA_CODEC_IDT92HD87B1_3,	0x0000,	"IDT 92HD87B1/3" },
	{ HDA_CODEC_IDT92HD87B2_4,	0x0000,	"IDT 92HD87B2/4" },
	{ HDA_CODEC_IDT92HD89C3,	0x0000,	"IDT 92HD89C3" },
	{ HDA_CODEC_IDT92HD89C2,	0x0000,	"IDT 92HD89C2" },
	{ HDA_CODEC_IDT92HD89C1,	0x0000,	"IDT 92HD89C1" },
	{ HDA_CODEC_IDT92HD89B3,	0x0000,	"IDT 92HD89B3" },
	{ HDA_CODEC_IDT92HD89B2,	0x0000,	"IDT 92HD89B2" },
	{ HDA_CODEC_IDT92HD89B1,	0x0000,	"IDT 92HD89B1" },
	{ HDA_CODEC_IDT92HD89E3,	0x0000,	"IDT 92HD89E3" },
	{ HDA_CODEC_IDT92HD89E2,	0x0000,	"IDT 92HD89E2" },
	{ HDA_CODEC_IDT92HD89E1,	0x0000,	"IDT 92HD89E1" },
	{ HDA_CODEC_IDT92HD89D3,	0x0000,	"IDT 92HD89D3" },
	{ HDA_CODEC_IDT92HD89D2,	0x0000,	"IDT 92HD89D2" },
	{ HDA_CODEC_IDT92HD89D1,	0x0000,	"IDT 92HD89D1" },
	{ HDA_CODEC_IDT92HD89F3,	0x0000,	"IDT 92HD89F3" },
	{ HDA_CODEC_IDT92HD89F2,	0x0000,	"IDT 92HD89F2" },
	{ HDA_CODEC_IDT92HD89F1,	0x0000,	"IDT 92HD89F1" },
	{ HDA_CODEC_IDT92HD90BXX,	0x0000,	"IDT 92HD90BXX" },
	{ HDA_CODEC_IDT92HD91BXX,	0x0000,	"IDT 92HD91BXX" },
	{ HDA_CODEC_IDT92HD93BXX,	0x0000,	"IDT 92HD93BXX" },
	{ HDA_CODEC_IDT92HD98BXX,	0x0000,	"IDT 92HD98BXX" },
	{ HDA_CODEC_IDT92HD99BXX,	0x0000,	"IDT 92HD99BXX" },
	{ HDA_CODEC_CX8050,         0x0000, "Conexant CX8050" },
    { HDA_CODEC_CX8150,         0x0000, "Conexant CX8150" },
    { HDA_CODEC_CX8200,         0x0000, "Conexant CX8200" },
    { HDA_CODEC_CX8400,         0x0000, "Conexant CX8400" },
    { HDA_CODEC_CX20549,		0x0000,	"Conexant CX20549 (Venice)" },
	{ HDA_CODEC_CX20551,		0x0000,	"Conexant CX20551 (Waikiki)" },
	{ HDA_CODEC_CX20561,		0x0000,	"Conexant CX20561 (Hermosa)" }, // rev 0x100000
	{ HDA_CODEC_CX20582,		0x0000,	"Conexant CX20582 (Pebble)" },
	{ HDA_CODEC_CX20583,		0x0000,	"Conexant CX20583 (Pebble HSF)" },
	{ HDA_CODEC_CX20584,		0x0000,	"Conexant CX20584" },
	{ HDA_CODEC_CX20585,		0x0000,	"Conexant CX20585" },
	{ HDA_CODEC_CX20588,		0x0000,	"Conexant CX20588" },
	{ HDA_CODEC_CX20590,		0x0000,	"Conexant CX20590" }, // rev 0x100000, 0x100002, 0x100003
	{ HDA_CODEC_CX20631,		0x0000,	"Conexant CX20631" },
	{ HDA_CODEC_CX20632,		0x0000,	"Conexant CX20632" },
	{ HDA_CODEC_CX20641,		0x0000,	"Conexant CX20641" },
	{ HDA_CODEC_CX20642,		0x0000,	"Conexant CX20642" },
	{ HDA_CODEC_CX20651,		0x0000,	"Conexant CX20651" },
	{ HDA_CODEC_CX20652,		0x0000,	"Conexant CX20652" },
	{ HDA_CODEC_CX20664,		0x0000,	"Conexant CX20664" },
	{ HDA_CODEC_CX20665,		0x0000,	"Conexant CX20665" },
    { HDA_CODEC_CX20722,        0x0000, "Conexant CX20722" },
    { HDA_CODEC_CX20724,        0x0000, "Conexant CX20724" },
    { HDA_CODEC_CX20751_2,      0x0000, "Conexant CX20751/2" }, // rev 0x100100
    { HDA_CODEC_CX20753_4,      0x0000, "Conexant CX20753/4" },
	{ HDA_CODEC_CX20755,        0x0000, "Conexant CX20755" },
    { HDA_CODEC_CX20756,        0x0000, "Conexant CX20756" },
    { HDA_CODEC_CX20757,        0x0000, "Conexant CX20757" },
    { HDA_CODEC_VT1705,         0x0000, "VIA VT1705" }, // rev 0x100000
    { HDA_CODEC_VT1708_8,		0x0000,	"VIA VT1708_8" },
	{ HDA_CODEC_VT1708_9,		0x0000,	"VIA VT1708_9" },
	{ HDA_CODEC_VT1708_A,		0x0000,	"VIA VT1708_A" },
	{ HDA_CODEC_VT1708_B,		0x0000,	"VIA VT1708_B" },
	{ HDA_CODEC_VT1709_0,		0x0000,	"VIA VT1709_0" },
	{ HDA_CODEC_VT1709_1,		0x0000,	"VIA VT1709_1" },
	{ HDA_CODEC_VT1709_2,		0x0000,	"VIA VT1709_2" },
	{ HDA_CODEC_VT1709_3,		0x0000,	"VIA VT1709_3" },
	{ HDA_CODEC_VT1709_4,		0x0000,	"VIA VT1709_4" },
	{ HDA_CODEC_VT1709_5,		0x0000,	"VIA VT1709_5" },
	{ HDA_CODEC_VT1709_6,		0x0000,	"VIA VT1709_6" },
	{ HDA_CODEC_VT1709_7,		0x0000,	"VIA VT1709_7" },
	{ HDA_CODEC_VT1708B_0,		0x0000,	"VIA VT1708B_0" },
	{ HDA_CODEC_VT1708B_1,		0x0000,	"VIA VT1708B_1" },
	{ HDA_CODEC_VT1708B_2,		0x0000,	"VIA VT1708B_2" },
	{ HDA_CODEC_VT1708B_3,		0x0000,	"VIA VT1708B_3" },
	{ HDA_CODEC_VT1708B_4,		0x0000,	"VIA VT1708B_4" },
	{ HDA_CODEC_VT1708B_5,		0x0000,	"VIA VT1708B_5" },
	{ HDA_CODEC_VT1708B_6,		0x0000,	"VIA VT1708B_6" },
	{ HDA_CODEC_VT1708B_7,		0x0000,	"VIA VT1708B_7" },
	{ HDA_CODEC_VT1708S_0,		0x0000,	"VIA VT1708S_0" },
	{ HDA_CODEC_VT1708S_1,		0x0000,	"VIA VT1708S_1" },
	{ HDA_CODEC_VT1708S_2,		0x0000,	"VIA VT1708S_2" },
	{ HDA_CODEC_VT1708S_3,		0x0000,	"VIA VT1708S_3" },
	{ HDA_CODEC_VT1708S_4,		0x0000,	"VIA VT1708S_4" },
	{ HDA_CODEC_VT1708S_5,		0x0000,	"VIA VT1708S_5" },
	{ HDA_CODEC_VT1708S_6,		0x0000,	"VIA VT1708S_6" },
	{ HDA_CODEC_VT1708S_7,		0x0000,	"VIA VT1708S_7" },
	{ HDA_CODEC_VT1702_0,		0x0000,	"VIA VT1702_0" },
	{ HDA_CODEC_VT1702_1,		0x0000,	"VIA VT1702_1" },
	{ HDA_CODEC_VT1702_2,		0x0000,	"VIA VT1702_2" },
	{ HDA_CODEC_VT1702_3,		0x0000,	"VIA VT1702_3" },
	{ HDA_CODEC_VT1702_4,		0x0000,	"VIA VT1702_4" },
	{ HDA_CODEC_VT1702_5,		0x0000,	"VIA VT1702_5" },
	{ HDA_CODEC_VT1702_6,		0x0000,	"VIA VT1702_6" },
	{ HDA_CODEC_VT1702_7,		0x0000,	"VIA VT1702_7" },
	{ HDA_CODEC_VT1716S_0,		0x0000,	"VIA VT1716S_0" },
	{ HDA_CODEC_VT1716S_1,		0x0000,	"VIA VT1716S_1" },
	{ HDA_CODEC_VT1718S_0,		0x0000,	"VIA VT1718S_0" },
	{ HDA_CODEC_VT1718S_1,		0x0000,	"VIA VT1718S_1" },
	{ HDA_CODEC_VT1802_0,		0x0000,	"VIA VT1802_0" },
	{ HDA_CODEC_VT1802_1,		0x0000,	"VIA VT1802_1" }, // rev 0x100000
	{ HDA_CODEC_VT1812,			0x0000,	"VIA VT1812" },
	{ HDA_CODEC_VT1818S,		0x0000,	"VIA VT1818S" },
	{ HDA_CODEC_VT1828S,		0x0000,	"VIA VT1828S" },
	{ HDA_CODEC_VT2002P_0,		0x0000,	"VIA VT2002P_0" },
	{ HDA_CODEC_VT2002P_1,		0x0000,	"VIA VT2002P_1" },
	{ HDA_CODEC_VT2020,			0x0000,	"VIA VT2020" }, // rev 100100
    { HDA_CODEC_VT2020,         0x0100, "VIA VT2020/2021" },
	{ HDA_CODEC_ATIRS600_1,		0x0000,	"ATI RS600 HDMI" },
	{ HDA_CODEC_ATIRS600_2,		0x0000,	"ATI RS600 HDMI" },
	{ HDA_CODEC_ATIRS690,		0x0000,	"ATI RS690/780 HDMI" },
	{ HDA_CODEC_ATIR6XX,		0x0000,	"ATI R6xx HDMI" },
	{ HDA_CODEC_NVIDIAMCP67,	0x0000,	"NVidia MCP67 HDMI" },
	{ HDA_CODEC_NVIDIAMCP73,	0x0000,	"NVidia MCP73 HDMI" },
	{ HDA_CODEC_NVIDIAMCP78,	0x0000,	"NVidia MCP78 HDMI" },
	{ HDA_CODEC_NVIDIAMCP78_2,	0x0000,	"NVidia MCP78 HDMI" },
	{ HDA_CODEC_NVIDIAMCP78_3,	0x0000,	"NVidia MCP78 HDMI" },
	{ HDA_CODEC_NVIDIAMCP78_4,	0x0000,	"NVidia MCP78 HDMI" },
	{ HDA_CODEC_NVIDIAMCP7A,	0x0000,	"NVidia MCP7A HDMI" },
	{ HDA_CODEC_NVIDIAGT220,	0x0000,	"NVidia GT220 HDMI" },
	{ HDA_CODEC_NVIDIAGT21X,	0x0000,	"NVidia GT21x HDMI" },
	{ HDA_CODEC_NVIDIAMCP89,	0x0000,	"NVidia MCP89 HDMI" },
	{ HDA_CODEC_NVIDIAGT240,	0x0000,	"NVidia GT240 HDMI" },
	{ HDA_CODEC_NVIDIAGTX470,	0x0000,	"NVidia GTX470 HDMI" },
	{ HDA_CODEC_NVIDIAGTS450,	0x0000,	"NVidia GTS450 HDMI" },
	{ HDA_CODEC_NVIDIAGT440,	0x0000,	"NVidia GT440 HDMI" },
	{ HDA_CODEC_NVIDIAGTX550,	0x0000,	"NVidia GTX550 HDMI" },
	{ HDA_CODEC_NVIDIAGTX570,	0x0000,	"NVidia GTX570 HDMI" },
    { HDA_CODEC_NVIDIAGT610,    0x0000, "NVidia GT610 HDMI" },
    { HDA_CODEC_NVIDIATEGRA30,  0x0000, "NVidia Tegra30" },
    { HDA_CODEC_NVIDIATEGRA114, 0x0000, "NVidia Tegra114" },
    { HDA_CODEC_NVIDIATEGRA124, 0x0000, "NVidia Tegra124" },
    { HDA_CODEC_NVIDIATEGRA210, 0x0000, "NVidia Tegra210" },
	{ HDA_CODEC_NVIDIAGTX680,	0x0000,	"NVidia GTX680 HDMI" },
	{ HDA_CODEC_INTELIP,		0x0000,	"Intel HD (Ironlake) HDMI" },
	{ HDA_CODEC_INTELBL,		0x0000,	"Intel 3100/X3500 (Bearlake) HDMI" },
	{ HDA_CODEC_INTELCA,		0x0000,	"Intel 4500MHD (Cantiga) HDMI" },
	{ HDA_CODEC_INTELEL,		0x0000,	"Intel (X)4500(HD) (Eaglelake) HDMI" },
	{ HDA_CODEC_INTELIP2,		0x0000,	"Intel HD (Ironlake) HDMI" },
	{ HDA_CODEC_INTELCPT,		0x0000,	"Intel HD 3000 (Sandy Bridge) HDMI" },
	{ HDA_CODEC_INTELPPT,		0x0000,	"Intel HD 4000 (Ivy Bridge) HDMI" },
    { HDA_CODEC_INTELHSW,       0x0000, "Intel Haswell HDMI" },
    { HDA_CODEC_INTELBDW,       0x0000, "Intel Broadwell HDMI" },
    { HDA_CODEC_INTELSKL,       0x0000, "Intel Skylake HDMI" },
    { HDA_CODEC_INTELBXT,       0x0000, "Intel Broxton HDMI" },
    { HDA_CODEC_INTELKBL,       0x0000, "Intel Kabylake HDMI" },
    { HDA_CODEC_INTELCFL,       0x0000, "Intel Coffee Lake HDMI" },
	{ HDA_CODEC_INTELCL,		0x0000,	"Intel X3100 (Crestline) HDMI" },
    { HDA_CODEC_INTELWB,        0x0000, "Intel Wellsburg HDMI" },
	{ HDA_CODEC_SII1390,		0x0000,	"Silicon Image SiI1390 HDMI" },
	{ HDA_CODEC_SII1392,		0x0000,	"Silicon Image SiI1392 HDMI" },
	/* Unknown codec */
	{ HDA_CODEC_ADXXXX,			0x0000,	"Analog Devices (Unknown)" },
	{ HDA_CODEC_AGEREXXXX,		0x0000,	"Lucent/Agere Systems (Unknown)" },
	{ HDA_CODEC_ALCXXXX,		0x0000,	"Realtek (Unknown)" },
	{ HDA_CODEC_ATIXXXX,		0x0000,	"ATI (Unknown)" },
	{ HDA_CODEC_CAXXXX,			0x0000,	"Creative (Unknown)" },
	{ HDA_CODEC_CMIXXXX,		0x0000,	"CMedia (Unknown)" },
	{ HDA_CODEC_CMIXXXX2,		0x0000,	"CMedia (Unknown)" },
	{ HDA_CODEC_CSXXXX,			0x0000,	"Cirrus Logic (Unknown)" },
	{ HDA_CODEC_CXXXXX,			0x0000,	"Conexant (Unknown)" },
	{ HDA_CODEC_CHXXXX,			0x0000,	"Chrontel (Unknown)" },
	{ HDA_CODEC_IDTXXXX,		0x0000,	"IDT (Unknown)" },
	{ HDA_CODEC_INTELXXXX,		0x0000,	"Intel (Unknown)" },
	{ HDA_CODEC_MOTOXXXX,		0x0000,	"Motorola (Unknown)" },
	{ HDA_CODEC_NVIDIAXXXX,		0x0000,	"NVidia (Unknown)" },
	{ HDA_CODEC_SIIXXXX,		0x0000,	"Silicon Image (Unknown)" },
	{ HDA_CODEC_STACXXXX,		0x0000,	"Sigmatel (Unknown)" },
	{ HDA_CODEC_VTXXXX,			0x0000,	"VIA (Unknown)" },
	{ 0,						0x0000,	NULL }
};

#endif
