
---
title: "GPU Gardener Documentation"
linkTitle: "GPU Gardener Documentation"

---


### Contents ###

*   [What does a GPU Gardener do?](#what_is_a_gpu_gardener)
*   [Tracking GPU Gardener Work](#tracking)
*   [View current and upcoming rotations](#view_current_upcoming_rotations)
*   [How to swap rotation shifts](#how_to_swap)
*   [Tips for GPU Gardeners](#tips)


<a name="what_is_a_gpu_gardener"></a>
What does a GPU Gardener do?
----------------------------

The GPU Gardener has three main jobs:

1) Stay on top of incoming GPU-related bugs from clients in various bug trackers. This means triaging and assigning bugs that have a clear owner and investigating and possibly fixing bugs that don't.


2) Improve the reliability of the GPU bots. This includes dealing with flaky images, crashing bots, etc. We have a never ending set of machine or driver specific issues to deal with. We often brush them under the rug so that we have time for the "real work." When you're gardener this is "real work."


3) Improve our tooling. This includes writing new tools and improving existing test tools. Expected results are faster bot run times, more accurate testing, faster testing, surfacing new useful data, and improving debuggability.


The GPU Gardener should always prioritize dealing with incoming bugs. The balance of a gardener's time should be spent divided as seen fit between 2) and 3). It is expected that as much as possible a gardener puts normal work on pause and focuses on gardener tasks for the full week. It is ok (and encouraged) to take a deep dive on one particular facet of the gardener duties and drive it as far as possible during gardener week (while staying on top of incoming bugs).

Note that the GPU Gardener's job is NOT to spend an abnormal amount of time triaging images, filing bugs for failing bots, or shepherding DEPS rolls. You'll get your chance when you are the general Skia Gardener.

<a name="tracking"></a>
Tracking GPU Gardener Work
--------------------------
Outside of bug reports, a GPU Gardener should track their progress so that a future gardener can pick up any batons left shy of the finish line at week's end.

Also, whenever a gardener figures out how to accomplish a gardenly task (e.g. run a set of Chromium tests that aren't well documented or a cool OpenGL trick used to debug a gnarly issue) the tips section of this doc should be updated to assist future gardeners.


<a name="view_current_upcoming_rotations"></a>
View current and upcoming rotations
-----------------------------------

The list of GPU Gardeners is specified [here](https://rotations.corp.google.com/rotation/6176639586140160).
The gardeners widget on the [status page](https://status.skia.org) also displays the current gardeners.


<a name="how_to_swap"></a>
How to swap rotation shifts
---------------------------

If you need to swap shifts with someone (because you are out sick or on vacation), please get approval from the person you want to swap with and directly make the swap via the [rotations page](https://rotations.corp.google.com/rotation/6176639586140160).


<a name="tips"></a>
Tips for GPU Gardeners
----------------------

Please see [this](https://docs.google.com/a/google.com/document/d/1Q1A5T5js4MdqvD0EKjCgNbUBJfRBMPKR3OZAkc-2Tvc/edit?usp=sharing) doc.

