/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.ExportedTaskNode;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;

abstract class AbstractIncludedBuildController
implements IncludedBuildController,
Stoppable {
    private final CompositeBuildParticipantBuildState build;
    private final Set<ExportedTaskNode> scheduled = new LinkedHashSet<ExportedTaskNode>();
    private final Set<ExportedTaskNode> queuedForExecution = new LinkedHashSet<ExportedTaskNode>();
    private State state = State.DiscoveringTasks;

    public AbstractIncludedBuildController(CompositeBuildParticipantBuildState build) {
        this.build = build;
    }

    public ExportedTaskNode locateTask(TaskInternal task) {
        this.assertInState(State.DiscoveringTasks);
        return this.build.getWorkGraph().locateTask(task);
    }

    public ExportedTaskNode locateTask(String taskPath) {
        this.assertInState(State.DiscoveringTasks);
        return this.build.getWorkGraph().locateTask(taskPath);
    }

    public void queueForExecution(ExportedTaskNode taskNode) {
        this.assertInState(State.DiscoveringTasks);
        this.queuedForExecution.add(taskNode);
    }

    public boolean populateTaskGraph() {
        if (this.state == State.ReadyToRun) {
            return false;
        }
        this.assertInState(State.DiscoveringTasks);
        this.queuedForExecution.removeAll(this.scheduled);
        if (this.queuedForExecution.isEmpty()) {
            return false;
        }
        this.build.getWorkGraph().schedule(this.queuedForExecution);
        this.scheduled.addAll(this.queuedForExecution);
        this.queuedForExecution.clear();
        return true;
    }

    public void prepareForExecution() {
        if (this.state == State.ReadyToRun) {
            return;
        }
        this.assertInState(State.DiscoveringTasks);
        if (!this.queuedForExecution.isEmpty()) {
            throw new IllegalStateException("Queued tasks have not been scheduled.");
        }
        HashSet<TaskInternal> visited = new HashSet<TaskInternal>();
        HashSet<TaskInternal> visiting = new HashSet<TaskInternal>();
        for (ExportedTaskNode node : this.scheduled) {
            this.checkForCyclesFor(node.getTask(), visited, visiting);
        }
        this.build.getWorkGraph().prepareForExecution(false);
        this.state = State.ReadyToRun;
    }

    public void startTaskExecution(ExecutorService executorService) {
        this.assertInState(State.ReadyToRun);
        this.state = State.RunningTasks;
        if (!this.scheduled.isEmpty()) {
            this.doStartTaskExecution(executorService);
        }
    }

    public ExecutionResult<Void> awaitTaskCompletion() {
        ExecutionResult result;
        this.assertInState(State.RunningTasks);
        if (!this.scheduled.isEmpty()) {
            ArrayList failures = new ArrayList();
            this.doAwaitTaskCompletion(failures::add);
            result = ExecutionResult.maybeFailed(failures);
        } else {
            result = ExecutionResult.succeeded();
        }
        this.scheduled.clear();
        this.state = State.Finished;
        return result;
    }

    public void stop() {
        if (this.state == State.RunningTasks) {
            throw new IllegalStateException("Build is currently running tasks.");
        }
    }

    protected abstract void doStartTaskExecution(ExecutorService var1);

    protected abstract void doAwaitTaskCompletion(Consumer<? super Throwable> var1);

    private void assertInState(State expectedState) {
        if (this.state != expectedState) {
            throw new IllegalStateException("Build is in unexpected state: " + (Object)((Object)this.state));
        }
    }

    private void checkForCyclesFor(TaskInternal task, Set<TaskInternal> visited, Set<TaskInternal> visiting) {
        if (visited.contains(task)) {
            return;
        }
        if (!visiting.add(task)) {
            CachingDirectedGraphWalker graphWalker = new CachingDirectedGraphWalker((node, values, connectedNodes) -> this.visitDependenciesOf((TaskInternal)node, connectedNodes::add));
            graphWalker.add((Object[])new TaskInternal[]{task});
            List cycles = graphWalker.findCycles();
            Set cycle = (Set)cycles.get(0);
            DirectedGraphRenderer graphRenderer = new DirectedGraphRenderer((node, output) -> output.withStyle(StyledTextOutput.Style.Identifier).text((Object)node.getIdentityPath()), (node, values, connectedNodes) -> this.visitDependenciesOf((TaskInternal)node, dep -> {
                if (cycle.contains(dep)) {
                    connectedNodes.add(dep);
                }
            }));
            StringWriter writer = new StringWriter();
            graphRenderer.renderTo((Object)task, (Appendable)writer);
            throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer.toString()));
        }
        this.visitDependenciesOf(task, dep -> this.checkForCyclesFor((TaskInternal)dep, visited, visiting));
        visiting.remove(task);
        visited.add(task);
    }

    private void visitDependenciesOf(TaskInternal task, Consumer<TaskInternal> consumer) {
        TaskNodeFactory taskNodeFactory = (TaskNodeFactory)((GradleInternal)task.getProject().getGradle()).getServices().get(TaskNodeFactory.class);
        TaskNode node = taskNodeFactory.getOrCreateNode((Task)task);
        for (Node dependency : node.getAllSuccessors()) {
            if (!(dependency instanceof TaskNode)) continue;
            consumer.accept(((TaskNode)dependency).getTask());
        }
    }

    private static enum State {
        DiscoveringTasks,
        ReadyToRun,
        RunningTasks,
        Finished;

    }
}

