/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.session;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelper;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\t2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/session/FirJvmOverridesBackwardCompatibilityHelper;", "Lorg/jetbrains/kotlin/fir/analysis/FirOverridesBackwardCompatibilityHelper;", "()V", "javaOrigin", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "platformDependentAnnotation", "Lorg/jetbrains/kotlin/name/ClassId;", "isPlatformSpecificSymbolThatCanBeImplicitlyOverridden", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "visitedSymbols", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "overrideCanBeOmitted", "overriddenMemberSymbols", "", "entrypoint"})
public final class FirJvmOverridesBackwardCompatibilityHelper
implements FirOverridesBackwardCompatibilityHelper {
    @NotNull
    public static final FirJvmOverridesBackwardCompatibilityHelper INSTANCE = new FirJvmOverridesBackwardCompatibilityHelper();
    @NotNull
    private static final Set<FirDeclarationOrigin> javaOrigin;
    @NotNull
    private static final ClassId platformDependentAnnotation;

    private FirJvmOverridesBackwardCompatibilityHelper() {
    }

    @Override
    public boolean overrideCanBeOmitted(@NotNull List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, @NotNull CheckerContext context2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(overriddenMemberSymbols, (String)"overriddenMemberSymbols");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            boolean bl2 = false;
            HashSet visitedSymbols = new HashSet();
            Iterable $this$all$iv = overriddenMemberSymbols;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl3 = false;
                    if (INSTANCE.isPlatformSpecificSymbolThatCanBeImplicitlyOverridden(it, visitedSymbols, context2)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isPlatformSpecificSymbolThatCanBeImplicitlyOverridden(FirCallableSymbol<?> symbol2, Set<FirCallableSymbol<?>> visitedSymbols, CheckerContext context2) {
        boolean bl;
        block24: {
            List<FirCallableSymbol> list2;
            FqName fqName2;
            ClassId it2;
            Object element$iv;
            boolean bl2;
            FirCallableMemberDeclaration originalMember;
            Object result$iv;
            block23: {
                FirAnnotationContainer firAnnotationContainer;
                Modality modality$iv;
                FirCallableMemberDeclaration firCallableMemberDeclaration;
                Object e = symbol2.getFir();
                FirCallableMemberDeclaration firCallableMemberDeclaration2 = firCallableMemberDeclaration = e instanceof FirCallableMemberDeclaration ? (FirCallableMemberDeclaration)e : null;
                if (firCallableMemberDeclaration == null) {
                    return false;
                }
                FirCallableMemberDeclaration fir = firCallableMemberDeclaration;
                Object $this$isFinal$iv = fir;
                boolean $i$f$isFinal = false;
                Modality modality = $this$isFinal$iv.getStatus().getModality();
                if (modality == null ? true : (modality$iv = modality) == Modality.FINAL) {
                    return false;
                }
                if (visitedSymbols.contains(symbol2)) {
                    return true;
                }
                $this$isFinal$iv = visitedSymbols;
                $i$f$isFinal = false;
                $this$isFinal$iv.add(symbol2);
                FirCallableDeclaration $this$originalOrSelf$iv = fir;
                boolean $i$f$originalOrSelf = false;
                result$iv = $this$originalOrSelf$iv;
                while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv)) {
                    FirAnnotationContainer firAnnotationContainer2;
                    FirCallableDeclaration firCallableDeclaration;
                    FirCallableDeclaration $this$originalIfFakeOverride$iv$iv = result$iv;
                    boolean $i$f$originalIfFakeOverride = false;
                    FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                    boolean $i$f$getOriginalForSubstitutionOverride = false;
                    FirCallableDeclaration firCallableDeclaration2 = firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
                    if (firCallableDeclaration == null) {
                        FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                        boolean $i$f$getBaseForIntersectionOverride = false;
                        firAnnotationContainer2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
                    } else {
                        firAnnotationContainer2 = firAnnotationContainer = firCallableDeclaration;
                    }
                    if (firAnnotationContainer == null) break;
                    result$iv = firAnnotationContainer;
                }
                originalMember = (FirCallableMemberDeclaration)result$iv;
                Iterable $this$any$iv = originalMember.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    result$iv = $this$any$iv.iterator();
                    while (result$iv.hasNext()) {
                        ConeClassLikeType coneClassLikeType;
                        element$iv = result$iv.next();
                        FirAnnotationCall it2 = (FirAnnotationCall)element$iv;
                        boolean bl3 = false;
                        FirTypeRef $this$coneTypeSafe$iv = it2.getAnnotationTypeRef();
                        boolean $i$f$coneTypeSafe = false;
                        boolean bl4 = false;
                        firAnnotationContainer = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                        ConeKotlinType coneKotlinType = firAnnotationContainer == null ? null : ((FirResolvedTypeRef)firAnnotationContainer).getType();
                        if (!(coneKotlinType instanceof ConeClassLikeType)) {
                            coneKotlinType = null;
                        }
                        if (!Intrinsics.areEqual((Object)((coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null ? null : ConeTypeUtilsKt.getClassId(coneClassLikeType)), (Object)platformDependentAnnotation)) continue;
                        bl2 = true;
                        break block23;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            if (!javaOrigin.contains(originalMember.getOrigin())) {
                return false;
            }
            element$iv = ClassMembersKt.containingClass(originalMember);
            Object object = element$iv == null ? null : ((it2 = ((ConeClassLikeLookupTag)element$iv).getClassId()) == null ? null : (result$iv = (fqName2 = it2.asSingleFqName()) == null ? null : fqName2.toUnsafe()));
            if (result$iv == null) {
                return false;
            }
            Object $i$f$any = result$iv;
            Object containingClassName = $i$f$any;
            if (JavaToKotlinClassMap.INSTANCE.mapKotlinToJava((FqNameUnsafe)containingClassName) != null) {
                return true;
            }
            element$iv = ClassMembersKt.dispatchReceiverTypeOrNull(symbol2);
            Object object2 = element$iv == null ? null : (result$iv = (it2 = FirHelpersKt.toRegularClass((ConeKotlinType)element$iv, context2.getSession())) == null ? null : FirHelpersKt.unsubstitutedScope(it2, context2));
            if (result$iv == null) {
                return false;
            }
            Object scope2 = result$iv;
            element$iv = originalMember;
            if (element$iv instanceof FirSimpleFunction) {
                list2 = FirTypeScopeKt.getDirectOverriddenFunctions((FirTypeScope)scope2, ((FirSimpleFunction)originalMember).getSymbol());
            } else if (element$iv instanceof FirProperty) {
                list2 = FirTypeScopeKt.getDirectOverriddenProperties((FirTypeScope)scope2, ((FirProperty)originalMember).getSymbol());
            } else {
                return false;
            }
            List<FirNamedFunctionSymbol> overriddenSymbols2 = list2;
            if (overriddenSymbols2.isEmpty()) {
                return false;
            }
            Iterable $this$all$iv = overriddenSymbols2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    FirCallableSymbol it3 = (FirCallableSymbol)element$iv2;
                    boolean bl5 = false;
                    if (INSTANCE.isPlatformSpecificSymbolThatCanBeImplicitlyOverridden(it3, visitedSymbols, context2)) continue;
                    bl = false;
                    break block24;
                }
                bl = true;
            }
        }
        return bl;
    }

    static {
        Object object = new FirDeclarationOrigin[]{FirDeclarationOrigin.Java.INSTANCE, FirDeclarationOrigin.Enhancement.INSTANCE};
        javaOrigin = SetsKt.setOf((Object[])object);
        object = ClassId.fromString("kotlin/internal/PlatformDependent");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromString(\"kotlin/internal/PlatformDependent\")");
        platformDependentAnnotation = object;
    }
}

