/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.util;

public class Flags {
    public static boolean hasFlag(int subject, int flag) {
        return (subject & flag) == flag;
    }

    public static boolean isInterface(int access) {
        return Flags.hasFlag(access, 512);
    }

    public static boolean isConstructor(String name) {
        return name.equals("<init>");
    }

    public static boolean isStaticInitializer(String name, String desc, int access) {
        return name.equals("<clinit>") && desc.equals("()V") && Flags.hasFlag(access, 8);
    }

    public static boolean isConcreteMethod(int access) {
        return !Flags.isAbstractMethod(access);
    }

    public static boolean isAbstractMethod(int access) {
        return Flags.hasFlag(access, 1024);
    }

    public static boolean isInstanceMethod(int access) {
        return !Flags.isStaticMethod(access);
    }

    public static boolean isStaticMethod(int access) {
        return Flags.hasFlag(access, 8);
    }

    public static boolean isPublicMethod(int access) {
        return Flags.hasFlag(access, 1);
    }

    public static boolean isPrivateMethod(int access) {
        return Flags.hasFlag(access, 2);
    }
}

