/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.orfjackal.retrolambda.ClassAnalyzer;
import net.orfjackal.retrolambda.LowerBytecodeVersion;
import net.orfjackal.retrolambda.asm.ClassReader;
import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.ClassWriter;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.asm.tree.ClassNode;
import net.orfjackal.retrolambda.interfaces.AddMethodDefaultImplementations;
import net.orfjackal.retrolambda.interfaces.ExtractInterfaceCompanionClass;
import net.orfjackal.retrolambda.interfaces.FixInvokeStaticOnInterfaceMethod;
import net.orfjackal.retrolambda.interfaces.RemoveBridgeMethods;
import net.orfjackal.retrolambda.interfaces.RemoveDefaultMethodBodies;
import net.orfjackal.retrolambda.interfaces.RemoveStaticMethods;
import net.orfjackal.retrolambda.interfaces.UpdateRelocatedMethodInvocations;
import net.orfjackal.retrolambda.interfaces.WarnAboutDefaultAndStaticMethods;
import net.orfjackal.retrolambda.lambdas.BackportLambdaClass;
import net.orfjackal.retrolambda.lambdas.BackportLambdaInvocations;
import net.orfjackal.retrolambda.lambdas.RemoveMethodHandlesLookupReferences;
import net.orfjackal.retrolambda.lambdas.UpdateRenamedEnclosingMethods;
import net.orfjackal.retrolambda.requirenonnull.RequireNonNull;
import net.orfjackal.retrolambda.trywithresources.SwallowSuppressedExceptions;

public class Transformers {
    private final int targetVersion;
    private final boolean defaultMethodsEnabled;
    private final ClassAnalyzer analyzer;

    public Transformers(int targetVersion, boolean defaultMethodsEnabled, ClassAnalyzer analyzer) {
        this.targetVersion = targetVersion;
        this.defaultMethodsEnabled = defaultMethodsEnabled;
        this.analyzer = analyzer;
    }

    public byte[] backportLambdaClass(ClassReader reader) {
        return this.transform(reader, (ClassVisitor next) -> {
            if (this.defaultMethodsEnabled) {
                this.analyzer.analyze(reader);
                next = new UpdateRelocatedMethodInvocations(next, this.analyzer);
                next = new AddMethodDefaultImplementations(next, this.analyzer);
            } else {
                next = new UpdateRelocatedMethodInvocations(next, this.analyzer);
            }
            next = new BackportLambdaClass(next);
            return next;
        });
    }

    public byte[] backportClass(ClassReader reader) {
        return this.transform(reader, (ClassVisitor next) -> {
            if (this.defaultMethodsEnabled) {
                next = new UpdateRelocatedMethodInvocations(next, this.analyzer);
                next = new AddMethodDefaultImplementations(next, this.analyzer);
            }
            next = new BackportLambdaInvocations(next, this.analyzer);
            return next;
        });
    }

    public List<byte[]> backportInterface(ClassReader reader) {
        ClassNode lambdasBackported;
        ClassVisitor next = lambdasBackported = new ClassNode();
        next = new BackportLambdaInvocations(next, this.analyzer);
        reader.accept(next, 0);
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        results.add(this.backportInterface2(lambdasBackported));
        results.addAll(this.extractInterfaceCompanion(lambdasBackported));
        return results;
    }

    private byte[] backportInterface2(ClassNode clazz) {
        return this.transform(clazz, (ClassVisitor next) -> {
            if (this.defaultMethodsEnabled) {
                next = new RemoveStaticMethods(next);
                next = new RemoveDefaultMethodBodies(next);
                next = new UpdateRelocatedMethodInvocations(next, this.analyzer);
            } else {
                next = new RemoveStaticMethods(next);
                next = new WarnAboutDefaultAndStaticMethods(next);
            }
            next = new RemoveBridgeMethods(next);
            return next;
        });
    }

    private List<byte[]> extractInterfaceCompanion(ClassNode clazz) {
        Optional<Type> companion = this.analyzer.getCompanionClass(Type.getObjectType(clazz.name));
        if (!companion.isPresent()) {
            return Collections.emptyList();
        }
        return Arrays.asList(new byte[][]{this.transform(clazz, (ClassVisitor next) -> {
            next = new UpdateRelocatedMethodInvocations(next, this.analyzer);
            next = new ExtractInterfaceCompanionClass(next, (Type)companion.get());
            return next;
        })});
    }

    private byte[] transform(ClassNode node, ClassVisitorChain chain) {
        return this.transform(node.name, node::accept, chain);
    }

    private byte[] transform(ClassReader reader, ClassVisitorChain chain) {
        return this.transform(reader.getClassName(), cv -> reader.accept((ClassVisitor)cv, 0), chain);
    }

    private byte[] transform(String className, Consumer<ClassVisitor> reader, ClassVisitorChain chain) {
        try {
            ClassWriter writer;
            ClassVisitor next = writer = new ClassWriter(1);
            next = new LowerBytecodeVersion(next, this.targetVersion);
            if (this.targetVersion < 51) {
                next = new SwallowSuppressedExceptions(next);
                next = new RemoveMethodHandlesLookupReferences(next);
                next = new RequireNonNull(next);
            }
            next = new FixInvokeStaticOnInterfaceMethod(next);
            next = new UpdateRenamedEnclosingMethods(next, this.analyzer);
            next = chain.wrap(next);
            reader.accept(next);
            return writer.toByteArray();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to backport class: " + className, t);
        }
    }

    private static interface ClassVisitorChain {
        public ClassVisitor wrap(ClassVisitor var1);
    }
}

