/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.lambdas;

import java.io.IOException;
import net.orfjackal.retrolambda.Transformers;
import net.orfjackal.retrolambda.ext.ow2asm.EnhancedClassReader;
import net.orfjackal.retrolambda.files.OutputDirectory;
import net.orfjackal.retrolambda.lambdas.LambdaReifier;
import net.orfjackal.retrolambda.minlog.Log;

public class LambdaClassSaver {
    private final OutputDirectory saver;
    private final Transformers transformers;
    private final boolean isJavacHacksEnabled;

    public LambdaClassSaver(OutputDirectory saver, Transformers transformers, boolean isJavacHacksEnabled) {
        this.saver = saver;
        this.transformers = transformers;
        this.isJavacHacksEnabled = isJavacHacksEnabled;
    }

    public void saveIfLambda(String className, byte[] bytecode) {
        if (LambdaReifier.isLambdaClassToReify(className)) {
            this.reifyLambdaClass(className, bytecode);
        }
    }

    private void reifyLambdaClass(String className, byte[] bytecode) {
        Log.info("Saving lambda class: " + className);
        bytecode = this.transformers.backportLambdaClass(EnhancedClassReader.create(bytecode, this.isJavacHacksEnabled));
        try {
            this.saver.writeClass(bytecode, this.isJavacHacksEnabled);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

