/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.lambdas;

import net.orfjackal.retrolambda.asm.Handle;
import net.orfjackal.retrolambda.util.Flags;

public class Handles {
    public static int getOpcode(Handle handle) {
        int tag = handle.getTag();
        switch (tag) {
            case 5: {
                return 182;
            }
            case 6: {
                return 184;
            }
            case 7: {
                return 183;
            }
            case 8: {
                return 183;
            }
            case 9: {
                return 185;
            }
        }
        throw new IllegalArgumentException("Unsupported tag " + tag + " in " + handle);
    }

    public static int opcodeToTag(int opcode) {
        switch (opcode) {
            case 182: {
                return 5;
            }
            case 184: {
                return 6;
            }
            case 183: {
                return 7;
            }
            case 185: {
                return 9;
            }
        }
        throw new IllegalArgumentException("Unsupported opcode " + opcode);
    }

    public static int accessToTag(int access, boolean itf) {
        if (Flags.hasFlag(access, 8)) {
            return 6;
        }
        if (Flags.hasFlag(access, 2)) {
            return 7;
        }
        if (itf) {
            return 9;
        }
        return 5;
    }
}

