/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.files;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public abstract class ClasspathVisitor
extends SimpleFileVisitor<Path> {
    private Path baseDir;

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.baseDir == null) {
            this.baseDir = dir;
        }
        return super.preVisitDirectory(dir, attrs);
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path relativePath = this.baseDir.relativize(file);
        byte[] content = Files.readAllBytes(file);
        if (ClasspathVisitor.isJavaClass(relativePath)) {
            this.visitClass(content);
        } else {
            this.visitResource(relativePath, content);
        }
        return FileVisitResult.CONTINUE;
    }

    protected abstract void visitClass(byte[] var1) throws IOException;

    protected abstract void visitResource(Path var1, byte[] var2) throws IOException;

    private static boolean isJavaClass(Path file) {
        String fileName = file.getFileName().toString();
        return fileName.endsWith(".class") && !fileName.equals("module-info.class");
    }
}

