#include "alphasparse/kernel_plain.h"
#include "alphasparse/util.h"

void ONAME(const ALPHA_INT nz,
		   const ALPHA_Complex *x,
		   const ALPHA_INT *indx,
		   const ALPHA_Complex *y,
		   ALPHA_Complex *dotui)
{
	ALPHA_Complex res;
	alpha_setzero(res);
	if (nz <= 0)
	{
		fprintf(stderr, "Invalid Values : nz <= 0 !\n");
		return;
	}
	for (ALPHA_INT i = 0; i < nz; i++)
		cmp_madde(res, x[i], y[indx[i]]);

	(*dotui) = res;
	return;
}
