# Contributing

Hi!
We’re excited that you’re interested in contributing!
Take a moment to read the following guidelines.
And thanks for contributing to AlphaSparse

If you’re raising an issue, please understand that people involved with this
project often do so for fun, next to their day job; you are not entitled to
free customer service.

## Contributions

There’s several ways to contribute, not just by writing code.

### Improve documentation

As a user of this project you’re perfect for helping us improve our docs.
Typo corrections, error fixes, better explanations, new examples, etcetera.
Anything!

### Issues

We use GitHub issues to track public bugs.
Please ensure your description is clear and has sufficient instructions to be able to reproduce the issue.

### Give feedback on issues

We’re always looking for more opinions on discussions in the issue tracker.

### Write code

Code contributions are very welcome.
It’s often good to first create an issue to report a bug or suggest a new
feature before creating a pull request to prevent you from doing unnecessary
work.

## Submitting a pull request

* Non-trivial changes are often best discussed in an issue first, to prevent
  you from doing unnecessary work
* For ambitious tasks, you should try to get your work in front of the
  community for feedback as soon as possible
* New features should be accompanied with tests and documentation
* Don’t include unrelated changes
* Write a convincing description of why we should land your pull request:
  it’s your job to convince us

## License

By contributing to AlphaSparse, you agree that your contributions will be licensed under the LICENSE file in the root directory of this source tree.
