
# Contributing

We are more than happy to accept external contributions to the project in the form of feedback, bug reports and even better - pull requests

## Issues

Issues are used to track **bugs** and **feature requests**.

* Before reporting a bug or requesting a feature, run a few searches to
see if a similar issue has already been opened and ensure you’re not submitting
a duplicate.

### Bugs
* Describe steps to reproduce
* Full error message if any
* Your code if relevant
* OS targeted (iOS, OSX, tvOS, watchOS)

## Pull Request Guidelines
* Please check to make sure that there aren't existing pull requests attempting to address the issue mentioned. We also recommend checking for issues related to the issue on the tracker.
* Non-trivial changes should be discussed in an issue first (gitter, mail).
* Open a single PR for each subject.
* Prefer to develop in a topic branch, not master (feature-name).
* Write a convincing description of your PR and why we should land it.
* Update documentation comments where applicable.

### Only touch relevant files

* Make sure your PR stays focused on a single feature.
* Don't change project configs or any files unrelated to the subject you're working.
* Don't reformat code you don't modify.

### Fixing a bug?
* Mention it or create an issue if not exist
* Do not forgot to put [Fix # in your commit message to auto close](https://help.github.com/articles/closing-issues-via-commit-messages/)

### Keep your commit history short and clean.
* Keeping the history clean means making one commit per feature. (no fix of your fix)
* Squash your commits if necessary.

### Make sure tests pass (if exist)
* Add relevant tests to cover the change.
* Make sure test-suite passes.
