/*
 * Copyright (C) 1998-2016 ALPS Collaboration. See COPYRIGHT.TXT
 * All rights reserved. Use is subject to license terms. See LICENSE.TXT
 * For use in publications, see ACKNOWLEDGE.TXT
 */
#include "../src/maxent.hpp"
#include "gtest.h"
#include "../src/maxent_backcont.hpp"

inline vector_type getA(){
  vector_type A(500);
  //presaved output from avspec
  //DMFT U=0;beta=8
  A << 2.716325571e-16, 2.919950769e-12, 4.820405358e-09, 1.314374314e-06, 7.516248538e-05, 
      0.001224793405, 0.007759016621, 0.02508049554, 0.05124657184, 0.07743168328, 
      0.09653782066, 0.1069639236, 0.1106268638, 0.1102449434, 0.1079987192, 0.1052727895, 
      0.1028205961, 0.1009918226, 0.09990644278, 0.09956435962, 0.09990789787, 0.1008552287, 
      0.102317383, 0.1042065064, 0.106439639, 0.1089403034, 0.1116390621, 0.1144736133, 
      0.1173886835, 0.1203358247, 0.1232731561, 0.1261650582, 0.1289818251, 0.1316992731, 
      0.1342983146, 0.1367645031, 0.1390875602, 0.1412608973, 0.1432811408, 0.1451476721, 
      0.1468621913, 0.1484283091, 0.1498511734, 0.1511371318, 0.1522934327, 0.153327963, 
      0.1542490232, 0.1550651355, 0.155784885, 0.1564167886, 0.1569691902, 0.1574501788, 
      0.1578675261, 0.158228641, 0.1585405385, 0.158809821, 0.1590426683, 0.159244837, 
      0.1594216652, 0.1595780826, 0.1597186241, 0.1598474463, 0.1599683461, 0.1600847798, 
      0.1601998835, 0.1603164938, 0.1604371675, 0.1605642019, 0.1606996539, 0.1608453582, 
      0.1610029454, 0.161173858, 0.1613593664, 0.1615605837, 0.1617784791, 0.1620138904,
      0.1622675366, 0.1625400277, 0.1628318757, 0.163143503, 0.1634752514, 0.1638273896, 
      0.1642001204, 0.1645935867, 0.1650078781, 0.1654430356, 0.1658990568, 0.1663759003, 
      0.1668734894, 0.1673917161, 0.167930444, 0.1684895117, 0.169068735, 0.1696679096, 
      0.1702868132, 0.1709252073, 0.1715828395, 0.1722594442, 0.1729547448, 0.1736684547, 
      0.1744002782, 0.1751499119, 0.1759170454, 0.1767013623, 0.1775025407, 0.178320254, 
      0.1791541714, 0.1800039586, 0.1808692781, 0.1817497894, 0.1826451501, 0.1835550153, 
      0.1844790385, 0.1854168719, 0.1863681661, 0.1873325707, 0.1883097346, 0.1892993058, 
      0.1903009317, 0.1913142594, 0.1923389354, 0.1933746062, 0.194420918, 0.195477517, 
      0.1965440494, 0.1976201614, 0.1987054994, 0.19979971, 0.2009024399, 0.2020133364, 
      0.2031320467, 0.2042582188, 0.2053915008, 0.2065315414, 0.2076779899, 0.2088304959, 
      0.2099887098, 0.2111522825, 0.2123208656, 0.2134941113, 0.2146716726, 0.2158532033, 
      0.2170383579, 0.2182267919, 0.2194181616, 0.2206121242, 0.2218083379, 0.223006462,
      0.2242061566, 0.2254070833, 0.2266089045, 0.227811284, 0.2290138866, 0.2302163788, 
      0.231418428, 0.2326197032, 0.2338198749, 0.235018615, 0.2362155969, 0.2374104956, 
      0.2386029878, 0.2397927519, 0.240979468, 0.2421628179, 0.2433424854, 0.2445181563, 
      0.245689518, 0.2468562603, 0.2480180749, 0.2491746554, 0.2503256981, 0.2514709009,
      0.2526099646, 0.2537425917, 0.2548684877, 0.2559873601, 0.2570989191, 0.2582028773, 
      0.25929895, 0.2603868553, 0.2614663136, 0.2625370484, 0.2635987858, 0.264651255,
      0.2656941877, 0.2667273188, 0.2677503863, 0.268763131, 0.2697652969, 0.2707566311, 
      0.271736884, 0.2727058091, 0.2736631632, 0.2746087063, 0.275542202, 0.2764634171,
      0.277372122, 0.2782680903, 0.2791510995, 0.2800209303, 0.2808773672, 0.2817201983, 
      0.2825492153, 0.2833642137, 0.2841649927, 0.2849513552, 0.2857231081, 0.2864800619, 
      0.287222031, 0.287948834, 0.288660293, 0.2893562345, 0.2900364885, 0.2907008895, 0.2913492757,
      0.2919814896, 0.2925973775, 0.2931967902, 0.2937795824, 0.294345613, 0.2948947451, 
      0.295426846, 0.2959417873, 0.2964394448, 0.2969196985, 0.2973824328, 0.2978275363,
      0.2982549021, 0.2986644275, 0.2990560141, 0.2994295679, 0.2997849995, 0.3001222237, 
      0.3004411596, 0.300741731, 0.301023866, 0.301287497, 0.3015325611, 0.3017589996,
      0.3019667587, 0.3021557885, 0.3023260441, 0.3024774848, 0.3026100745, 0.3027237816, 
      0.3028185789, 0.3028944439, 0.3029513584, 0.302989309, 0.3030082865, 0.3030082865, 
      0.302989309, 0.3029513584, 0.3028944439, 0.3028185789, 0.3027237816, 0.3026100745, 
      0.3024774848, 0.3023260441, 0.3021557885, 0.3019667587, 0.3017589996, 0.3015325611, 
      0.301287497, 0.301023866, 0.300741731, 0.3004411596, 0.3001222237, 0.2997849995, 
      0.2994295679, 0.2990560141, 0.2986644275, 0.2982549021, 0.2978275363, 0.2973824328, 
      0.2969196985, 0.2964394448, 0.2959417873, 0.295426846, 0.2948947451, 0.294345613, 
      0.2937795824, 0.2931967902, 0.2925973775, 0.2919814896, 0.2913492757, 
      0.2907008895, 0.2900364885, 0.2893562345, 0.288660293, 0.287948834, 0.287222031,
      0.2864800619, 0.2857231081, 0.2849513552, 0.2841649927, 0.2833642137, 0.2825492153, 
      0.2817201983, 0.2808773672, 0.2800209303, 0.2791510995, 0.2782680903, 0.277372122, 
      0.2764634171, 0.275542202, 0.2746087063, 0.2736631632, 0.2727058091, 0.271736884, 
      0.2707566311, 0.2697652969, 0.268763131, 0.2677503863, 0.2667273188, 0.2656941877, 
      0.264651255, 0.2635987858, 0.2625370484, 0.2614663136, 0.2603868553, 0.25929895, 
      0.2582028773, 0.2570989191, 0.2559873601, 0.2548684877, 0.2537425917, 0.2526099645, 
      0.2514709009, 0.2503256981, 0.2491746554, 0.2480180749, 0.2468562603, 0.245689518, 
      0.2445181563, 0.2433424854, 0.2421628179, 0.240979468, 0.2397927519, 0.2386029878, 
      0.2374104956, 0.2362155969, 0.235018615, 0.2338198749, 0.2326197032, 0.231418428, 
      0.2302163788, 0.2290138866, 0.227811284, 0.2266089045, 0.2254070833, 0.2242061566,
      0.223006462, 0.2218083379, 0.2206121242, 0.2194181616, 0.2182267919, 0.2170383579, 
      0.2158532033, 0.2146716726, 0.2134941113, 0.2123208656, 0.2111522825, 0.2099887098, 
      0.2088304959, 0.2076779899, 0.2065315414, 0.2053915008, 0.2042582188, 0.2031320467, 
      0.2020133364, 0.2009024399, 0.19979971, 0.1987054994, 0.1976201614, 0.1965440494, 0.195477517, 
      0.194420918, 0.1933746062, 0.1923389354, 0.1913142594, 0.1903009317, 0.1892993058, 
      0.1883097346, 0.1873325707, 0.1863681661, 0.1854168719, 0.1844790385, 0.1835550153, 
      0.1826451501, 0.1817497894,.1808692781, 0.1800039586, 0.1791541714, 0.178320254, 
      0.1775025407, 0.1767013623, 0.1759170454, 0.1751499119, 0.1744002782, 0.1736684547, 
      0.1729547448, 0.1722594442, 0.1715828395, 0.1709252073, 0.1702868132, 0.1696679096, 
      0.169068735, 0.1684895117, 0.1679304441, 0.1673917161, 0.1668734894, 0.1663759003,
      0.1658990569, 0.1654430356, 0.1650078781, 0.1645935867, 0.1642001204, 0.1638273896,
      0.1634752514, 0.163143503, 0.1628318757, 0.1625400277, 0.1622675366, 0.1620138904, 
      0.1617784791, 0.1615605837, 0.1613593664, 0.161173858, 0.1610029454, 0.1608453582, 
      0.1606996539, 0.1605642019, 0.1604371675, 0.1603164938, 0.1601998835, 0.1600847798,
      0.1599683461, 0.1598474463, 0.1597186241, 0.1595780826, 0.1594216652, 0.159244837, 
      0.1590426683, 0.158809821, 0.1585405385, 0.158228641, 0.1578675261, 0.1574501788, 
      0.1569691902, 0.1564167886, 0.155784885, 0.1550651355, 0.1542490232, 0.153327963, 
      0.1522934327,0.1511371318, 0.1498511734, 0.1484283091, 0.1468621913, 0.1451476721,
      0.1432811408, 0.1412608973, 0.1390875602, 0.1367645031, 0.1342983146, 0.1316992731, 
      0.1289818251,0.1261650582, 0.1232731561, 0.1203358247, 0.1173886835, 0.1144736133,
      0.1116390621, 0.1089403034, 0.106439639, 0.1042065064, 0.102317383, 0.1008552287, 
      0.09990789787,0.09956435962, 0.09990644278, 0.1009918226, 0.1028205961, 0.1052727895,
      0.1079987192, 0.1102449434, 0.1106268638, 0.1069639236, 0.09653782066, 
      0.07743168328, 0.05124657184, 0.02508049554, 0.007759016621, 0.001224793405, 
      7.516248537e-05, 1.314374314e-06, 4.820405357e-09, 2.919950768e-12, 2.716325569e-16;
    return A;

}
inline vector_type getA_bose(){
  vector_type A(250);
  //presaved output from avspec
  //backcont shifted gaussian

  A << 4.335285466e-10,4.605742884e-05,0.01333271326,0.1569466641,0.367635381,0.3949550927,
    0.2966740666,0.1918856613,0.1181402895,0.0725286887,0.04529286218,0.02897848511,0.01902005515,
    0.01279126004,0.008795661996,0.006170206315,0.004406538113,0.003197911201,0.00235466448,0.001756770311,
    0.001326612228,0.001012999903,0.0007815621895,0.0006088435452,0.0004785998607,0.0003794291363,
    0.0003032289721,0.0002441759909,0.0001980405434,0.0001617202787,0.0001329187065,0.000109921124,
    9.143674132e-05,7.648634191e-05,6.432159759e-05,5.43666116e-05,4.617521565e-05,3.939953111e-05,
    3.376665086e-05,2.906122186e-05,2.511234702e-05,2.178367155e-05,1.8965833e-05,1.657067706e-05,
    1.452680086e-05,1.277609999e-05,1.127107917e-05,9.97274672e-06,8.848958131e-06,7.873106553e-06,
    7.023082867e-06,6.280446099e-06,5.629758784e-06,5.05805224e-06,4.554394636e-06,4.109540696e-06,
    3.715646553e-06,3.366036756e-06,3.055013233e-06,2.777698086e-06,2.529903809e-06,2.308025787e-06,
    2.108952968e-06,1.929993404e-06,1.768812008e-06,1.623378362e-06,1.491922836e-06,1.372899582e-06,
    1.264955262e-06,1.166902527e-06,1.077697493e-06,9.964205434e-07,9.222599416e-07,8.544978037e-07,
    7.924980633e-07,7.356961257e-07,6.835899518e-07,6.357323606e-07,5.917243685e-07,5.512094139e-07,
    5.138683414e-07,4.794150355e-07,4.47592613e-07,4.18170098e-07,3.909395108e-07,3.65713317e-07,
    3.423221864e-07,3.206130232e-07,3.004472288e-07,2.816991708e-07,2.642548283e-07,2.480105941e-07,
    2.328722119e-07,2.187538339e-07,2.055771822e-07,1.932708026e-07,1.817693999e-07,1.710132437e-07,
    1.60947638e-07,1.515224464e-07,1.42691667e-07,1.3441305e-07,1.266477559e-07,1.193600465e-07,1.125170079e-07,
    1.060883004e-07,1.000459327e-07,9.43640584e-08,8.901879158e-08,8.398804017e-08,7.925135481e-08,
    7.478979189e-08,7.058578913e-08,6.662305259e-08,6.288645385e-08,5.936193644e-08,5.603643058e-08,5.289777537e-08,
    4.993464783e-08,4.713649804e-08,4.449348982e-08,4.199644648e-08,3.963680109e-08,3.740655095e-08,3.529821576e-08,
    3.330479928e-08,3.141975406e-08,2.963694905e-08,2.795063974e-08,2.635544075e-08,2.48463005e-08,2.341847788e-08,
    2.206752074e-08,2.0789246e-08,1.95797213e-08,1.843524804e-08,1.735234561e-08,1.632773695e-08,1.535833498e-08,
    1.444123023e-08,1.357367916e-08,1.275309348e-08,1.197703019e-08,1.124318229e-08,1.054937016e-08,9.893533589e-09,
    9.273724313e-09,8.688099073e-09,8.134913168e-09,7.612514431e-09,7.119337622e-09,6.653899198e-09,6.214792429e-09,
    5.800682842e-09,5.410303967e-09,5.042453361e-09,4.695988894e-09,4.369825278e-09,4.062930819e-09,3.774324381e-09,
    3.503072541e-09,3.248286936e-09,3.00912177e-09,2.784771483e-09,2.574468574e-09,2.377481554e-09,2.193113036e-09,
    2.020697941e-09,1.859601823e-09,1.709219296e-09,1.568972567e-09,1.438310056e-09,1.316705107e-09,1.203654786e-09,
    1.098678753e-09,1.001318202e-09,9.111348821e-10,8.277101741e-10,7.506442287e-10,6.795551652e-10,6.140783212e-10,
    5.538655539e-10,4.985845874e-10,4.479184049e-10,4.015646813e-10,3.592352546e-10,3.206556317e-10,2.855645279e-10,
    2.537134352e-10,2.248662182e-10,1.987987346e-10,1.752984766e-10,1.541642325e-10,1.352057636e-10,1.182434955e-10,
    1.031082197e-10,8.964080394e-11,7.769190826e-11,6.712170371e-11,5.77995919e-11,4.960392266e-11,4.242170749e-11,
    3.614832694e-11,3.068722984e-11,2.594962313e-11,2.185415085e-11,1.832656174e-11,1.529936492e-11,1.271147416e-11,
    1.050784128e-11,8.639080164e-12,7.061083497e-12,5.734634647e-12,4.625018034e-12,3.701631589e-12,2.937605396e-12,
    2.309430855e-12,1.796604746e-12,1.38129249e-12,1.048014483e-12,7.833588341e-13,5.757229701e-13,4.150855633e-13,
    2.928090451e-13,2.014717115e-13,1.347271569e-13,8.71876023e-14,5.432670593e-14,3.239676199e-14,1.835489551e-14,
    9.793051329e-15,4.867328422e-15,2.223589549e-15,9.182626338e-16,3.356814674e-16,1.057805258e-16,2.777688408e-17,
    5.81961719e-18,9.205221383e-19,1.028597114e-19,7.688695354e-21,4.293447e-22,3.108648028e-23,2.954569301e-24,
    2.060850086e-25,8.390126133e-27,1.768853078e-28,1.728728019e-30,7.389898536e-33,1.654506858e-35;
  return A;
}

TEST(Backcont,FrequencyPHBackcont){
alps::params p;
  MaxEntSimulation::define_parameters(p);
  const int ndat = 16;
  const double beta = 8;
  p["BETA"]=beta;
  p["NDAT"]=ndat;
  p["PARTICLE_HOLE_SYMMETRY"]=true;
  p["DATASPACE"]="frequency";
  p["KERNEL"]="fermionic";
  p["TEXT_OUTPUT"]=false;
  p["BACKCONT"] = false;
  p["NFREQ"] = 500;

  //data from DMFT;U=0;beta=8
  p["X_0"]=-0.58900239090596;
  p["X_1"]=-0.40986302909581;
  p["X_2"]=-0.32440959736089;
  p["X_3"]=-0.26834511172698;
  p["X_4"]=-0.2278124578356;
  p["X_5"]=-0.19711608409901;
  p["X_6"]=-0.173170382827;
  p["X_7"]=-0.15406437082322;
  p["X_8"]=-0.13853122078645;
  p["X_9"]=-0.12569699334634;
  p["X_10"]=-0.1149417307568;
  p["X_11"]=-0.10581568778351;
  p["X_12"]=-0.097986218747872;
  p["X_13"]=-0.09120298645574;
  p["X_14"]=-0.085274608164208;
  p["X_15"]=-0.080052654686189;

  p["SIGMA_0"]=1e-6;
  p["SIGMA_1"]=1e-6;
  p["SIGMA_2"]=1e-6;
  p["SIGMA_3"]=1e-6;
  p["SIGMA_4"]=1e-6;
  p["SIGMA_5"]=1e-6;
  p["SIGMA_6"]=1e-6;
  p["SIGMA_7"]=1e-6;
  p["SIGMA_8"]=1e-6;
  p["SIGMA_9"]=1e-6;
  p["SIGMA_10"]=1e-6;
  p["SIGMA_11"]=1e-6;
  p["SIGMA_12"]=1e-6;
  p["SIGMA_13"]=1e-6;
  p["SIGMA_14"]=1e-6;
  p["SIGMA_15"]=1e-6;

  //setup params given above data
  MaxEntParameters param(p);
  MaxEntParameters * pp = &param;

  //backcontinue saved output
  vector_type A = getA();    
  Backcont bc(pp);
  vector_type G = bc.backcontinue(A);

  //sensibility check
  EXPECT_EQ(G.size(),ndat);

  //check that backcont is right to first order
  const double threshold = 0.1;
  for(int i=0;i<ndat;i++){
    double err = std::abs(G(i)-(pp->y(i)*pp->sigma(i)));
    EXPECT_EQ(err<threshold,true);
  } 

  //check high frequency term
  // G(iomega) ~ 1/iomega + ...

  double iwn = (2*(ndat-1)+1)*M_PI/beta;
  double limit = G(ndat-1)*iwn;
  EXPECT_EQ((limit+1)<0.1,true);
}

TEST(Backcont,FrequencyNotPHBackcont){
  alps::params p;
  MaxEntSimulation::define_parameters(p);
  const int ndat = 2*16;
  const double beta = 8;
  p["BETA"]=beta;
  p["NDAT"]=ndat;
  p["PARTICLE_HOLE_SYMMETRY"]=false;
  p["DATASPACE"]="frequency";
  p["KERNEL"]="fermionic";
  p["TEXT_OUTPUT"]=false;
  p["BACKCONT"] = false;
  p["NFREQ"] = 500;

  //data from DMFT;U=0;beta=8
  //really PH symmetric, so make Re(G)==0
  p["X_0"]=0;
  p["X_1"]=-0.58900239090596;
  p["X_2"]=0;
  p["X_3"]=-0.40986302909581;
  p["X_4"]=0;
  p["X_5"]=-0.32440959736089;
  p["X_6"]=0;
  p["X_7"]=-0.26834511172698;
  p["X_8"]=0;
  p["X_9"]=-0.2278124578356;
  p["X_10"]=0;
  p["X_11"]=-0.19711608409901;
  p["X_12"]=0;
  p["X_13"]=-0.173170382827;
  p["X_14"]=0;
  p["X_15"]=-0.15406437082322;
  p["X_16"]=0;
  p["X_17"]=-0.13853122078645;
  p["X_18"]=0;
  p["X_19"]=-0.12569699334634;
  p["X_20"]=0;
  p["X_21"]=-0.1149417307568;
  p["X_22"]=0;
  p["X_23"]=-0.10581568778351;
  p["X_24"]=0;
  p["X_25"]=-0.097986218747872;
  p["X_26"]=0;
  p["X_27"]=-0.09120298645574;
  p["X_28"]=0;
  p["X_29"]=-0.085274608164208;
  p["X_30"]=0;
  p["X_31"]=-0.080052654686189;

  p["SIGMA_0"]=1e-6;
  p["SIGMA_1"]=1e-6;
  p["SIGMA_2"]=1e-6;
  p["SIGMA_3"]=1e-6;
  p["SIGMA_4"]=1e-6;
  p["SIGMA_5"]=1e-6;
  p["SIGMA_6"]=1e-6;
  p["SIGMA_7"]=1e-6;
  p["SIGMA_8"]=1e-6;
  p["SIGMA_9"]=1e-6;
  p["SIGMA_10"]=1e-6;
  p["SIGMA_11"]=1e-6;
  p["SIGMA_12"]=1e-6;
  p["SIGMA_13"]=1e-6;
  p["SIGMA_14"]=1e-6;
  p["SIGMA_15"]=1e-6;
  p["SIGMA_16"]=1e-6;
  p["SIGMA_17"]=1e-6;
  p["SIGMA_18"]=1e-6;
  p["SIGMA_19"]=1e-6;
  p["SIGMA_20"]=1e-6;
  p["SIGMA_21"]=1e-6;
  p["SIGMA_22"]=1e-6;
  p["SIGMA_23"]=1e-6;
  p["SIGMA_24"]=1e-6;
  p["SIGMA_25"]=1e-6;
  p["SIGMA_26"]=1e-6;
  p["SIGMA_27"]=1e-6;
  p["SIGMA_28"]=1e-6;
  p["SIGMA_29"]=1e-6;
  p["SIGMA_30"]=1e-6;
  p["SIGMA_31"]=1e-6;

  //setup params given above data
  MaxEntParameters param(p);
  MaxEntParameters * pp = &param;

  //backcontinue saved output
  vector_type A = getA();    
  Backcont bc(pp);
  vector_type G = bc.backcontinue(A);

  //sensibility check
  EXPECT_EQ(G.size(),ndat);

  //check that backcont is right to first order
  const double threshold = 0.1;
  for(int i=0;i<ndat;i++){
    double err = std::abs(G(i)-(pp->y(i)*pp->sigma(i)));
    EXPECT_EQ(err<threshold,true);
  }
  
  // Re(G)==0
  const double threshold_re = 1e-10;
  for(int i=0;i<ndat;i+=2){
    EXPECT_NEAR(0,G(i),threshold_re);
  }

  //check high frequency term
  // G(iomega) ~ 1/iomega + ...
  
  //now ndat has 2*real_n
  double iwn = (2*((ndat-2)/2)+1)*M_PI/beta;
  double limit = G(ndat-1)*iwn;
  EXPECT_EQ((limit+1)<0.1,true);
}
TEST(Backcont,FrequencyBosonicBackcont){
  alps::params p;
  MaxEntSimulation::define_parameters(p);
  const int ndat = 10;
  const int nfreq = 250;
  p["BETA"]=2;
  p["NDAT"]=ndat;
  p["OMEGA_MAX"]=15.0;
  p["PARTICLE_HOLE_SYMMETRY"]=false;
  p["DATASPACE"]="frequency";
  p["KERNEL"]="bosonic";
  p["TEXT_OUTPUT"]=false;
  p["NFREQ"] = nfreq;

  //data from backcontinuation of Gaussian
  p["X_0"]=0.999999999999;
  p["X_1"]=0;
  p["X_2"]=0.70152821380558;
  p["X_3"]=0.4474203984475;
  p["X_4"]=0.38304188624212;
  p["X_5"]=0.47620096397886;
  p["X_6"]=0.22061301433115;
  p["X_7"]=0.40641589593297;
  p["X_8"]=0.13884046251264;
  p["X_9"]=0.33897622833775;

  p["SIGMA_0"]=1e-4;
  p["SIGMA_1"]=1e-4;
  p["SIGMA_2"]=1e-4;
  p["SIGMA_3"]=1e-4;
  p["SIGMA_4"]=1e-4;
  p["SIGMA_5"]=1e-4;
  p["SIGMA_6"]=1e-4;
  p["SIGMA_7"]=1e-4;
  p["SIGMA_8"]=1e-4;
  p["SIGMA_9"]=1e-4;
    
  //setup params given above data
  MaxEntParameters param(p);
  MaxEntParameters * pp = &param;

  //backcontinue saved output
  vector_type A = getA_bose();    
  Backcont bc(pp);
  vector_type G = bc.backcontinue(A);

  //sensibility check
  EXPECT_EQ(G.size(),ndat);

  //check that backcont is right to first order
  const double threshold = 0.1;
  for(int i=0;i<ndat;i++){
    double err = std::abs(G(i)-(pp->y(i)*pp->sigma(i)));
    EXPECT_EQ(err<threshold,true);
  }
  
  
}
TEST(Backcont,TauBackcont){
alps::params p;
  MaxEntSimulation::define_parameters(p);
  const int ndat = 26;
  p["BETA"]=8;
  p["NDAT"]=ndat;
  p["PARTICLE_HOLE_SYMMETRY"]=true;
  p["DATASPACE"]="time";
  p["KERNEL"]="fermionic";
  p["TEXT_OUTPUT"]=false;
  p["BACKCONT"] = false;
  p["NFREQ"] = 500;

  //data from DMFT;U=0;beta=8
  p["X_0"]=-0.5;
  p["X_1"]=-0.31968831176465;
  p["X_2"]=-0.22989567294666;
  p["X_3"]=-0.18028809394476;
  p["X_4"]=-0.15025032491734;
  p["X_5"]=-0.13069255038955;
  p["X_6"]=-0.11727844091991;
  p["X_7"]=-0.10777271410719;
  p["X_8"]=-0.10094024798648;
  p["X_9"]=-0.096059700592185;
  p["X_10"]=-0.09269474697556;
  p["X_11"]=-0.090580337980363;
  p["X_12"]=-0.08956408577659;
  p["X_13"]=-0.089576497236633;
  p["X_14"]=-0.090618406660374;
  p["X_15"]=-0.09276112281222;
  p["X_16"]=-0.096159341080863;
  p["X_17"]=-0.10108143619853;
  p["X_18"]=-0.10796902395697;
  p["X_19"]=-0.11755259463163;
  p["X_20"]=-0.13108435868405;
  p["X_21"]=-0.15083404013491;
  p["X_22"]=-0.18121280672505;
  p["X_23"]=-0.23148524272195;
  p["X_24"]=-0.32270252375015;
  p["X_25"]=-0.5;

  p["TAU_0"]=0;
  p["TAU_1"]=0.3203125;
  p["TAU_2"]=0.640625;
  p["TAU_3"]=0.9609375;
  p["TAU_4"]=1.28125;
  p["TAU_5"]=1.6015625;
  p["TAU_6"]=1.921875;
  p["TAU_7"]=2.2421875;
  p["TAU_8"]=2.5625;
  p["TAU_9"]=2.8828125;
  p["TAU_10"]=3.203125;
  p["TAU_11"]=3.5234375;
  p["TAU_12"]=3.84375;
  p["TAU_13"]=4.1640625;
  p["TAU_14"]=4.484375;
  p["TAU_15"]=4.8046875;
  p["TAU_16"]=5.125;
  p["TAU_17"]=5.4453125;
  p["TAU_18"]=5.765625;
  p["TAU_19"]=6.0859375;
  p["TAU_20"]=6.40625;
  p["TAU_21"]=6.7265625;
  p["TAU_22"]=7.046875;
  p["TAU_23"]=7.3671875;
  p["TAU_24"]=7.6875;
  p["TAU_25"]=8;

  p["SIGMA_0"]=1e-6;
  p["SIGMA_1"]=1e-6;
  p["SIGMA_2"]=1e-6;
  p["SIGMA_3"]=1e-6;
  p["SIGMA_4"]=1e-6;
  p["SIGMA_5"]=1e-6;
  p["SIGMA_6"]=1e-6;
  p["SIGMA_7"]=1e-6;
  p["SIGMA_8"]=1e-6;
  p["SIGMA_9"]=1e-6;
  p["SIGMA_10"]=1e-6;
  p["SIGMA_11"]=1e-6;
  p["SIGMA_12"]=1e-6;
  p["SIGMA_13"]=1e-6;
  p["SIGMA_14"]=1e-6;
  p["SIGMA_15"]=1e-6;
  p["SIGMA_16"]=1e-06;
  p["SIGMA_17"]=1e-06;
  p["SIGMA_18"]=1e-06;
  p["SIGMA_19"]=1e-06;
  p["SIGMA_20"]=1e-06;
  p["SIGMA_21"]=1e-06;
  p["SIGMA_22"]=1e-06;
  p["SIGMA_23"]=1e-06;
  p["SIGMA_24"]=1e-06;
  p["SIGMA_25"]=1e-06;



  //setup params given above data
  MaxEntParameters param(p);
  MaxEntParameters * pp = &param;

  //backcontinue saved output
  vector_type A = getA();    
  Backcont bc(pp);
  vector_type G = bc.backcontinue(A);

  //sensibility check
  EXPECT_EQ(G.size(),ndat);

  //check that backcont is right to first order
  const double threshold = 0.1;
  for(int i=0;i<ndat;i++){
    double err = std::abs(G(i)-(pp->y(i)*pp->sigma(i)));
    EXPECT_EQ(err<threshold,true);
  }

  //check high frequency term
  EXPECT_NEAR(-1,G(0) + G(ndat-1),0.01);
}
